/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: MockBundle.java 20576 2010-11-09 09:45:52Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.service.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class MockBundle implements Bundle {

    private BundleContext bundleContext;
    private long bundleId;
    private String bundleSymbolicName;
    private Hashtable headers = new Hashtable();

    MockBundle(BundleContext bundleContext, long bundleId, String bundleSymbolicName) {
        this.bundleContext = bundleContext;
        this.bundleId = bundleId;
        this.bundleSymbolicName = bundleSymbolicName;
    }

    public BundleContext getBundleContext() {
        return bundleContext;
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        return new Enumeration() {

            public boolean hasMoreElements() {
                return false;
            }

            public java.lang.Object nextElement() {
                throw new NoSuchElementException();
            }
        };
    }

    public long getBundleId() {
        return bundleId;
    }

    public URL getEntry(String name) {
        return getResource(name);
    }

    public Enumeration getEntryPaths(String path) {
        return null;
    }

    public Dictionary getHeaders() {
        return headers;
    }

    public Dictionary getHeaders(String locale) {
        return headers;
    }

    public long getLastModified() {
        return 0;
    }

    public String getLocation() {
        return "mock";
    }

    public ServiceReference[] getRegisteredServices() {
        return null;
    }

    public URL getResource(String name) {
        return getClass().getClassLoader().getResource(name);
    }

    public Enumeration getResources(String name) throws IOException {
        return getClass().getClassLoader().getResources(name);
    }

    public ServiceReference[] getServicesInUse() {
        return null;
    }

    public Map getSignerCertificates(int i) {
        return Collections.EMPTY_MAP;
    }

    public int getState() {
        return Bundle.ACTIVE;
    }

    public String getSymbolicName() {
        return bundleSymbolicName;
    }

    public boolean hasPermission(java.lang.Object permission) {
        return true;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return getClass().getClassLoader().loadClass(name);
    }

    public void start() {
    }

    public void start(int i) throws BundleException {
    }

    public void stop() {
    }

    public void stop(int i) throws BundleException {
    }

    public void uninstall() {
    }

    public void update() {
    }

    public void update(InputStream in) {
    }

    public Version getVersion() {
        return new Version(0, 0, 0);
    }
}
