/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OsgiHttpServiceCXFServlet.java 22122 2012-02-18 19:39:24Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.cxf.servlet;

import javax.servlet.ServletConfig;

import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.apache.cxf.transport.servlet.ServletDestinationFactory;

/**
 * @author Guillaume Porcher
 */
public class OsgiHttpServiceCXFServlet extends CXFNonSpringServlet {

    private final String context;

    public OsgiHttpServiceCXFServlet(final String context) {
        this.context = context;
    }

    @Override
    public void loadBus(final ServletConfig servletConfig) {
        super.loadBus(servletConfig);

        final Bus bus = this.getBus();
        // Use the ServletDestinationFactory (else CXF will by default look for Jetty)
        final HttpDestinationFactory destinationFactory = new ServletDestinationFactory();
        bus.setExtension(destinationFactory, HttpDestinationFactory.class);

        // Use the OsgiCxfServletTransportFactory (which knows the servlet path)
        final DestinationFactoryManager dfm = bus.getExtension(DestinationFactoryManager.class);
        final HTTPTransportFactory df = new OsgiCxfServletTransportFactory(bus, this.context);
        try {
            registerTransportFactory(dfm, "http://cxf.apache.org/transports/http", df);
            registerTransportFactory(dfm, "http://cxf.apache.org/transports/http/configuration", df);
        } catch (BusException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void registerTransportFactory(final DestinationFactoryManager dfm,
        final String name, final DestinationFactory df) throws BusException {
        DestinationFactory oldDf = dfm.getDestinationFactory(name);
        if (oldDf == null) {
            throw new IllegalStateException(
                "CXF did not instanciate factory " + name);
        }
        dfm.deregisterDestinationFactory(name);
        dfm.registerDestinationFactory(name, df);
    }

}
