/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CamelServiceTest.java 19554 2010-03-26 13:32:34Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.service.itests;

import java.io.File;
import java.io.FileOutputStream;
import java.util.UUID;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CamelServiceTest {

    private int timeout;

    private File jonasLogs;

    private File jonasTemp;

    @Before
    public void setUp() throws Exception {

        String jonasBase = System.getProperty("jonas.base");
        Assert.assertNotNull("jonas.base is not set!", jonasBase);
        File jonasBaseFile = new File(jonasBase);
        Assert.assertTrue(jonasBaseFile + " is not a directory", jonasBaseFile.isDirectory());
        this.jonasLogs = new File(jonasBaseFile, "logs");
        Assert.assertTrue(this.jonasLogs + " is not a directory", this.jonasLogs.isDirectory());

        this.jonasTemp = new File(jonasBaseFile, "work");
        Assert.assertTrue(this.jonasTemp + " is not a directory", this.jonasTemp.isDirectory());
        String timeout = System.getProperty("timeout");
        this.timeout = Integer.parseInt(timeout);
    }

    @Test
    public void testCamelContextInjection() throws Exception {
        String message = UUID.randomUUID().toString();
        File logFile = new File(this.jonasLogs, message);

        Assert.assertFalse(logFile + " already exists", logFile.isFile());

        File inDir = new File(this.jonasTemp, "in");
        inDir.mkdir();

        File inFile = File.createTempFile("test", null, inDir);
        inFile.deleteOnExit();
        FileOutputStream fout = new FileOutputStream(inFile);
        fout.write(message.getBytes());
        fout.close();

        final long stopTime = System.currentTimeMillis() + this.timeout * 1000;
        while (System.currentTimeMillis() < stopTime) {
            if (logFile.isFile()) {
                return;
            }
        }

        Assert.fail(logFile + " does not exist");
    }

    @Test
    public void testCamelServiceGetContext() throws Exception {
        String message = UUID.randomUUID().toString();
        File logFile = new File(this.jonasLogs, message);

        Assert.assertFalse(logFile + " already exists", logFile.isFile());

        File inDir = new File(this.jonasTemp, "inService");
        inDir.mkdir();

        File inFile = File.createTempFile("test", null, inDir);
        inFile.deleteOnExit();
        FileOutputStream fout = new FileOutputStream(inFile);
        fout.write(message.getBytes());
        fout.close();

        final long stopTime = System.currentTimeMillis() + this.timeout * 1000;
        while (System.currentTimeMillis() < stopTime) {
            if (logFile.isFile()) {
                return;
            }
        }

        Assert.fail(logFile + " does not exist");
    }

    @Test
    public void testCamelServiceStartAndGetContext() throws Exception {
        String message = UUID.randomUUID().toString();
        File logFile = new File(this.jonasLogs, message);

        Assert.assertFalse(logFile + " already exists", logFile.isFile());

        File inDir = new File(this.jonasTemp, "inService2");
        inDir.mkdir();

        File inFile = File.createTempFile("test", null, inDir);
        inFile.deleteOnExit();
        FileOutputStream fout = new FileOutputStream(inFile);
        fout.write(message.getBytes());
        fout.close();

        final long stopTime = System.currentTimeMillis() + this.timeout * 1000;
        while (System.currentTimeMillis() < stopTime) {
            if (logFile.isFile()) {
                return;
            }
        }

        Assert.fail(logFile + " does not exist");
    }
}
