/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CxfTest.java 21418 2011-06-10 21:52:49Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.camel.example.cxf.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;

import org.apache.commons.io.FileUtils;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.jonas.camel.example.cxf.webservice.api.ISayHello;

public class CxfTest {

    private int port;

    private String jonasBase;

    private int timeout;

    @Before
    public void setUp() throws Exception {
        String webcontainerPort = System.getProperty("webcontainer.port");
        Assert.assertNotNull("webcontainer.port is not set!", webcontainerPort);
        this.port = Integer.parseInt(webcontainerPort);

        this.jonasBase = System.getProperty("jonas.base");
        Assert.assertNotNull("jonas.base is not set!", this.jonasBase);

        String timeout = System.getProperty("timeout");
        Assert.assertNotNull("timeout is not set!", webcontainerPort);
        this.timeout = Integer.parseInt(timeout);
    }

    @Test
    public void testDeployCXFExample() throws Exception {
        // wait for the WS to get deployed
        String remoteContent = "";
        final long stopTime = System.currentTimeMillis() + this.timeout * 1000;
        final URL remoteURL = new URL("http://localhost:" + this.port + "/services/SayHello?wsdl");
        while (System.currentTimeMillis() < stopTime) {
            Thread.sleep(1000);
            remoteContent = this.getContentAsString(remoteURL);
            if (remoteContent.contains("http://schemas.xmlsoap.org/wsdl/")) {
                return;
            }
        }

        Assert.fail("did not receive any wsdl! content was:\n" + remoteContent);
    }

    @Test
    public void testCXFExampleRoute() throws Exception {
        String message = UUID.randomUUID().toString();

        ClientProxyFactoryBean factory = new ClientProxyFactoryBean();
        factory.setServiceClass(ISayHello.class);
        factory.setAddress("http://localhost:" + this.port + "/services/SayHello");
        ISayHello client = (ISayHello) factory.create();

        String response = client.hello(message);
        Assert.assertEquals("hello, " + message, response);
    }

    @Test
    public void testCXFFileRoute() throws Exception {
        String message = UUID.randomUUID().toString();
        File itestRequest = new File(this.jonasBase + "/target/fileToHelloService/requests/itest.txt").getAbsoluteFile();
        File itestResponse = new File(this.jonasBase + "/target/fileToHelloService/responses/itest.txt").getAbsoluteFile();

        FileUtils.writeStringToFile(itestRequest, message);

        final long stopTime = System.currentTimeMillis() + this.timeout * 1000;
        while (System.currentTimeMillis() < stopTime) {
            Thread.sleep(1000);
            if (itestResponse.length() > 0) {
                String response = FileUtils.readFileToString(itestResponse);
                Assert.assertEquals("hello, " + message, response);
                return;
            }
        }

        Assert.fail(itestResponse + " does not exist");
    }

    private String getContentAsString(final URL url) {
        try {
            final InputStream inStream = url.openStream();
            final ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                int c;
                while ((c = inStream.read()) != -1) {
                    bos.write(c);
                }
            } finally {
                inStream.close();
                bos.flush();
            }
            final String urlString = bos.toString();
            return urlString;
        } catch (IOException e) {
            return e.toString();
        }
    }
}
