/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.IsSingleton;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.impl.DefaultComponentResolver;
import org.apache.camel.impl.DefaultConsumerTemplate;
import org.apache.camel.impl.DefaultDataFormatResolver;
import org.apache.camel.impl.DefaultFactoryFinderResolver;
import org.apache.camel.impl.DefaultInflightRepository;
import org.apache.camel.impl.DefaultLanguageResolver;
import org.apache.camel.impl.DefaultNodeIdFactory;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.camel.impl.DefaultRouteStartupOrder;
import org.apache.camel.impl.DefaultShutdownStrategy;
import org.apache.camel.impl.InterceptSendToEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.impl.RouteService;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.SharedProducerServicePool;
import org.apache.camel.impl.WebSpherePackageScanClassResolver;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.management.DefaultManagementAgent;
import org.apache.camel.management.DefaultManagementLifecycleStrategy;
import org.apache.camel.management.DefaultManagementStrategy;
import org.apache.camel.management.ManagedManagementStrategy;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.processor.interceptor.StreamCaching;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.ServicePool;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionInjector;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCamelContext
extends ServiceSupport
implements CamelContext {
    private static final transient Log LOG = LogFactory.getLog(DefaultCamelContext.class);
    private static final String NAME_PREFIX = "camel-";
    private static int nameSuffix;
    private ClassLoader applicationContextClassLoader;
    private boolean routeDefinitionInitiated;
    private String name;
    private final Map<String, Endpoint> endpoints = new LRUCache<String, Endpoint>(1000);
    private final AtomicInteger endpointKeyCounter = new AtomicInteger();
    private final List<EndpointStrategy> endpointStrategies = new ArrayList<EndpointStrategy>();
    private final Map<String, Component> components = new HashMap<String, Component>();
    private List<Route> routes;
    private final List<Service> servicesToClose = new ArrayList<Service>();
    private TypeConverter typeConverter;
    private TypeConverterRegistry typeConverterRegistry;
    private Injector injector;
    private ComponentResolver componentResolver;
    private boolean autoCreateComponents = true;
    private LanguageResolver languageResolver = new DefaultLanguageResolver();
    private final Map<String, Language> languages = new HashMap<String, Language>();
    private Registry registry;
    private List<LifecycleStrategy> lifecycleStrategies = new ArrayList<LifecycleStrategy>();
    private ManagementStrategy managementStrategy;
    private AtomicBoolean managementStrategyInitialized = new AtomicBoolean(false);
    private final List<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
    private List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private boolean firstStartDone;
    private Boolean autoStartup = Boolean.TRUE;
    private Boolean trace = Boolean.FALSE;
    private Boolean streamCache = Boolean.FALSE;
    private Boolean handleFault = Boolean.FALSE;
    private Boolean disableJMX = Boolean.FALSE;
    private Long delay;
    private ErrorHandlerBuilder errorHandlerBuilder;
    private Map<String, DataFormatDefinition> dataFormats = new HashMap<String, DataFormatDefinition>();
    private DataFormatResolver dataFormatResolver = new DefaultDataFormatResolver();
    private Map<String, String> properties = new HashMap<String, String>();
    private FactoryFinderResolver factoryFinderResolver = new DefaultFactoryFinderResolver();
    private FactoryFinder defaultFactoryFinder;
    private final Map<String, FactoryFinder> factories = new HashMap<String, FactoryFinder>();
    private final Map<String, RouteService> routeServices = new LinkedHashMap<String, RouteService>();
    private ClassResolver classResolver = new DefaultClassResolver();
    private PackageScanClassResolver packageScanClassResolver;
    private ServicePool<Endpoint, Producer> producerServicePool = new SharedProducerServicePool(100);
    private NodeIdFactory nodeIdFactory = new DefaultNodeIdFactory();
    private Tracer defaultTracer;
    private InflightRepository inflightRepository = new DefaultInflightRepository();
    private final List<RouteStartupOrder> routeStartupOrder = new ArrayList<RouteStartupOrder>();
    private int defaultRouteStartupOrder = 1000;
    private ShutdownStrategy shutdownStrategy = new DefaultShutdownStrategy();
    private ShutdownRoute shutdownRoute = ShutdownRoute.Default;
    private ShutdownRunningTask shutdownRunningTask = ShutdownRunningTask.CompleteCurrentTaskOnly;

    public DefaultCamelContext() {
        this.name = NAME_PREFIX + ++nameSuffix;
        if (WebSpherePackageScanClassResolver.isWebSphereClassLoader(this.getClass().getClassLoader())) {
            LOG.info((Object)"Using WebSphere specific PackageScanClassResolver");
            this.packageScanClassResolver = new WebSpherePackageScanClassResolver("META-INF/services/org/apache/camel/TypeConverter");
        } else {
            this.packageScanClassResolver = new DefaultPackageScanClassResolver();
        }
    }

    public DefaultCamelContext(Context jndiContext) {
        this();
        this.setJndiContext(jndiContext);
    }

    public DefaultCamelContext(Registry registry) {
        this();
        this.registry = registry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Component hasComponent(String componentName) {
        return this.components.get(componentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponent(String componentName, Component component) {
        ObjectHelper.notNull(component, "component");
        Map<String, Component> map = this.components;
        synchronized (map) {
            if (this.components.containsKey(componentName)) {
                throw new IllegalArgumentException("Cannot add component as its already previously added: " + componentName);
            }
            component.setCamelContext(this);
            this.components.put(componentName, component);
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onComponentAdd(componentName, component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponent(String name) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            Component component = this.components.get(name);
            if (component == null && this.autoCreateComponents) {
                try {
                    component = this.getComponentResolver().resolveComponent(name, this);
                    if (component != null) {
                        this.addComponent(name, component);
                        if (this.isStarted() || this.isStarting()) {
                            this.startServices(component);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Could not auto create component: " + name, e);
                }
            }
            return component;
        }
    }

    @Override
    public <T extends Component> T getComponent(String name, Class<T> componentType) {
        Component component = this.getComponent(name);
        if (componentType.isInstance(component)) {
            return (T)((Component)componentType.cast(component));
        }
        throw new IllegalArgumentException("The component is not of type: " + componentType + " but is: " + component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Component removeComponent(String componentName) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            Component answer = this.components.remove(componentName);
            if (answer != null) {
                for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                    strategy.onComponentRemove(componentName, answer);
                }
            }
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getOrCreateComponent(String componentName, Callable<Component> factory) {
        Map<String, Component> map = this.components;
        synchronized (map) {
            Component component = this.components.get(componentName);
            if (component == null) {
                try {
                    component = factory.call();
                    if (component == null) {
                        throw new RuntimeCamelException("Factory failed to create the " + componentName + " component, it returned null.");
                    }
                    this.components.put(componentName, component);
                    component.setCamelContext(this);
                    for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                        strategy.onComponentAdd(componentName, component);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Factory failed to create the " + componentName + " component", e);
                }
            }
            return component;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Endpoint> getEndpoints() {
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            return new ArrayList<Endpoint>(this.endpoints.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Endpoint> getEndpointMap() {
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            return new TreeMap<String, Endpoint>(this.endpoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint hasEndpoint(String uri) {
        try {
            uri = URISupport.normalizeUri(uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, e);
        }
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            return this.endpoints.get(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Endpoint> getEndpoints(String uri) {
        ArrayList<Endpoint> coll;
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            Endpoint ep = this.endpoints.get(uri);
            if (ep != null) {
                answer.add(ep);
                return answer;
            }
            coll = new ArrayList<Endpoint>(this.endpoints.values());
        }
        for (Endpoint ep : coll) {
            if (ep.isSingleton() || !uri.equals(ep.getEndpointUri())) continue;
            answer.add(ep);
        }
        return answer;
    }

    @Override
    public Collection<Endpoint> getSingletonEndpoints() {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Collection<Endpoint> coll = this.getEndpoints();
        for (Endpoint ep : coll) {
            if (!ep.isSingleton()) continue;
            answer.add(ep);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint addEndpoint(String uri, Endpoint endpoint) throws Exception {
        Endpoint oldEndpoint;
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            this.startServices(endpoint);
            oldEndpoint = this.endpoints.remove(uri);
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onEndpointAdd(endpoint);
            }
            this.addEndpointToRegistry(uri, endpoint);
            if (oldEndpoint != null) {
                this.stopServices(oldEndpoint);
            }
        }
        return oldEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Endpoint> removeEndpoints(String uri) throws Exception {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            Endpoint oldEndpoint = this.endpoints.remove(uri);
            if (oldEndpoint != null) {
                answer.add(oldEndpoint);
                this.stopServices(oldEndpoint);
                for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                    strategy.onEndpointRemove(oldEndpoint);
                }
            } else {
                ArrayList<Map.Entry<String, Endpoint>> worklist = new ArrayList<Map.Entry<String, Endpoint>>();
                for (Map.Entry<String, Endpoint> entry : this.endpoints.entrySet()) {
                    oldEndpoint = entry.getValue();
                    if (oldEndpoint.isSingleton() || !uri.equals(oldEndpoint.getEndpointUri())) continue;
                    worklist.add(entry);
                }
                for (Map.Entry<String, Endpoint> entry : worklist) {
                    oldEndpoint = entry.getValue();
                    answer.add(oldEndpoint);
                    this.stopServices(oldEndpoint);
                    this.endpoints.remove(entry.getKey());
                    for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                        strategy.onEndpointRemove(oldEndpoint);
                    }
                }
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint getEndpoint(String uri) {
        Endpoint answer;
        ObjectHelper.notEmpty(uri, "uri");
        try {
            uri = URISupport.normalizeUri(uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Getting endpoint with uri: " + uri));
        }
        String scheme = null;
        Map<String, Endpoint> map = this.endpoints;
        synchronized (map) {
            answer = this.endpoints.get(uri);
            if (answer == null) {
                try {
                    Component component;
                    String[] splitURI = ObjectHelper.splitOnCharacter(uri, ":", 2);
                    if (splitURI[1] != null && (component = this.getComponent(scheme = splitURI[0])) != null && (answer = component.createEndpoint(uri)) != null && LOG.isDebugEnabled()) {
                        LOG.debug((Object)(uri + " converted to endpoint: " + answer + " by component: " + component));
                    }
                    if (answer == null) {
                        answer = this.createEndpoint(uri);
                    }
                    if (answer != null) {
                        this.addService(answer);
                        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                            strategy.onEndpointAdd(answer);
                        }
                        answer = this.addEndpointToRegistry(uri, answer);
                    }
                }
                catch (Exception e) {
                    throw new ResolveEndpointFailedException(uri, e);
                }
            }
        }
        if (answer == null && scheme != null) {
            throw new ResolveEndpointFailedException(uri, "No component found with scheme: " + scheme);
        }
        return answer;
    }

    @Override
    public <T extends Endpoint> T getEndpoint(String name, Class<T> endpointType) {
        Endpoint endpoint = this.getEndpoint(name);
        if (endpoint instanceof InterceptSendToEndpoint) {
            endpoint = ((InterceptSendToEndpoint)endpoint).getDelegate();
        }
        if (endpointType.isInstance(endpoint)) {
            return (T)((Endpoint)endpointType.cast(endpoint));
        }
        throw new IllegalArgumentException("The endpoint is not of type: " + endpointType + " but is: " + endpoint.getClass().getCanonicalName());
    }

    @Override
    public void addRegisterEndpointCallback(EndpointStrategy strategy) {
        if (!this.endpointStrategies.contains(strategy)) {
            this.endpointStrategies.add(strategy);
            for (Endpoint endpoint : this.getEndpoints()) {
                Endpoint newEndpoint = strategy.registerEndpoint(endpoint.getEndpointUri(), endpoint);
                if (newEndpoint == endpoint) continue;
                this.endpoints.put(this.getEndpointKey(newEndpoint.getEndpointUri(), newEndpoint), newEndpoint);
            }
        }
    }

    protected Endpoint addEndpointToRegistry(String uri, Endpoint endpoint) {
        for (EndpointStrategy strategy : this.endpointStrategies) {
            endpoint = strategy.registerEndpoint(uri, endpoint);
        }
        this.endpoints.put(this.getEndpointKey(uri, endpoint), endpoint);
        return endpoint;
    }

    public List<RouteStartupOrder> getRouteStartupOrder() {
        return this.routeStartupOrder;
    }

    @Override
    public synchronized List<Route> getRoutes() {
        if (this.routes == null) {
            this.routes = new ArrayList<Route>();
        }
        return new ArrayList<Route>(this.routes);
    }

    public void setRoutes(List<Route> routes) {
        this.routes = routes;
        throw new UnsupportedOperationException("Overriding existing routes is not supported yet, use addRoutes instead");
    }

    synchronized void removeRouteCollection(Collection<Route> routes) {
        if (this.routes != null) {
            this.routes.removeAll(routes);
        }
    }

    synchronized void addRouteCollection(Collection<Route> routes) throws Exception {
        if (this.routes == null) {
            this.routes = new ArrayList<Route>();
        }
        if (routes != null) {
            this.routes.addAll(routes);
        }
    }

    @Override
    public void addRoutes(RoutesBuilder builder) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding routes from builder: " + builder));
        }
        builder.addRoutesToCamelContext(this);
    }

    @Override
    public void addRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        for (RouteDefinition routeDefinition : routeDefinitions) {
            routeDefinition.setCamelContext(this);
            this.removeRouteDefinition(routeDefinition);
        }
        this.routeDefinitions.addAll(routeDefinitions);
        if (this.shouldStartRoutes()) {
            this.startRouteDefinitions(routeDefinitions);
        }
    }

    public boolean removeRouteDefinition(String key) {
        boolean answer = false;
        Iterator<RouteDefinition> iter = this.routeDefinitions.iterator();
        while (iter.hasNext()) {
            RouteDefinition route = iter.next();
            if (!route.idOrCreate(this.nodeIdFactory).equals(key)) continue;
            iter.remove();
            answer = true;
        }
        return answer;
    }

    @Override
    public void removeRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        this.routeDefinitions.removeAll(routeDefinitions);
        for (RouteDefinition routeDefinition : routeDefinitions) {
            this.removeRouteDefinition(routeDefinition);
        }
    }

    public void removeRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        String key = routeDefinition.idOrCreate(this.nodeIdFactory);
        this.stopRoute(key);
        this.routeServices.remove(key);
        this.removeRouteDefinition(key);
    }

    @Override
    public ServiceStatus getRouteStatus(RouteDefinition route) {
        return this.getRouteStatus(route.idOrCreate(this.nodeIdFactory));
    }

    @Override
    public ServiceStatus getRouteStatus(String key) {
        RouteService routeService = this.routeServices.get(key);
        if (routeService != null) {
            return routeService.getStatus();
        }
        return null;
    }

    @Override
    public void startRoute(RouteDefinition route) throws Exception {
        ArrayList<Route> routes = new ArrayList<Route>();
        List<RouteContext> routeContexts = route.addRoutes(this, routes);
        RouteService routeService = new RouteService(this, route, routeContexts, routes);
        this.startRouteService(routeService);
    }

    @Override
    public synchronized void startRoute(String routeId) throws Exception {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            routeService.start();
        }
    }

    @Override
    public void stopRoute(RouteDefinition route) throws Exception {
        this.stopRoute(route.idOrCreate(this.nodeIdFactory));
    }

    @Override
    public synchronized void stopRoute(String key) throws Exception {
        RouteService routeService = this.routeServices.get(key);
        if (routeService != null) {
            routeService.stop();
        }
    }

    @Override
    public void addService(Object object) throws Exception {
        if (object instanceof Service) {
            Service service = (Service)object;
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onServiceAdd(this, service, null);
            }
            this.servicesToClose.add(service);
        }
        this.startServices(object);
    }

    @Override
    public boolean hasService(Object object) {
        if (object instanceof Service) {
            return this.servicesToClose.contains(object);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Language resolveLanguage(String language) {
        Language answer;
        Map<String, Language> map = this.languages;
        synchronized (map) {
            boolean singleton;
            answer = this.languages.get(language);
            if (answer instanceof IsSingleton && (singleton = ((IsSingleton)((Object)answer)).isSingleton())) {
                return answer;
            }
            answer = this.getLanguageResolver().resolveLanguage(language, this);
            if (answer != null) {
                this.languages.put(language, answer);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeConverter getTypeConverter() {
        if (this.typeConverter == null) {
            DefaultCamelContext defaultCamelContext = this;
            synchronized (defaultCamelContext) {
                this.typeConverter = this.createTypeConverter();
                try {
                    this.addService(this.typeConverter);
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }
        }
        return this.typeConverter;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    @Override
    public TypeConverterRegistry getTypeConverterRegistry() {
        if (this.typeConverterRegistry == null) {
            if (this.typeConverter == null) {
                this.getTypeConverter();
            }
            if (this.typeConverter instanceof DefaultTypeConverter) {
                this.typeConverterRegistry = (DefaultTypeConverter)this.typeConverter;
            }
        }
        return this.typeConverterRegistry;
    }

    public void setTypeConverterRegistry(TypeConverterRegistry typeConverterRegistry) {
        this.typeConverterRegistry = typeConverterRegistry;
    }

    @Override
    public Injector getInjector() {
        if (this.injector == null) {
            this.injector = this.createInjector();
        }
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public ComponentResolver getComponentResolver() {
        if (this.componentResolver == null) {
            this.componentResolver = this.createComponentResolver();
        }
        return this.componentResolver;
    }

    public void setComponentResolver(ComponentResolver componentResolver) {
        this.componentResolver = componentResolver;
    }

    public LanguageResolver getLanguageResolver() {
        return this.languageResolver;
    }

    public void setLanguageResolver(LanguageResolver languageResolver) {
        this.languageResolver = languageResolver;
    }

    public boolean isAutoCreateComponents() {
        return this.autoCreateComponents;
    }

    public void setAutoCreateComponents(boolean autoCreateComponents) {
        this.autoCreateComponents = autoCreateComponents;
    }

    @Override
    public Registry getRegistry() {
        if (this.registry == null) {
            this.registry = this.createRegistry();
        }
        return this.registry;
    }

    public void setJndiContext(Context jndiContext) {
        this.setRegistry(new JndiRegistry(jndiContext));
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public List<LifecycleStrategy> getLifecycleStrategies() {
        return this.lifecycleStrategies;
    }

    public void setLifecycleStrategies(List<LifecycleStrategy> lifecycleStrategies) {
        this.lifecycleStrategies = lifecycleStrategies;
    }

    @Override
    public void addLifecycleStrategy(LifecycleStrategy lifecycleStrategy) {
        this.lifecycleStrategies.add(lifecycleStrategy);
    }

    @Override
    public List<RouteDefinition> getRouteDefinitions() {
        return this.routeDefinitions;
    }

    @Override
    public RouteDefinition getRouteDefinition(String id) {
        for (RouteDefinition route : this.routeDefinitions) {
            if (!route.getId().equals(id)) continue;
            return route;
        }
        return null;
    }

    @Override
    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void setInterceptStrategies(List<InterceptStrategy> interceptStrategies) {
        this.interceptStrategies = interceptStrategies;
    }

    @Override
    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        this.getInterceptStrategies().add(interceptStrategy);
        if (interceptStrategy instanceof Tracer) {
            this.setTracing(true);
        } else if (interceptStrategy instanceof HandleFault) {
            this.setHandleFault(true);
        } else if (interceptStrategy instanceof StreamCaching) {
            this.setStreamCaching(true);
        } else if (interceptStrategy instanceof Delayer) {
            this.setDelayer(((Delayer)interceptStrategy).getDelay());
        }
    }

    @Override
    public void setStreamCaching(Boolean cache) {
        this.streamCache = cache;
    }

    @Override
    public Boolean isStreamCaching() {
        return this.streamCache;
    }

    @Override
    public void setTracing(Boolean tracing) {
        this.trace = tracing;
    }

    @Override
    public Boolean isTracing() {
        return this.trace;
    }

    @Override
    public Boolean isHandleFault() {
        return this.handleFault;
    }

    @Override
    public void setHandleFault(Boolean handleFault) {
        this.handleFault = handleFault;
    }

    @Override
    public Long getDelayer() {
        return this.delay;
    }

    @Override
    public void setDelayer(Long delay) {
        this.delay = delay;
    }

    @Override
    public ProducerTemplate createProducerTemplate() {
        return new DefaultProducerTemplate(this);
    }

    @Override
    public ConsumerTemplate createConsumerTemplate() {
        return new DefaultConsumerTemplate(this);
    }

    @Override
    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        return this.errorHandlerBuilder;
    }

    @Override
    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }

    @Override
    public void setProducerServicePool(ServicePool<Endpoint, Producer> producerServicePool) {
        this.producerServicePool = producerServicePool;
    }

    @Override
    public ServicePool<Endpoint, Producer> getProducerServicePool() {
        return this.producerServicePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        boolean doNotStart = !this.firstStartDone && this.isAutoStartup() == false;
        this.firstStartDone = true;
        if (doNotStart) {
            LOG.info((Object)("Cannot start Apache Camel " + this.getVersion() + " (CamelContext:" + this.getName() + ") as it has been configured to not auto start"));
            return;
        }
        super.start();
        LOG.debug((Object)"Starting routes...");
        DefaultCamelContext defaultCamelContext = this;
        synchronized (defaultCamelContext) {
            Route route;
            TreeMap<Integer, DefaultRouteStartupOrder> inputs = new TreeMap<Integer, DefaultRouteStartupOrder>();
            for (RouteService routeService : this.routeServices.values()) {
                Boolean autoStart = routeService.getRouteDefinition().isAutoStartup();
                if (autoStart == null || autoStart.booleanValue()) {
                    try {
                        Integer startupOrder = routeService.getRouteDefinition().getStartupOrder();
                        if (startupOrder == null) {
                            startupOrder = this.defaultRouteStartupOrder++;
                        }
                        route = routeService.getRoutes().iterator().next();
                        DefaultRouteStartupOrder holder = new DefaultRouteStartupOrder(startupOrder, route, routeService);
                        DefaultRouteStartupOrder other = (DefaultRouteStartupOrder)inputs.get(startupOrder);
                        if (other != null) {
                            String otherId = other.getRoute().getId();
                            throw new FailedToStartRouteException(holder.getRoute().getId(), "startupOrder clash. Route " + otherId + " already has startupOrder " + startupOrder + " configured which this route have as well. Please correct startupOrder to be unique among all your routes.");
                        }
                        inputs.put(startupOrder, holder);
                        continue;
                    }
                    catch (FailedToStartRouteException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new FailedToStartRouteException(e);
                    }
                }
                LOG.info((Object)("Cannot start route " + routeService.getId() + " as it is configured with auto startup disabled."));
            }
            for (Map.Entry entry : inputs.entrySet()) {
                RouteService routeService = ((DefaultRouteStartupOrder)entry.getValue()).getRouteService();
                routeService.startInputs(false);
                try {
                    routeService.start();
                }
                finally {
                    routeService.startInputs(true);
                }
            }
            ArrayList<Endpoint> routeInputs = new ArrayList<Endpoint>();
            for (Map.Entry entry : inputs.entrySet()) {
                Integer order = (Integer)entry.getKey();
                route = ((DefaultRouteStartupOrder)entry.getValue()).getRoute();
                RouteService routeService = ((DefaultRouteStartupOrder)entry.getValue()).getRouteService();
                for (Consumer consumer : routeService.getInputs().values()) {
                    Endpoint endpoint = consumer.getEndpoint();
                    boolean multipleConsumersSupported = false;
                    if (endpoint instanceof MultipleConsumersSupport) {
                        multipleConsumersSupported = ((MultipleConsumersSupport)((Object)endpoint)).isMultipleConsumersSupported();
                    }
                    if (!multipleConsumersSupported && routeInputs.contains(endpoint)) {
                        throw new FailedToStartRouteException(routeService.getId(), "Multiple consumers for the same endpoint is not allowed: " + endpoint);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Starting consumer (order: " + order + ") on route: " + route.getId()));
                    }
                    for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                        strategy.onServiceAdd(this, consumer, route);
                    }
                    ServiceHelper.startService(consumer);
                    routeInputs.add(endpoint);
                    this.routeStartupOrder.add((RouteStartupOrder)entry.getValue());
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            for (int i = 0; i < this.getRoutes().size(); ++i) {
                LOG.debug((Object)("Route " + i + ": " + this.getRoutes().get(i)));
            }
            LOG.debug((Object)"... Routes started");
        }
        LOG.info((Object)("Started " + this.getRoutes().size() + " routes"));
        LOG.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext:" + this.getName() + ") started"));
        EventHelper.notifyCamelContextStarted(this);
    }

    @Override
    protected synchronized void doStart() throws Exception {
        LOG.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext:" + this.getName() + ") is starting"));
        try {
            this.doStartCamel();
        }
        catch (Exception e) {
            EventHelper.notifyCamelContextStartupFailed(this, e);
            throw e;
        }
    }

    private void doStartCamel() throws Exception {
        this.startServices(this.producerServicePool);
        if (this.isStreamCaching().booleanValue() && StreamCaching.getStreamCaching(this) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"StreamCaching is enabled");
            }
            this.addInterceptStrategy(new StreamCaching());
        }
        if (this.isTracing().booleanValue()) {
            LOG.debug((Object)"Tracing is enabled");
        }
        if (this.isHandleFault().booleanValue() && HandleFault.getHandleFault(this) == null) {
            LOG.debug((Object)"HandleFault is enabled");
            this.addInterceptStrategy(new HandleFault());
        }
        if (this.getDelayer() != null && this.getDelayer() > 0L && Delayer.getDelayer(this) == null) {
            long millis = this.getDelayer();
            LOG.debug((Object)("Delayer is enabled with: " + millis + " ms."));
            this.addInterceptStrategy(new Delayer(millis));
        }
        this.getManagementStrategy().start();
        Iterator<LifecycleStrategy> it = this.lifecycleStrategies.iterator();
        while (it.hasNext()) {
            LifecycleStrategy strategy = it.next();
            try {
                strategy.onContextStart(this);
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot start lifecycle strategy: " + strategy + ". This strategy will be removed. Cause " + e.getMessage()), (Throwable)e);
                it.remove();
            }
        }
        EventHelper.notifyCamelContextStarting(this);
        this.forceLazyInitialization();
        this.startServices(this.components.values());
        this.addService(this.inflightRepository);
        this.addService(this.shutdownStrategy);
        if (!this.routeDefinitionInitiated) {
            this.startRouteDefinitions(this.routeDefinitions);
            this.routeDefinitionInitiated = true;
        }
    }

    @Override
    protected synchronized void doStop() throws Exception {
        LOG.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext:" + this.getName() + ") is stopping"));
        EventHelper.notifyCamelContextStopping(this);
        this.shutdownStrategy.shutdown(this, this.getRouteStartupOrder());
        this.getRouteStartupOrder().clear();
        this.stopServices(this.routeServices.values());
        this.stopServices(this.servicesToClose);
        this.servicesToClose.clear();
        this.stopServices(this.endpoints.values());
        this.endpoints.clear();
        this.stopServices(this.components.values());
        this.components.clear();
        if (this.producerServicePool instanceof SharedProducerServicePool) {
            ((SharedProducerServicePool)this.producerServicePool).shutdown(this);
        } else {
            this.stopServices(this.producerServicePool);
        }
        this.stopServices(this.inflightRepository);
        try {
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onContextStop(this);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Cannot stop lifecycle strategies: " + e.getMessage()));
        }
        EventHelper.notifyCamelContextStopped(this);
        this.stopServices(this.getManagementStrategy());
        LOG.info((Object)("Apache Camel " + this.getVersion() + " (CamelContext:" + this.getName() + ") stopped"));
    }

    private void stopServices(Object service) throws Exception {
        try {
            ServiceHelper.stopService(service);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error occurred while stopping service: " + service + ". This exception will be ignored."));
            EventHelper.notifyServiceStopFailure(this, service, e);
        }
    }

    private void stopServices(Collection<?> services) throws Exception {
        this.stopServices(services, true);
    }

    private void stopServices(Collection<?> services, boolean reverse) throws Exception {
        Collection list = CastUtils.cast(services);
        if (reverse) {
            ArrayList reverseList = new ArrayList(services);
            Collections.reverse(reverseList);
            list = reverseList;
        }
        for (Object service : list) {
            this.stopServices(service);
        }
    }

    private void startServices(Object service) throws Exception {
        ServiceHelper.startService(service);
    }

    protected void startRouteDefinitions(Collection<RouteDefinition> list) throws Exception {
        if (list != null) {
            for (RouteDefinition route : list) {
                this.startRoute(route);
            }
        }
    }

    protected synchronized void startRouteService(RouteService routeService) throws Exception {
        String key = routeService.getId();
        ServiceStatus status = this.getRouteStatus(key);
        if (status != null && status.isStarted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Route " + key + " is already started"));
            }
        } else {
            this.routeServices.put(key, routeService);
            if (this.shouldStartRoutes()) {
                routeService.start();
            }
        }
    }

    protected void forceLazyInitialization() {
        this.getInjector();
        this.getLanguageResolver();
        this.getTypeConverter();
    }

    protected TypeConverter createTypeConverter() {
        DefaultTypeConverter answer = new DefaultTypeConverter(this.packageScanClassResolver, this.getInjector(), this.getDefaultFactoryFinder());
        this.setTypeConverterRegistry(answer);
        return answer;
    }

    protected Injector createInjector() {
        FactoryFinder finder = this.getDefaultFactoryFinder();
        try {
            return (Injector)finder.newInstance("Injector");
        }
        catch (NoFactoryAvailableException e) {
            return new ReflectionInjector();
        }
    }

    protected ComponentResolver createComponentResolver() {
        return new DefaultComponentResolver();
    }

    protected Registry createRegistry() {
        return new JndiRegistry();
    }

    protected Endpoint createEndpoint(String uri) {
        Object value = this.getRegistry().lookup(uri);
        if (value instanceof Endpoint) {
            return (Endpoint)value;
        }
        if (value instanceof Processor) {
            return new ProcessorEndpoint(uri, this, (Processor)value);
        }
        if (value != null) {
            return this.convertBeanToEndpoint(uri, value);
        }
        return null;
    }

    protected Endpoint convertBeanToEndpoint(String uri, Object bean) {
        throw new IllegalArgumentException("uri: " + uri + " bean: " + bean + " could not be converted to an Endpoint");
    }

    protected boolean shouldStartRoutes() {
        return this.isStarted() && !this.isStarting();
    }

    @Override
    public void setDataFormats(Map<String, DataFormatDefinition> dataFormats) {
        this.dataFormats = dataFormats;
    }

    @Override
    public Map<String, DataFormatDefinition> getDataFormats() {
        return this.dataFormats;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public FactoryFinder getDefaultFactoryFinder() {
        if (this.defaultFactoryFinder == null) {
            this.defaultFactoryFinder = this.factoryFinderResolver.resolveDefaultFactoryFinder(this.getClassResolver());
        }
        return this.defaultFactoryFinder;
    }

    @Override
    public void setFactoryFinderResolver(FactoryFinderResolver resolver) {
        this.factoryFinderResolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryFinder getFactoryFinder(String path) throws NoFactoryAvailableException {
        Map<String, FactoryFinder> map = this.factories;
        synchronized (map) {
            FactoryFinder answer = this.factories.get(path);
            if (answer == null) {
                answer = this.factoryFinderResolver.resolveFactoryFinder(this.getClassResolver(), path);
                this.factories.put(path, answer);
            }
            return answer;
        }
    }

    @Override
    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    @Override
    public void setClassResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Override
    public PackageScanClassResolver getPackageScanClassResolver() {
        return this.packageScanClassResolver;
    }

    @Override
    public void setPackageScanClassResolver(PackageScanClassResolver packageScanClassResolver) {
        this.packageScanClassResolver = packageScanClassResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getComponentNames() {
        Map<String, Component> map = this.components;
        synchronized (map) {
            ArrayList<String> answer = new ArrayList<String>();
            for (String name : this.components.keySet()) {
                answer.add(name);
            }
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getLanguageNames() {
        Map<String, Language> map = this.languages;
        synchronized (map) {
            ArrayList<String> answer = new ArrayList<String>();
            for (String name : this.languages.keySet()) {
                answer.add(name);
            }
            return answer;
        }
    }

    @Override
    public NodeIdFactory getNodeIdFactory() {
        return this.nodeIdFactory;
    }

    @Override
    public void setNodeIdFactory(NodeIdFactory idFactory) {
        this.nodeIdFactory = idFactory;
    }

    @Override
    public ManagementStrategy getManagementStrategy() {
        if (this.managementStrategyInitialized.compareAndSet(false, true)) {
            this.managementStrategy = this.createManagementStrategy();
        }
        return this.managementStrategy;
    }

    @Override
    public void setManagementStrategy(ManagementStrategy managementStrategy) {
        this.managementStrategy = managementStrategy;
        this.managementStrategyInitialized.set(true);
    }

    @Override
    public InterceptStrategy getDefaultTracer() {
        if (this.defaultTracer == null) {
            this.defaultTracer = new Tracer();
        }
        return this.defaultTracer;
    }

    @Override
    public void disableJMX() {
        this.disableJMX = true;
    }

    @Override
    public InflightRepository getInflightRepository() {
        return this.inflightRepository;
    }

    @Override
    public void setInflightRepository(InflightRepository repository) {
        this.inflightRepository = repository;
    }

    @Override
    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public Boolean isAutoStartup() {
        return this.autoStartup != null && this.autoStartup != false;
    }

    @Override
    public ClassLoader getApplicationContextClassLoader() {
        return this.applicationContextClassLoader;
    }

    @Override
    public void setApplicationContextClassLoader(ClassLoader classLoader) {
        this.applicationContextClassLoader = classLoader;
    }

    @Override
    public DataFormatResolver getDataFormatResolver() {
        return this.dataFormatResolver;
    }

    @Override
    public void setDataFormatResolver(DataFormatResolver dataFormatResolver) {
        this.dataFormatResolver = dataFormatResolver;
    }

    @Override
    public DataFormat resolveDataFormat(String name) {
        return this.dataFormatResolver.resolveDataFormat(name, this);
    }

    @Override
    public DataFormatDefinition resolveDataFormatDefinition(String name) {
        return this.dataFormatResolver.resolveDataFormatDefinition(name, this);
    }

    @Override
    public ShutdownStrategy getShutdownStrategy() {
        return this.shutdownStrategy;
    }

    @Override
    public void setShutdownStrategy(ShutdownStrategy shutdownStrategy) {
        this.shutdownStrategy = shutdownStrategy;
    }

    @Override
    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    @Override
    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    @Override
    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    @Override
    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    protected String getEndpointKey(String uri, Endpoint endpoint) {
        if (endpoint.isSingleton()) {
            return uri;
        }
        int counter = this.endpointKeyCounter.incrementAndGet();
        return uri + ":" + counter;
    }

    protected Map<String, RouteService> getRouteServices() {
        return this.routeServices;
    }

    protected ManagementStrategy createManagementStrategy() {
        DefaultManagementStrategy answer = null;
        if (this.disableJMX.booleanValue() || Boolean.getBoolean("org.apache.camel.jmx.disabled")) {
            LOG.info((Object)"JMX is disabled. Using DefaultManagementStrategy.");
            answer = new DefaultManagementStrategy();
        } else {
            try {
                LOG.info((Object)"JMX enabled. Using DefaultManagedLifecycleStrategy.");
                answer = new ManagedManagementStrategy(new DefaultManagementAgent());
                this.lifecycleStrategies.add(0, new DefaultManagementLifecycleStrategy(this));
            }
            catch (NoClassDefFoundError e) {
                LOG.warn((Object)("Could not find needed classes for JMX lifecycle strategy. Needed class is in spring-context.jar using Spring 2.5 or newer (spring-jmx.jar using Spring 2.0.x). NoClassDefFoundError: " + e.getMessage()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not create JMX lifecycle strategy, caused by: " + e.getMessage()));
            }
        }
        if (answer == null) {
            LOG.warn((Object)"Cannot use JMX. Fallback to using DefaultManagementStrategy.");
            answer = new DefaultManagementStrategy();
        }
        return answer;
    }

    public String toString() {
        return "CamelContext(" + this.getName() + ")";
    }
}

