/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.lang.reflect.Method;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="transacted")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TransactedDefinition
extends OutputDefinition<ProcessorDefinition> {
    @XmlTransient
    public static final String PROPAGATION_REQUIRED = "PROPAGATION_REQUIRED";
    private static final transient Log LOG = LogFactory.getLog(TransactedDefinition.class);
    @XmlTransient
    protected Class<? extends Policy> type = TransactedPolicy.class;
    @XmlAttribute
    protected String ref;
    @XmlTransient
    private Policy policy;

    public TransactedDefinition() {
    }

    public TransactedDefinition(Policy policy) {
        this.policy = policy;
    }

    public String toString() {
        return "Transacted[" + this.description() + "]";
    }

    @Override
    public String getShortName() {
        return "transacted";
    }

    @Override
    public String getLabel() {
        if (this.ref != null) {
            return "transacted[ref:" + this.ref + "]";
        }
        if (this.policy != null) {
            return "transacted[" + this.policy.toString() + "]";
        }
        return "transacted";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setType(Class<? extends Policy> type) {
        this.type = type;
    }

    public TransactedDefinition ref(String ref) {
        this.setRef(ref);
        return this;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createOutputsProcessor(routeContext);
        Policy policy = this.resolvePolicy(routeContext);
        ObjectHelper.notNull(policy, "policy", this);
        return policy.wrap(routeContext, childProcessor);
    }

    protected String description() {
        if (this.policy != null) {
            return this.policy.toString();
        }
        return "ref:" + this.ref;
    }

    protected Policy resolvePolicy(RouteContext routeContext) {
        if (this.policy != null) {
            return this.policy;
        }
        return TransactedDefinition.doResolvePolicy(routeContext, this.getRef(), this.type);
    }

    protected static Policy doResolvePolicy(RouteContext routeContext, String ref, Class<? extends Policy> type) {
        Class<?> tmClazz;
        Policy found;
        Map<String, ? extends Policy> types;
        if (ObjectHelper.isNotEmpty(ref)) {
            return routeContext.lookup(ref, Policy.class);
        }
        Policy answer = null;
        if (type != null && (types = routeContext.lookupByType(type)).size() == 1 && type.isInstance(found = types.values().iterator().next())) {
            return type.cast(found);
        }
        if (type == TransactedPolicy.class) {
            answer = routeContext.lookup(PROPAGATION_REQUIRED, TransactedPolicy.class);
        }
        if (answer == null && type == TransactedPolicy.class && (tmClazz = routeContext.getCamelContext().getClassResolver().resolveClass("org.springframework.transaction.PlatformTransactionManager")) != null) {
            Map<String, ?> maps = routeContext.lookupByType(tmClazz);
            if (maps.size() == 1) {
                Class<?> txClazz;
                Object transactionManager = maps.values().iterator().next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("One instance of PlatformTransactionManager found in registry: " + transactionManager));
                }
                if ((txClazz = routeContext.getCamelContext().getClassResolver().resolveClass("org.apache.camel.spring.spi.SpringTransactionPolicy")) != null) {
                    Method method;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Creating a new temporary SpringTransactionPolicy using the PlatformTransactionManager: " + transactionManager));
                    }
                    TransactedPolicy txPolicy = ObjectHelper.newInstance(txClazz, TransactedPolicy.class);
                    try {
                        method = txClazz.getMethod("setTransactionManager", tmClazz);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeCamelException("Cannot get method setTransactionManager(PlatformTransactionManager) on class: " + txClazz);
                    }
                    ObjectHelper.invokeMethod(method, txPolicy, transactionManager);
                    return txPolicy;
                }
                LOG.warn((Object)"Cannot create a transacted policy as camel-spring.jar is not on the classpath!");
            } else if (LOG.isDebugEnabled()) {
                if (maps.isEmpty()) {
                    LOG.debug((Object)"No PlatformTransactionManager found in registry.");
                } else {
                    LOG.debug((Object)("Found " + maps.size() + " PlatformTransactionManager in registry. " + "Cannot determine which one to use. Please configure a TransactionTemplate on the policy"));
                }
            }
        }
        return answer;
    }
}

