/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.rmi.interceptor.spi.JInitializer;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.security.jacc.handlers.JPolicyContextHandler;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.security.interceptors.jrmp.SecurityInitializer;
import org.ow2.jonas.security.interceptors.jrmp.ctxcheck.Initializer;
import org.ow2.jonas.security.internal.JResources;
import org.ow2.jonas.security.internal.JonasSecurityServiceImplMBean;
import org.ow2.jonas.security.internal.PolicyProvider;
import org.ow2.jonas.security.internal.realm.factory.JResourceDS;
import org.ow2.jonas.security.internal.realm.factory.JResourceLDAP;
import org.ow2.jonas.security.internal.realm.factory.JResourceMemory;
import org.ow2.jonas.security.internal.realm.factory.JResourceRemoteImpl;
import org.ow2.jonas.security.internal.realm.lib.HashHelper;
import org.ow2.jonas.security.internal.realm.principal.Group;
import org.ow2.jonas.security.internal.realm.principal.Role;
import org.ow2.jonas.security.lib.JResourceManager;
import org.ow2.jonas.security.realm.factory.JResource;
import org.ow2.jonas.security.realm.principal.JUser;
import org.ow2.jonas.service.ServiceException;

public class JonasSecurityServiceImpl
extends AbsServiceImpl
implements SecurityService,
JonasSecurityServiceImplMBean,
Pojo {
    private InstanceManager __IM;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.security");
    public static final String REMOTE_RESOUCE = "_remoteres";
    protected static final String CONFIG_FILE = "conf" + File.separator + "jonas-realm.xml";
    private static final String SECURITY_PROPAGATION = "jonas.security.propagation";
    private static final String SEC_CHECK = "jonas.security.context.check";
    private boolean __FjmxService;
    private JmxService jmxService;
    private boolean __FregistryService;
    private RegistryService registryService;
    private boolean __FjResources;
    private JResources jResources;
    private boolean __Fictx;
    private Context ictx;
    private boolean __FbindResourcesIntoJndi;
    private boolean bindResourcesIntoJndi;
    private boolean __FjrmpInterceptors;
    private List<Class<? extends JInitializer>> jrmpInterceptors;
    private boolean __MsetRealmJndiRegistration$boolean;
    private boolean __MremoveJResource$java_lang_String;
    private boolean __MsetRegistryService$org_ow2_jonas_registry_RegistryService;
    private boolean __MgetRegistryService;
    private boolean __MinitJACCPolicyContextHandlers;
    private boolean __MdoStart;
    private boolean __MregisterResourcesMBeans;
    private boolean __MdoStop;
    private boolean __MremoveJResources;
    private boolean __MgetJResource$java_lang_String;
    private boolean __McreateRealm;
    private boolean __MgetConfigFile;
    private boolean __MtoXML;
    private boolean __MencryptPassword$java_lang_String$java_lang_String;
    private boolean __MisValidAlgorithm$java_lang_String;
    private boolean __MaddResources$java_lang_String;
    private boolean __MaddJResourceMemory$java_lang_String;
    private boolean __MaddJResourceDS$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MaddJResourceLDAP$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MbindResource$java_lang_String$org_ow2_jonas_security_realm_factory_JResource;
    private boolean __MsetJmxService$org_ow2_jonas_jmx_JmxService;

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    RegistryService __getregistryService() {
        if (!this.__FregistryService) {
            return this.registryService;
        }
        return (RegistryService)this.__IM.onGet((Object)this, "registryService");
    }

    void __setregistryService(RegistryService registryService) {
        if (!this.__FregistryService) {
            this.registryService = registryService;
            return;
        }
        this.__IM.onSet((Object)this, "registryService", (Object)registryService);
    }

    JResources __getjResources() {
        if (!this.__FjResources) {
            return this.jResources;
        }
        return (JResources)this.__IM.onGet((Object)this, "jResources");
    }

    void __setjResources(JResources jResources) {
        if (!this.__FjResources) {
            this.jResources = jResources;
            return;
        }
        this.__IM.onSet((Object)this, "jResources", (Object)jResources);
    }

    Context __getictx() {
        if (!this.__Fictx) {
            return this.ictx;
        }
        return (Context)this.__IM.onGet((Object)this, "ictx");
    }

    void __setictx(Context context) {
        if (!this.__Fictx) {
            this.ictx = context;
            return;
        }
        this.__IM.onSet((Object)this, "ictx", (Object)context);
    }

    boolean __getbindResourcesIntoJndi() {
        if (!this.__FbindResourcesIntoJndi) {
            return this.bindResourcesIntoJndi;
        }
        Object object = this.__IM.onGet((Object)this, "bindResourcesIntoJndi");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setbindResourcesIntoJndi(boolean bl) {
        if (!this.__FbindResourcesIntoJndi) {
            this.bindResourcesIntoJndi = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "bindResourcesIntoJndi", (Object)bl2);
    }

    List __getjrmpInterceptors() {
        if (!this.__FjrmpInterceptors) {
            return this.jrmpInterceptors;
        }
        return (List)this.__IM.onGet((Object)this, "jrmpInterceptors");
    }

    void __setjrmpInterceptors(List list) {
        if (!this.__FjrmpInterceptors) {
            this.jrmpInterceptors = list;
            return;
        }
        this.__IM.onSet((Object)this, "jrmpInterceptors", (Object)list);
    }

    public JonasSecurityServiceImpl() {
        this(null);
    }

    private JonasSecurityServiceImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setjmxService(null);
        this.__setictx(null);
        this.__setbindResourcesIntoJndi(false);
        this.__setjrmpInterceptors(null);
    }

    public void setRealmJndiRegistration(boolean bl) {
        if (!this.__MsetRealmJndiRegistration$boolean) {
            this.__setRealmJndiRegistration(bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRealmJndiRegistration$boolean", new Object[]{new Boolean(bl)});
            this.__setRealmJndiRegistration(bl);
            this.__IM.onExit((Object)this, "setRealmJndiRegistration$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRealmJndiRegistration$boolean", throwable);
            throw throwable;
        }
    }

    private void __setRealmJndiRegistration(boolean register) {
        this.__setbindResourcesIntoJndi(register);
    }

    public void removeJResource(String string) throws Exception {
        if (!this.__MremoveJResource$java_lang_String) {
            this.__removeJResource(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeJResource$java_lang_String", new Object[]{string});
            this.__removeJResource(string);
            this.__IM.onExit((Object)this, "removeJResource$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeJResource$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeJResource(String resourceName) throws Exception {
        JResource jResource = this.__getjResources().remove(resourceName);
        if (this.__getbindResourcesIntoJndi()) {
            try {
                this.__getictx().unbind(resourceName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("jResource " + resourceName + " remove from the registry."));
                }
            }
            catch (NamingException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot unbind the resource '" + resourceName + "' into JNDI"), (Throwable)e);
            }
        }
        try {
            jResource.removeMBeans();
            if (jResource instanceof JResourceMemory) {
                this.__getjmxService().unregisterModelMBean(JonasObjectName.securityMemoryFactory((String)this.getDomainName(), (String)resourceName));
            } else if (jResource instanceof JResourceDS) {
                this.__getjmxService().unregisterModelMBean(JonasObjectName.securityDatasourceFactory((String)this.getDomainName(), (String)resourceName));
            } else if (jResource instanceof JResourceLDAP) {
                this.__getjmxService().unregisterModelMBean(JonasObjectName.securityLdapFactory((String)this.getDomainName(), (String)resourceName));
            }
        }
        catch (ServiceException se) {
            logger.log(BasicLevel.ERROR, (Object)"JMX service not available", (Throwable)se);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Can not unregister the MBean for the resource " + resourceName + " : " + e.getMessage()));
            throw new ServiceException("Can not unregister the MBean for the resource " + resourceName + " : " + e.getMessage());
        }
    }

    public void setRegistryService(RegistryService registryService) {
        if (!this.__MsetRegistryService$org_ow2_jonas_registry_RegistryService) {
            this.__setRegistryService(registryService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", new Object[]{registryService});
            this.__setRegistryService(registryService);
            this.__IM.onExit((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", throwable);
            throw throwable;
        }
    }

    private void __setRegistryService(RegistryService registry) {
        this.__setregistryService(registry);
    }

    private RegistryService getRegistryService() {
        RegistryService registryService;
        if (!this.__MgetRegistryService) {
            return this.__getRegistryService();
        }
        try {
            this.__IM.onEntry((Object)this, "getRegistryService", new Object[0]);
            registryService = this.__getRegistryService();
            this.__IM.onExit((Object)this, "getRegistryService", (Object)registryService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRegistryService", throwable);
            throw throwable;
        }
        return registryService;
    }

    private RegistryService __getRegistryService() {
        return this.__getregistryService();
    }

    private void initJACCPolicyContextHandlers() throws PolicyContextException {
        if (!this.__MinitJACCPolicyContextHandlers) {
            this.__initJACCPolicyContextHandlers();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initJACCPolicyContextHandlers", new Object[0]);
            this.__initJACCPolicyContextHandlers();
            this.__IM.onExit((Object)this, "initJACCPolicyContextHandlers", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initJACCPolicyContextHandlers", throwable);
            throw throwable;
        }
    }

    private void __initJACCPolicyContextHandlers() throws PolicyContextException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        JPolicyContextHandler policyContextHandler = new JPolicyContextHandler();
        String[] keys = policyContextHandler.getKeys();
        for (int k = 0; k < keys.length; ++k) {
            logger.log(BasicLevel.DEBUG, (Object)("key " + keys[k]));
            PolicyContext.registerHandler((String)keys[k], (PolicyContextHandler)policyContextHandler, (boolean)true);
        }
    }

    public void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __doStart() throws ServiceException {
        this.__setjrmpInterceptors(new ArrayList());
        try {
            boolean security = Boolean.parseBoolean(this.getServerProperties().getValue(SECURITY_PROPAGATION));
            boolean securityCheck = Boolean.parseBoolean(this.getServerProperties().getValue(SEC_CHECK));
            if (security) {
                this.__getjrmpInterceptors().add(SecurityInitializer.class);
                if (securityCheck) {
                    this.__getjrmpInterceptors().add(Initializer.class);
                }
            }
            for (Class interceptor : this.__getjrmpInterceptors()) {
                ConfigurationRepository.addInterceptors((String)"jrmp", (Class)interceptor);
            }
        }
        catch (ConfigurationException e) {
            throw new ServiceException("Cannot init security interceptors for Carol", (Throwable)e);
        }
        PolicyProvider.init();
        try {
            this.initJACCPolicyContextHandlers();
        }
        catch (PolicyContextException e1) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot init JACCPolicyContextHandlers");
            throw new ServiceException("Cannot init JACCPolicyContextHandlers :" + (Object)((Object)e1));
        }
        try {
            JonasSecurityServiceImpl ss = this;
            this.__setjResources(new JResources());
            this.__getjResources().setSecurityService(ss);
            try {
                JResourceRemoteImpl jrri = new JResourceRemoteImpl(ss);
                this.__setictx(this.getRegistryService().getRegistryContext());
                this.__getictx().rebind(this.getJonasServerName() + REMOTE_RESOUCE, (Object)jrri);
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)"Cannot create initial context when Security service initializing");
                throw new ServiceException("Cannot create initial context when Security service initializing", (Throwable)e);
            }
            this.__getjmxService().registerMBean((Object)this, JonasObjectName.securityService((String)this.getDomainName()));
        }
        catch (ServiceException se) {
            logger.log(BasicLevel.ERROR, (Object)"JMX service not available", (Throwable)se);
        }
        catch (Throwable e) {
            logger.log(BasicLevel.ERROR, (Object)("SecurityService: Cannot start the Security service:\n" + e));
            e.printStackTrace();
            throw new ServiceException("SecurityService: Cannot start the Security service", e);
        }
        this.createRealm();
        try {
            this.registerResourcesMBeans();
        }
        catch (MalformedObjectNameException e) {
            throw new ServiceException("SecurityService: Cannot register mbeans", (Throwable)e);
        }
        logger.log(BasicLevel.INFO, (Object)"Security Service started");
    }

    private void registerResourcesMBeans() throws MalformedObjectNameException {
        if (!this.__MregisterResourcesMBeans) {
            this.__registerResourcesMBeans();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "registerResourcesMBeans", new Object[0]);
            this.__registerResourcesMBeans();
            this.__IM.onExit((Object)this, "registerResourcesMBeans", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerResourcesMBeans", throwable);
            throw throwable;
        }
    }

    private void __registerResourcesMBeans() throws MalformedObjectNameException {
        Enumeration<JResource> resourcesEnum = this.__getjResources().getResources();
        String domainName = this.getDomainName();
        while (resourcesEnum.hasMoreElements()) {
            JResource aResource = resourcesEnum.nextElement();
            if (!(aResource instanceof JResourceMemory)) continue;
            String resourceName = aResource.getName();
            JResourceMemory aResourceMemory = (JResourceMemory)aResource;
            aResourceMemory.setJmxService(this.__getjmxService());
            aResourceMemory.setDomainName(domainName);
            aResourceMemory.setSecurityService(this);
            Hashtable<String, JUser> usersTable = aResourceMemory.getUsers();
            Enumeration<String> userNames = usersTable.keys();
            while (userNames.hasMoreElements()) {
                String userName = userNames.nextElement();
                JUser user = usersTable.get(userName);
                this.__getjmxService().registerMBean((Object)user, JonasObjectName.user((String)domainName, (String)resourceName, (String)userName));
            }
            Hashtable<String, Group> groupsTable = aResourceMemory.getGroups();
            Enumeration<String> groupNames = groupsTable.keys();
            while (groupNames.hasMoreElements()) {
                String groupName = groupNames.nextElement();
                Group group = groupsTable.get(groupName);
                this.__getjmxService().registerMBean((Object)group, JonasObjectName.group((String)domainName, (String)resourceName, (String)groupName));
            }
            Hashtable<String, Role> rolesTable = aResourceMemory.getRoles();
            Enumeration<String> roleNames = rolesTable.keys();
            while (roleNames.hasMoreElements()) {
                String roleName = roleNames.nextElement();
                Role role = rolesTable.get(roleName);
                this.__getjmxService().registerMBean((Object)role, JonasObjectName.role((String)domainName, (String)resourceName, (String)roleName));
            }
        }
    }

    public void doStop() {
        if (!this.__MdoStop) {
            this.__doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __doStop() {
        if (this.__getjmxService() != null) {
            try {
                this.removeJResources();
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)"Cannot remove JResources", (Throwable)e);
            }
            this.__getjmxService().unregisterMBean(JonasObjectName.securityService((String)this.getDomainName()));
        }
        try {
            this.__getictx().unbind(this.getJonasServerName() + REMOTE_RESOUCE);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot unbind remote resource for security access", (Throwable)e);
            throw new ServiceException("Cannot unbind remote resource for security access", (Throwable)e);
        }
        try {
            for (Class interceptor : this.__getjrmpInterceptors()) {
                ConfigurationRepository.removeInterceptors((String)"jrmp", (Class)interceptor);
            }
            this.__getjrmpInterceptors().clear();
        }
        catch (ConfigurationException e) {
            throw new ServiceException("Cannot remove security interceptors for Carol", (Throwable)e);
        }
        logger.log(BasicLevel.INFO, (Object)"Security Service stopped");
    }

    private void removeJResources() throws Exception {
        if (!this.__MremoveJResources) {
            this.__removeJResources();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeJResources", new Object[0]);
            this.__removeJResources();
            this.__IM.onExit((Object)this, "removeJResources", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeJResources", throwable);
            throw throwable;
        }
    }

    private void __removeJResources() throws Exception {
        Enumeration<JResource> resourcesEnum = this.__getjResources().getResources();
        while (resourcesEnum.hasMoreElements()) {
            JResource aResource = resourcesEnum.nextElement();
            this.removeJResource(aResource.getName());
        }
    }

    public JResource getJResource(String string) {
        JResource jResource;
        if (!this.__MgetJResource$java_lang_String) {
            return this.__getJResource(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getJResource$java_lang_String", new Object[]{string});
            jResource = this.__getJResource(string);
            this.__IM.onExit((Object)this, "getJResource$java_lang_String", (Object)jResource);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJResource$java_lang_String", throwable);
            throw throwable;
        }
        return jResource;
    }

    private JResource __getJResource(String name) {
        return this.__getjResources().getJResource(name);
    }

    private void createRealm() throws ServiceException {
        if (!this.__McreateRealm) {
            this.__createRealm();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createRealm", new Object[0]);
            this.__createRealm();
            this.__IM.onExit((Object)this, "createRealm", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createRealm", throwable);
            throw throwable;
        }
    }

    private void __createRealm() throws ServiceException {
        File configFile = null;
        FileReader reader = null;
        try {
            configFile = this.getConfigFile();
            reader = new FileReader(configFile);
        }
        catch (FileNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot find config file " + configFile));
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
        try {
            JResourceManager resourceManager = JResourceManager.getInstance();
            resourceManager.addResources(this.__getjResources(), reader, configFile.getPath());
        }
        catch (Throwable e) {
            String err = "Cannot add security resource from '" + configFile + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new ServiceException(err, e);
        }
    }

    protected File getConfigFile() throws FileNotFoundException {
        File file;
        if (!this.__MgetConfigFile) {
            return this.__getConfigFile();
        }
        try {
            this.__IM.onEntry((Object)this, "getConfigFile", new Object[0]);
            file = this.__getConfigFile();
            this.__IM.onExit((Object)this, "getConfigFile", (Object)file);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getConfigFile", throwable);
            throw throwable;
        }
        return file;
    }

    private File __getConfigFile() throws FileNotFoundException {
        String fileName = System.getProperty("jonas.base");
        File file = new File(fileName = fileName + File.separator + CONFIG_FILE);
        if (!file.exists()) {
            String err = "Can't find configuration file : " + fileName;
            throw new FileNotFoundException(err);
        }
        return file;
    }

    public String toXML() {
        String string;
        if (!this.__MtoXML) {
            return this.__toXML();
        }
        try {
            this.__IM.onEntry((Object)this, "toXML", new Object[0]);
            string = this.__toXML();
            this.__IM.onExit((Object)this, "toXML", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "toXML", throwable);
            throw throwable;
        }
        return string;
    }

    private String __toXML() {
        return this.__getjResources().toXML();
    }

    public String encryptPassword(String string, String string2) throws NoSuchAlgorithmException {
        String string3;
        if (!this.__MencryptPassword$java_lang_String$java_lang_String) {
            return this.__encryptPassword(string, string2);
        }
        try {
            this.__IM.onEntry((Object)this, "encryptPassword$java_lang_String$java_lang_String", new Object[]{string, string2});
            string3 = this.__encryptPassword(string, string2);
            this.__IM.onExit((Object)this, "encryptPassword$java_lang_String$java_lang_String", (Object)string3);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "encryptPassword$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string3;
    }

    private String __encryptPassword(String string, String algo) throws NoSuchAlgorithmException {
        String encrypt = HashHelper.hashPassword(string, algo);
        return "{" + algo.toUpperCase() + "}" + encrypt;
    }

    public boolean isValidAlgorithm(String string) {
        boolean bl;
        if (!this.__MisValidAlgorithm$java_lang_String) {
            return this.__isValidAlgorithm(string);
        }
        try {
            this.__IM.onEntry((Object)this, "isValidAlgorithm$java_lang_String", new Object[]{string});
            bl = this.__isValidAlgorithm(string);
            this.__IM.onExit((Object)this, "isValidAlgorithm$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isValidAlgorithm$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isValidAlgorithm(String algo) {
        boolean b = true;
        try {
            this.encryptPassword("test", algo);
        }
        catch (NoSuchAlgorithmException nsae) {
            b = false;
        }
        return b;
    }

    public void addResources(String string) throws Exception {
        if (!this.__MaddResources$java_lang_String) {
            this.__addResources(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addResources$java_lang_String", new Object[]{string});
            this.__addResources(string);
            this.__IM.onExit((Object)this, "addResources$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addResources$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addResources(String xml) throws Exception {
        try {
            JResourceManager resourceManager = JResourceManager.getInstance();
            if (!resourceManager.hasJmxService()) {
                resourceManager.setJmxService(this.__getjmxService());
                resourceManager.setDomainName(this.getDomainName());
            }
            resourceManager.addResources(this.__getjResources(), new StringReader(xml), "");
        }
        catch (Exception e1) {
            String err = "Cannot add security resource from xml '" + xml + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new ServiceException(err, (Throwable)e1);
        }
    }

    public void addJResourceMemory(String string) throws Exception {
        if (!this.__MaddJResourceMemory$java_lang_String) {
            this.__addJResourceMemory(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addJResourceMemory$java_lang_String", new Object[]{string});
            this.__addJResourceMemory(string);
            this.__IM.onExit((Object)this, "addJResourceMemory$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addJResourceMemory$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addJResourceMemory(String name) throws Exception {
        JResourceMemory jResourceMemory = new JResourceMemory();
        jResourceMemory.setSecurityService(this);
        jResourceMemory.setJmxService(this.__getjmxService());
        jResourceMemory.setDomainName(this.getDomainName());
        jResourceMemory.setName(name);
        StringBuffer xml = new StringBuffer("<?xml version='1.0' encoding='utf-8'?>\n<!DOCTYPE jonas-realm PUBLIC\n          \"-//ObjectWeb//DTD JOnAS realm 1.0//EN\"\n          \"http://www.objectweb.org/jonas/dtds/jonas-realm_1_0.dtd\">\n");
        xml.append("<jonas-realm>");
        xml.append("<jonas-memoryrealm>");
        xml.append(jResourceMemory.toXML());
        xml.append("</jonas-memoryrealm>");
        xml.append("</jonas-realm>");
        this.addResources(xml.toString());
    }

    public void addJResourceDS(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws Exception {
        if (!this.__MaddJResourceDS$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__addJResourceDS(string, string2, string3, string4, string5, string6, string7, string8, string9);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addJResourceDS$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4, string5, string6, string7, string8, string9});
            this.__addJResourceDS(string, string2, string3, string4, string5, string6, string7, string8, string9);
            this.__IM.onExit((Object)this, "addJResourceDS$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addJResourceDS$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addJResourceDS(String name, String dsName, String userTable, String userTableUsernameCol, String userTablePasswordCol, String roleTable, String roleTableUsernameCol, String roleTableRolenameCol, String algorithm) throws Exception {
        JResourceDS jResourceDS = new JResourceDS();
        jResourceDS.setSecurityService(this);
        jResourceDS.setJmxService(this.__getjmxService());
        jResourceDS.setDomainName(this.getDomainName());
        jResourceDS.setName(name);
        jResourceDS.setDsName(dsName);
        jResourceDS.setUserTable(userTable);
        jResourceDS.setUserTableUsernameCol(userTableUsernameCol);
        jResourceDS.setUserTablePasswordCol(userTablePasswordCol);
        jResourceDS.setRoleTable(roleTable);
        jResourceDS.setRoleTableUsernameCol(roleTableUsernameCol);
        jResourceDS.setRoleTableRolenameCol(roleTableRolenameCol);
        jResourceDS.setAlgorithm(algorithm);
        StringBuffer xml = new StringBuffer("<?xml version='1.0' encoding='utf-8'?>\n<!DOCTYPE jonas-realm PUBLIC\n          \"-//ObjectWeb//DTD JOnAS realm 1.0//EN\"\n          \"http://www.objectweb.org/jonas/dtds/jonas-realm_1_0.dtd\">\n");
        xml.append("<jonas-realm>");
        xml.append("<jonas-dsrealm>");
        xml.append(jResourceDS.toXML());
        xml.append("</jonas-dsrealm>");
        xml.append("</jonas-realm>");
        this.addResources(xml.toString());
    }

    public void addJResourceLDAP(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20) throws Exception {
        if (!this.__MaddJResourceLDAP$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            this.__addJResourceLDAP(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addJResourceLDAP$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20});
            this.__addJResourceLDAP(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20);
            this.__IM.onExit((Object)this, "addJResourceLDAP$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addJResourceLDAP$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addJResourceLDAP(String name, String initialContextFactory, String providerUrl, String securityAuthentication, String securityPrincipal, String securityCredentials, String securityProtocol, String language, String referral, String stateFactories, String authenticationMode, String userPasswordAttribute, String userRolesAttribute, String roleNameAttribute, String baseDN, String userDN, String userSearchFilter, String roleDN, String roleSearchFilter, String algorithm) throws Exception {
        JResourceLDAP jResourceLDAP = new JResourceLDAP();
        jResourceLDAP.setSecurityService(this);
        jResourceLDAP.setJmxService(this.__getjmxService());
        jResourceLDAP.setDomainName(this.getDomainName());
        jResourceLDAP.setName(name);
        jResourceLDAP.setInitialContextFactory(initialContextFactory);
        jResourceLDAP.setProviderUrl(providerUrl);
        jResourceLDAP.setSecurityAuthentication(securityAuthentication);
        jResourceLDAP.setSecurityPrincipal(securityPrincipal);
        jResourceLDAP.setSecurityCredentials(securityCredentials);
        jResourceLDAP.setSecurityProtocol(securityProtocol);
        jResourceLDAP.setLanguage(language);
        jResourceLDAP.setReferral(referral);
        jResourceLDAP.setStateFactories(stateFactories);
        jResourceLDAP.setAuthenticationMode(authenticationMode);
        jResourceLDAP.setUserPasswordAttribute(userPasswordAttribute);
        jResourceLDAP.setUserRolesAttribute(userRolesAttribute);
        jResourceLDAP.setRoleNameAttribute(roleNameAttribute);
        jResourceLDAP.setBaseDN(baseDN);
        jResourceLDAP.setUserDN(userDN);
        jResourceLDAP.setUserSearchFilter(userSearchFilter);
        jResourceLDAP.setRoleDN(roleDN);
        jResourceLDAP.setRoleSearchFilter(roleSearchFilter);
        jResourceLDAP.setAlgorithm(algorithm);
        StringBuffer xml = new StringBuffer("<?xml version='1.0' encoding='utf-8'?>\n<!DOCTYPE jonas-realm PUBLIC\n          \"-//ObjectWeb//DTD JOnAS realm 1.0//EN\"\n          \"http://www.objectweb.org/jonas/dtds/jonas-realm_1_0.dtd\">\n");
        xml.append("<jonas-realm>");
        xml.append("<jonas-ldaprealm>");
        xml.append(jResourceLDAP.toXML());
        xml.append("</jonas-ldaprealm>");
        xml.append("</jonas-realm>");
        this.addResources(xml.toString());
    }

    public void bindResource(String string, JResource jResource) {
        if (!this.__MbindResource$java_lang_String$org_ow2_jonas_security_realm_factory_JResource) {
            this.__bindResource(string, jResource);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindResource$java_lang_String$org_ow2_jonas_security_realm_factory_JResource", new Object[]{string, jResource});
            this.__bindResource(string, jResource);
            this.__IM.onExit((Object)this, "bindResource$java_lang_String$org_ow2_jonas_security_realm_factory_JResource", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindResource$java_lang_String$org_ow2_jonas_security_realm_factory_JResource", throwable);
            throw throwable;
        }
    }

    private void __bindResource(String name, JResource jResource) {
        if (this.__getbindResourcesIntoJndi()) {
            try {
                this.__getictx().rebind(jResource.getName(), (Object)jResource);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("jResource " + jResource.getName() + " bound into the registry."));
                }
            }
            catch (NamingException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot bind the resource '" + jResource.getName() + "' into JNDI"), (Throwable)e);
            }
        }
        try {
            if (jResource instanceof JResourceMemory) {
                this.__getjmxService().registerModelMBean((Object)jResource, JonasObjectName.securityMemoryFactory((String)this.getDomainName(), (String)jResource.getName()));
            } else if (jResource instanceof JResourceDS) {
                this.__getjmxService().registerModelMBean((Object)jResource, JonasObjectName.securityDatasourceFactory((String)this.getDomainName(), (String)jResource.getName()));
            } else if (jResource instanceof JResourceLDAP) {
                this.__getjmxService().registerModelMBean((Object)jResource, JonasObjectName.securityLdapFactory((String)this.getDomainName(), (String)jResource.getName()));
            }
        }
        catch (ServiceException se) {
            logger.log(BasicLevel.ERROR, (Object)"JMX service not available", (Throwable)se);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Can not register the MBean for the resource " + jResource.getName() + " : " + e.getMessage()));
            throw new ServiceException("Can not register the MBean for the resource " + jResource.getName() + " : " + e.getMessage());
        }
    }

    public void setJmxService(JmxService jmxService) {
        if (!this.__MsetJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__setJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__setJmxService(jmxService);
            this.__IM.onExit((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __setJmxService(JmxService jmxService) {
        this.__setjmxService(jmxService);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("ictx")) {
                this.__Fictx = true;
            }
            if (set.contains("jResources")) {
                this.__FjResources = true;
            }
            if (set.contains("jrmpInterceptors")) {
                this.__FjrmpInterceptors = true;
            }
            if (set.contains("bindResourcesIntoJndi")) {
                this.__FbindResourcesIntoJndi = true;
            }
            if (set.contains("registryService")) {
                this.__FregistryService = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setRealmJndiRegistration$boolean")) {
                this.__MsetRealmJndiRegistration$boolean = true;
            }
            if (set.contains("removeJResource$java_lang_String")) {
                this.__MremoveJResource$java_lang_String = true;
            }
            if (set.contains("setRegistryService$org_ow2_jonas_registry_RegistryService")) {
                this.__MsetRegistryService$org_ow2_jonas_registry_RegistryService = true;
            }
            if (set.contains("getRegistryService")) {
                this.__MgetRegistryService = true;
            }
            if (set.contains("initJACCPolicyContextHandlers")) {
                this.__MinitJACCPolicyContextHandlers = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("registerResourcesMBeans")) {
                this.__MregisterResourcesMBeans = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("removeJResources")) {
                this.__MremoveJResources = true;
            }
            if (set.contains("getJResource$java_lang_String")) {
                this.__MgetJResource$java_lang_String = true;
            }
            if (set.contains("createRealm")) {
                this.__McreateRealm = true;
            }
            if (set.contains("getConfigFile")) {
                this.__MgetConfigFile = true;
            }
            if (set.contains("toXML")) {
                this.__MtoXML = true;
            }
            if (set.contains("encryptPassword$java_lang_String$java_lang_String")) {
                this.__MencryptPassword$java_lang_String$java_lang_String = true;
            }
            if (set.contains("isValidAlgorithm$java_lang_String")) {
                this.__MisValidAlgorithm$java_lang_String = true;
            }
            if (set.contains("addResources$java_lang_String")) {
                this.__MaddResources$java_lang_String = true;
            }
            if (set.contains("addJResourceMemory$java_lang_String")) {
                this.__MaddJResourceMemory$java_lang_String = true;
            }
            if (set.contains("addJResourceDS$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddJResourceDS$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("addJResourceLDAP$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MaddJResourceLDAP$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("bindResource$java_lang_String$org_ow2_jonas_security_realm_factory_JResource")) {
                this.__MbindResource$java_lang_String$org_ow2_jonas_security_realm_factory_JResource = true;
            }
            if (set.contains("setJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MsetJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

