/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced;

import java.util.concurrent.Executor;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.impl.enhanced.PoolConfiguration;
import org.ow2.util.pool.impl.enhanced.ResizerType;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.NotABusyPoolItemException;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.TimeoutPoolException;
import org.ow2.util.pool.impl.enhanced.api.basic.PoolFactoryBroken;
import org.ow2.util.pool.impl.enhanced.api.basic.clue.IBasicCluePool;
import org.ow2.util.pool.impl.enhanced.api.clue.ICluePool;
import org.ow2.util.pool.impl.enhanced.api.keepbusy.ShareMethod;
import org.ow2.util.pool.impl.enhanced.callback.CreateCB;
import org.ow2.util.pool.impl.enhanced.callback.RemoveCB;
import org.ow2.util.pool.impl.enhanced.impl.basic.accessmanager.clue.LastUsedClueAccessManager;
import org.ow2.util.pool.impl.enhanced.impl.basic.clue.BasicCluePool;
import org.ow2.util.pool.impl.enhanced.impl.keepbusy.clue.KeepBusyCluePool;
import org.ow2.util.pool.impl.enhanced.impl.limited.TooManyWaiterException;
import org.ow2.util.pool.impl.enhanced.impl.limited.clue.LimitedWaiterCluePool;
import org.ow2.util.pool.impl.enhanced.impl.listener.resizer.clue.StatsResizerCluePool;
import org.ow2.util.pool.impl.enhanced.impl.listener.statistics.BasicPoolStats;
import org.ow2.util.pool.impl.enhanced.impl.listener.statistics.clue.BasicCluePoolStatsFillerPoolListener;
import org.ow2.util.pool.impl.enhanced.impl.util.ExecutorProvider;
import org.ow2.util.pool.impl.enhanced.impl.validator.clue.ValidatorCluePool;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.ExpireWaitControl;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.InfiniteWaitControl;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.WaitAuthorization;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizer;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.shared.ISharedManager;
import org.ow2.util.pool.impl.enhanced.internal.resizer.impl.AsynchronousResizer;
import org.ow2.util.pool.impl.enhanced.internal.resizer.impl.shared.SharedResizer;
import org.ow2.util.pool.impl.enhanced.internal.resizer.impl.stocker.MinMaxExpectedSpareStockerResizer;
import org.ow2.util.pool.impl.enhanced.manager.clue.ICluePoolManager;
import org.ow2.util.pool.impl.enhanced.manager.clue.optional.IPoolItemRemoveClueManager;
import org.ow2.util.pool.impl.enhanced.manager.clue.optional.IValidatorCluePoolManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedCluePool<E, C>
implements Pool<E, C> {
    private static final int DEFAULT_SPARE_POOL = 150;
    private static final Log LOG = LogFactory.getLog(EnhancedCluePool.class);
    private IBasicCluePool<E, C> basicCluePool;
    private ICluePool<E, C> lastCluePool;
    private LimitedWaiterCluePool<E, C> limitedWaiterCluePool;
    private StatsResizerCluePool<E, C, BasicPoolStats> statsResizerCluePool;
    private KeepBusyCluePool<E, C> keepBusyCluePool;
    private MinMaxExpectedSpareStockerResizer<BasicPoolStats> minMaxExpectedSparePoolResizer;
    private long timeout;
    private int maxWaiter = -1;
    private boolean started = true;
    private Object mutex = new Object();
    private RemoveCB<E> removeCB;
    private CreateCB<E> createCB;
    private volatile WaitAuthorization waitAuthorization = new WaitAuthorization();
    private Object sleepMutex = new Object();

    public EnhancedCluePool(ICluePoolManager<E, C> cluePoolManager) {
        this(cluePoolManager, ResizerType.SIMPLE, null, ExecutorProvider.NEW_THREAD_EXECUTOR);
    }

    public EnhancedCluePool(ICluePoolManager<E, C> cluePoolManager, ResizerType resizerType, ISharedManager sharedManager, Executor createAndRemoveItemExecutor) {
        this.createCB = new CreateCB(cluePoolManager);
        if (IPoolItemRemoveClueManager.class.isInstance(cluePoolManager)) {
            this.removeCB = new RemoveCB((IPoolItemRemoveClueManager)cluePoolManager);
        }
        IBasicCluePool<E, C> cluePool = this.basicCluePool = new BasicCluePool<E, C>(this.createCB, 0, new LastUsedClueAccessManager<E, C>(cluePoolManager), createAndRemoveItemExecutor, this.removeCB, createAndRemoveItemExecutor);
        IResizer<BasicPoolStats> resizer = this.minMaxExpectedSparePoolResizer = new MinMaxExpectedSpareStockerResizer(0, 0, 150, true);
        switch (resizerType) {
            case ASYNCHRONOUS: {
                resizer = new AsynchronousResizer<BasicPoolStats>(this.minMaxExpectedSparePoolResizer);
                break;
            }
            default: {
                resizer = new SharedResizer<BasicPoolStats>(sharedManager, this.minMaxExpectedSparePoolResizer);
            }
            case SIMPLE: 
        }
        resizer.setResizable(cluePool);
        ICluePool<E, C> currentCluePool = cluePool;
        if (IValidatorCluePoolManager.class.isInstance(cluePoolManager)) {
            IValidatorCluePoolManager validatorCluePoolManager = (IValidatorCluePoolManager)cluePoolManager;
            ValidatorCluePool<E, C> validatorCluePool = new ValidatorCluePool<E, C>(currentCluePool, validatorCluePoolManager, false);
            currentCluePool = validatorCluePool;
        }
        this.statsResizerCluePool = new StatsResizerCluePool<E, C, BasicPoolStats>(currentCluePool, new BasicCluePoolStatsFillerPoolListener(false), new BasicPoolStats(), resizer);
        currentCluePool = this.statsResizerCluePool;
        KeepBusyCluePool<E, C> keepBusyCluePool = new KeepBusyCluePool<E, C>(currentCluePool, cluePoolManager);
        currentCluePool = keepBusyCluePool;
        LimitedWaiterCluePool<E, C> limitedWaiterCluePool = new LimitedWaiterCluePool<E, C>(currentCluePool);
        currentCluePool = limitedWaiterCluePool;
        this.limitedWaiterCluePool = limitedWaiterCluePool;
        this.keepBusyCluePool = keepBusyCluePool;
        this.lastCluePool = currentCluePool;
        keepBusyCluePool.setShareMethod(ShareMethod.NEVER_SHARE);
        PoolConfiguration poolConfiguration = new PoolConfiguration();
        int maxPool = poolConfiguration.getMax();
        this.timeout = poolConfiguration.getTimeout();
        this.maxWaiter = poolConfiguration.getMaxWaiters();
        this.limitedWaiterCluePool.setMaxWaiter(this.maxWaiter);
        this.minMaxExpectedSparePoolResizer.setMaxPool(maxPool);
        this.statsResizerCluePool.prepareUpdate();
    }

    protected IWaitControl createWaitControl() {
        if (this.timeout < 0L) {
            throw new IllegalStateException();
        }
        if (this.timeout == 0L) {
            return new InfiniteWaitControl();
        }
        return new ExpireWaitControl(System.currentTimeMillis() + this.timeout);
    }

    public E get() throws org.ow2.util.pool.api.PoolException {
        return this.get(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public E get(C clue) throws org.ow2.util.pool.api.PoolException {
        while (true) {
            try {
                LOG.debug((Object)"try to get with clue {0} and timeout {1}", new Object[]{clue, this.timeout});
                return this.lastCluePool.get(clue, this.createWaitControl());
            }
            catch (TimeoutPoolException e) {
                throw new org.ow2.util.pool.api.PoolException("No more instances available", (Throwable)e);
            }
            catch (TooManyWaiterException e) {
                throw new org.ow2.util.pool.api.PoolException("No more instances available", (Throwable)e);
            }
            catch (PoolFactoryBroken e) {
                Long deadLine = e.getExpireBrokenDeadline();
                if (deadLine == null) {
                    throw new org.ow2.util.pool.api.PoolException("Factory broken", (Throwable)e);
                }
                Object object = this.sleepMutex;
                synchronized (object) {
                    long timeToWait = deadLine - System.currentTimeMillis();
                    while (timeToWait > 0L) {
                        try {
                            this.sleepMutex.wait(timeToWait);
                        }
                        catch (InterruptedException e1) {
                            throw new org.ow2.util.pool.api.PoolException("Interrupted exception", (Throwable)e);
                        }
                        timeToWait = deadLine - System.currentTimeMillis();
                    }
                }
                continue;
            }
            catch (PoolException e) {
                throw new org.ow2.util.pool.api.PoolException("Unknow exception", (Throwable)e);
            }
            break;
        }
        catch (InterruptedException e) {
            throw new org.ow2.util.pool.api.PoolException("Interrupted exception", (Throwable)e);
        }
    }

    public void discard(E instance) throws org.ow2.util.pool.api.PoolException {
        LOG.debug((Object)"discard {0} ", new Object[]{instance});
        try {
            this.lastCluePool.remove(instance);
            this.basicCluePool.waitAllRemoveListenerCompleted();
        }
        catch (PoolException e) {
            throw new org.ow2.util.pool.api.PoolException("Unknow exception", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new org.ow2.util.pool.api.PoolException("Interrupted exception", (Throwable)e);
        }
    }

    public void release(E instance) throws org.ow2.util.pool.api.PoolException {
        LOG.debug((Object)"release {0} ", new Object[]{instance});
        try {
            this.lastCluePool.put(instance);
        }
        catch (NotABusyPoolItemException e) {
            LOG.debug((Object)"try to release a removed instance, ignore this request", new Object[0]);
        }
        catch (PoolException e) {
            throw new org.ow2.util.pool.api.PoolException("Unknow exception", (Throwable)e);
        }
    }

    public void updatePoolSize() {
        this.statsResizerCluePool.update();
    }

    public void setPoolConfiguration(IPoolConfiguration poolConfiguration) {
        int maxPool = poolConfiguration.getMax();
        this.timeout = poolConfiguration.getTimeout();
        this.maxWaiter = poolConfiguration.getMaxWaiters();
        this.limitedWaiterCluePool.setMaxWaiter(this.maxWaiter);
        this.minMaxExpectedSparePoolResizer.setMaxPool(maxPool);
        this.statsResizerCluePool.prepareUpdate();
        LOG.debug((Object)"{3} new conf Setted (timeout : {0}, maxwaiter: {1}, max: {2})", new Object[]{this.timeout, this.maxWaiter, maxPool, this});
    }

    public void setAllowSharedInstance(boolean allowSharedInstance) {
        if (allowSharedInstance) {
            this.keepBusyCluePool.setShareMethod(ShareMethod.SHARE_AS_LAST_SOLUTION);
        } else {
            this.keepBusyCluePool.setShareMethod(ShareMethod.NEVER_SHARE);
        }
    }

    public boolean isAllowSharedInstance() {
        return this.keepBusyCluePool.getShareMethod() != ShareMethod.NEVER_SHARE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws org.ow2.util.pool.api.PoolException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.started) {
                throw new org.ow2.util.pool.api.PoolException("Pool already started");
            }
            this.limitedWaiterCluePool.setMaxWaiter(this.maxWaiter);
            this.basicCluePool.unlockSizeToZero();
            this.started = true;
        }
    }

    public void forceStop() throws InterruptedException {
        this.createCB.forceStop(null);
        this.removeCB.forceStop(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws org.ow2.util.pool.api.PoolException {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.started) {
                throw new org.ow2.util.pool.api.PoolException("Pool already stopped");
            }
            this.basicCluePool.lockSizeToZero();
            this.limitedWaiterCluePool.setMaxWaiter(0);
            this.waitAuthorization.forbidWait();
            this.lastCluePool.signalAllWaiters();
            this.waitAuthorization = new WaitAuthorization();
            try {
                this.limitedWaiterCluePool.waitEmptyWaiterInPool();
            }
            catch (InterruptedException e) {
                this.basicCluePool.unlockSizeToZero();
                this.limitedWaiterCluePool.setMaxWaiter(this.maxWaiter);
                throw new org.ow2.util.pool.api.PoolException("Interrupted exception", (Throwable)e);
            }
            this.keepBusyCluePool.removeAll();
            try {
                this.basicCluePool.clearPool();
                this.basicCluePool.waitAllRemoveListenerCompleted();
            }
            catch (InterruptedException e) {
                this.basicCluePool.unlockSizeToZero();
                this.limitedWaiterCluePool.setMaxWaiter(this.maxWaiter);
                throw new org.ow2.util.pool.api.PoolException("Interrupted exception", (Throwable)e);
            }
            this.started = false;
        }
    }
}

