/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.cxfbean;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.cxf.CxfHeaderFilterStrategy;
import org.apache.camel.component.cxf.cxfbean.CxfBeanBinding;
import org.apache.camel.component.cxf.cxfbean.CxfBeanComponent;
import org.apache.camel.component.cxf.cxfbean.CxfBeanTransportFactory;
import org.apache.camel.component.cxf.cxfbean.DefaultCxfBeanBinding;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.util.CamelContextHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfBeanEndpoint
extends ProcessorEndpoint
implements HeaderFilterStrategyAware {
    private static final String URI_PREFIX = "cxfbean";
    private Server server;
    private Bus bus;
    private boolean isSetDefaultBus;
    private CxfBeanBinding cxfBeanBinding = new DefaultCxfBeanBinding();
    private HeaderFilterStrategy headerFilterStrategy = new CxfHeaderFilterStrategy();

    public CxfBeanEndpoint(String remaining, CxfBeanComponent component) {
        super(remaining, (Component)component);
    }

    public void stop() {
        this.server.stop();
    }

    public void start() {
        this.server.start();
    }

    public void init() {
        ArrayList<Object> serviceBeans;
        Object obj = CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.getEndpointUri());
        if (obj instanceof List) {
            serviceBeans = (ArrayList<Object>)obj;
        } else {
            serviceBeans = new ArrayList<Object>();
            serviceBeans.add(obj);
        }
        if (this.bus == null) {
            this.bus = BusFactory.newInstance().createBus();
        }
        if (this.isSetDefaultBus) {
            BusFactory.setDefaultBus((Bus)this.bus);
        }
        this.registerTransportFactory((CxfBeanComponent)this.getComponent());
        this.createServer(serviceBeans);
    }

    protected String createEndpointUri() {
        return "cxfbean:" + this.getEndpointUri();
    }

    private void createServer(List<Object> serviceBeans) {
        WebService obj = serviceBeans.get(0).getClass().getAnnotation(WebService.class);
        if (obj != null) {
            JaxWsServerFactoryBean bean = new JaxWsServerFactoryBean();
            bean.setTransportId("http://cxf.apache.org/transports/camel/cxfbean");
            bean.setServiceClass(serviceBeans.get(0).getClass());
            bean.setBus(this.bus);
            bean.setStart(true);
            bean.setAddress("camel://" + this.createEndpointUri());
            this.server = bean.create();
        } else {
            JAXRSServerFactoryBean answer = new JAXRSServerFactoryBean();
            answer.setServiceBeans(serviceBeans);
            answer.setAddress("camel://" + this.createEndpointUri());
            answer.setStart(true);
            answer.setTransportId("http://cxf.apache.org/transports/camel/cxfbean");
            answer.setBus(this.bus);
            this.server = answer.create();
        }
    }

    private void registerTransportFactory(CxfBeanComponent cxfBeanComponent) {
        CxfBeanTransportFactory transportFactory = new CxfBeanTransportFactory();
        transportFactory.setCxfBeanComponent(cxfBeanComponent);
        transportFactory.setBus(this.bus);
        ConduitInitiatorManager cim = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        cim.registerConduitInitiator("http://cxf.apache.org/transports/camel/cxfbean", (ConduitInitiator)transportFactory);
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/camel/cxfbean", (DestinationFactory)transportFactory);
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public void setSetDefaultBus(boolean isSetDefaultBus) {
        this.isSetDefaultBus = isSetDefaultBus;
    }

    public boolean isSetDefaultBus() {
        return this.isSetDefaultBus;
    }

    public void setCxfBeanBinding(CxfBeanBinding cxfBeanBinding) {
        this.cxfBeanBinding = cxfBeanBinding;
    }

    public CxfBeanBinding getCxfBeanBinding() {
        return this.cxfBeanBinding;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }
}

