/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.io.InputStream;
import javax.xml.transform.Source;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.util.CxfHeaderHelper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.MessageImpl;

public final class CxfSoapBinding {
    private CxfSoapBinding() {
    }

    public static org.apache.cxf.message.Message getCxfInMessage(HeaderFilterStrategy headerFilterStrategy, Exchange exchange, boolean isClient) {
        MessageImpl answer = new MessageImpl();
        org.apache.cxf.message.Exchange cxfExchange = (org.apache.cxf.message.Exchange)exchange.getProperty("org.apache.cxf.message.exchange", org.apache.cxf.message.Exchange.class);
        Message message = isClient ? exchange.getOut() : exchange.getIn();
        assert (message != null);
        if (cxfExchange == null) {
            cxfExchange = new ExchangeImpl();
            exchange.setProperty("org.apache.cxf.message.exchange", (Object)cxfExchange);
        }
        CxfHeaderHelper.propagateCamelToCxf(headerFilterStrategy, message.getHeaders(), (org.apache.cxf.message.Message)answer, exchange);
        InputStream body = (InputStream)message.getBody(InputStream.class);
        if (body != null) {
            answer.setContent(InputStream.class, (Object)body);
        } else if (message.getBody() != null) {
            answer.setContent(Object.class, (Object)body);
        }
        answer.putAll(message.getHeaders());
        answer.setExchange(cxfExchange);
        cxfExchange.setInMessage((org.apache.cxf.message.Message)answer);
        return answer;
    }

    public static org.apache.cxf.message.Message getCxfOutMessage(HeaderFilterStrategy headerFilterStrategy, Exchange exchange, boolean isClient) throws InvalidPayloadException {
        org.apache.cxf.message.Exchange cxfExchange = (org.apache.cxf.message.Exchange)exchange.getProperty("org.apache.cxf.message.exchange", org.apache.cxf.message.Exchange.class);
        assert (cxfExchange != null);
        Endpoint cxfEndpoint = (Endpoint)cxfExchange.get(Endpoint.class);
        org.apache.cxf.message.Message outMessage = cxfEndpoint.getBinding().createMessage();
        outMessage.setExchange(cxfExchange);
        cxfExchange.setOutMessage(outMessage);
        Message message = isClient ? exchange.getIn() : exchange.getOut();
        CxfHeaderHelper.propagateCamelToCxf(headerFilterStrategy, message.getHeaders(), outMessage, exchange);
        Source body = (Source)message.getMandatoryBody(Source.class);
        outMessage.setContent(Source.class, (Object)body);
        outMessage.putAll(message.getHeaders());
        return outMessage;
    }
}

