/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.ant;

import aQute.libg.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTask
extends Task
implements Reporter {
    List<String> errors = new ArrayList<String>();
    List<String> warnings = new ArrayList<String>();
    List<String> progress = new ArrayList<String>();
    boolean pedantic;
    boolean trace;

    @Override
    public void error(String s, Object ... args) {
        this.errors.add(String.format(s, args));
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getProgress() {
        return this.progress;
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public void progress(String s, Object ... args) {
        this.progress.add(String.format(s, args));
    }

    @Override
    public void warning(String s, Object ... args) {
        this.warnings.add(String.format(s, args));
    }

    protected boolean report() {
        return this.report(this);
    }

    protected boolean report(Reporter reporter) {
        Iterator<String> e;
        if (reporter.getWarnings().size() > 0) {
            System.err.println("Warnings");
            e = reporter.getWarnings().iterator();
            while (e.hasNext()) {
                System.err.println(e.next());
            }
        }
        if (reporter.getErrors().size() > 0) {
            System.err.println("Errors");
            e = reporter.getErrors().iterator();
            while (e.hasNext()) {
                System.err.println(e.next());
            }
            return true;
        }
        return false;
    }

    public static File getFile(File base, String file) {
        File f = new File(file);
        if (!f.isAbsolute()) {
            int n;
            f = base.getAbsoluteFile();
            while ((n = file.indexOf(47)) > 0) {
                String first = file.substring(0, n);
                file = file.substring(n + 1);
                f = first.equals("..") ? f.getParentFile() : new File(f, first);
            }
            f = new File(f, file);
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    protected List<String> split(String dependsOn, String string) {
        if (dependsOn == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(string.split("\\s*" + string + "\\s*"));
    }

    protected String join(Collection<?> classpath, String string) {
        StringBuffer sb = new StringBuffer();
        String del = "";
        for (Object name : classpath) {
            sb.append(del);
            sb.append(name);
            del = string;
        }
        return sb.toString();
    }

    @Override
    public boolean isPedantic() {
        return this.pedantic;
    }

    public void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Override
    public void trace(String s, Object ... args) {
        System.out.printf("# " + s + "\n", args);
    }
}

