/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERIA5String
extends ASN1Object
implements DERString {
    String string;

    public static DERIA5String getInstance(Object object) {
        if (object == null || object instanceof DERIA5String) {
            return (DERIA5String)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERIA5String(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERIA5String.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERIA5String getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERIA5String.getInstance(aSN1TaggedObject.getObject());
    }

    public DERIA5String(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.string = new String(cArray);
    }

    public DERIA5String(String string) {
        this(string, false);
    }

    public DERIA5String(String string, boolean bl) {
        if (bl && !DERIA5String.isIA5String(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(22, this.getOctets());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERIA5String)) {
            return false;
        }
        DERIA5String dERIA5String = (DERIA5String)dERObject;
        return this.getString().equals(dERIA5String.getString());
    }

    public static boolean isIA5String(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }
}

