/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.mail.factory;

import java.io.IOException;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.ow2.easybeans.component.mail.factory.SimpleAuthenticator;
import org.ow2.easybeans.util.marshalling.Serialization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsJavaMailFactory
implements ObjectFactory {
    public static final String AUTHENTICATION_USERNAME = "auth.name";
    public static final String AUTHENTICATION_PASSWORD = "auth.pass";
    public static final String MAIL_PROPERTIES = "mail.properties";

    protected Authenticator getAuthenticator(Reference reference) {
        String authName = this.getString(reference, AUTHENTICATION_USERNAME);
        String authPass = this.getString(reference, AUTHENTICATION_PASSWORD);
        SimpleAuthenticator authenticator = null;
        if (authName != null && authPass != null) {
            authenticator = new SimpleAuthenticator(authName, authPass);
        }
        return authenticator;
    }

    public Properties getSessionProperties(Reference reference) throws NamingException {
        return (Properties)this.getObject(reference, MAIL_PROPERTIES);
    }

    public String getString(Reference reference, String propertyName) {
        RefAddr tmpRefAddr = reference.get(propertyName);
        String tmpValue = null;
        if (tmpRefAddr instanceof StringRefAddr) {
            tmpValue = (String)((StringRefAddr)tmpRefAddr).getContent();
        }
        return tmpValue;
    }

    public <T> T getObject(Reference reference, String propertyName) throws NamingException {
        RefAddr refAddr = reference.get(propertyName);
        Object obj = null;
        if (refAddr != null) {
            try {
                obj = Serialization.loadObject((byte[])refAddr.getContent());
            }
            catch (IOException e) {
                NamingException ne = new NamingException("Cannot load mail session properties object");
                ne.initCause(e);
                throw ne;
            }
            catch (ClassNotFoundException e) {
                NamingException ne = new NamingException("Cannot load mail session properties object");
                ne.initCause(e);
                throw ne;
            }
        }
        return (T)obj;
    }
}

