/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.launcher.felix;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.rmi.RMISecurityManager;
import java.util.Map;
import org.apache.felix.main.AutoProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.ow2.jonas.launcher.felix.DefaultConfigurationProvider;
import org.ow2.jonas.launcher.felix.IConfigurationProvider;
import org.ow2.jonas.launcher.felix.util.IOUtils;
import org.ow2.jonas.launcher.felix.util.JOnASUtils;

public class JOnAS {
    private Framework framework;
    private static final String SECURITY_MANAGER = "jonas.security.manager";

    public JOnAS(boolean forceCleanUp) throws Exception {
        System.out.println("\nWelcome to OW2 JOnAS (Running on Felix).");
        System.out.println("-----------------------------------------------\n");
        boolean useSecurityManager = new Boolean(JOnASUtils.getServerProperty(SECURITY_MANAGER, "true").trim());
        if (useSecurityManager && System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        this.initializeSystemProperties();
        IConfigurationProvider provider = this.getConfigurationProvider();
        Map configProps = provider.getConfiguration();
        if (forceCleanUp) {
            IOUtils.deleteDir(new File((String)configProps.get("org.osgi.framework.storage")));
        }
        this.framework = this.getFrameworkFactory().newFramework(configProps);
        this.framework.init();
        AutoProcessor.process(configProps, this.framework.getBundleContext());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    if (JOnAS.this.framework.getState() == 32) {
                        JOnAS.this.framework.stop();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        });
    }

    public void start() throws Exception {
        this.framework.start();
        this.startTransientBundles();
        this.framework.waitForStop(0L);
        System.exit(0);
    }

    public void stop() throws Exception {
        if (this.framework.getState() == 32) {
            this.framework.stop();
        }
    }

    protected IConfigurationProvider getConfigurationProvider() {
        return new DefaultConfigurationProvider();
    }

    public static void main(String[] args) throws Exception {
        JOnAS jonas = new JOnAS(Boolean.getBoolean("jonas.cache.clean"));
        jonas.start();
    }

    protected void initializeSystemProperties() {
        System.setProperty("jonas.start.date", Long.toString(System.currentTimeMillis()));
        System.setProperty("monolog.wrappers", "mx4j.log.CommonsLogger,mx4j.log.Logger,java.util.logging.Logger,org.apache.commons.logging.impl.Jdk14Logger,org.ow2.util.log.JDKLogger,org.apache.juli.logging.DirectJDKLog,org.ow2.carol.util.configuration.TraceCarol,org.slf4j.impl.JCLLoggerAdapter");
        System.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        System.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        System.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.standard_init", "org.jacorb.orb.standardInterceptors.IORInterceptorInitializer");
        System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "org.ow2.carol.rmi.multi.MultiPRODelegate");
        System.setProperty("javax.rmi.CORBA.UtilClass", "org.ow2.carol.util.delegate.UtilDelegateImpl");
        System.setProperty("java.naming.factory.initial", "org.ow2.carol.jndi.intercept.spi.InterceptorInitialContextFactory");
        this.setDefaultPropertyIfNotSet("java.security.policy", IOUtils.getSystemPath(JOnASUtils.getJOnASBase(), "conf/java.policy"));
        this.setDefaultPropertyIfNotSet("java.security.auth.login.config", IOUtils.getSystemPath(JOnASUtils.getJOnASBase(), "conf/jaas.config"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameworkFactory getFrameworkFactory() throws Exception {
        URL url = this.getClass().getClassLoader().getResource("META-INF/services/org.osgi.framework.launch.FrameworkFactory");
        if (url != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String s = br.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0 && s.charAt(0) != '#') {
                        FrameworkFactory frameworkFactory = (FrameworkFactory)Class.forName(s).newInstance();
                        return frameworkFactory;
                    }
                    s = br.readLine();
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
        throw new Exception("Could not find framework factory.");
    }

    protected void setDefaultPropertyIfNotSet(String key, String def) {
        System.setProperty(key, System.getProperty(key, def));
    }

    protected void startTransientBundles() throws BundleException {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.framework.getBundleContext().getBundles()) {
            if (bundle.getSymbolicName().equals("org.apache.felix.shell.tui") && Boolean.getBoolean("jonas.felix.tui.enabled")) {
                this.startTransient(bundle);
            }
            if (!bundle.getSymbolicName().startsWith("org.apache.felix.shell.gui") || !Boolean.getBoolean("jonas.felix.gui.enabled")) continue;
            this.startTransient(bundle);
        }
    }

    protected void startTransient(Bundle bundle) throws BundleException {
        bundle.start(1);
    }

    public Framework getFramework() {
        return this.framework;
    }
}

