/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.easybeans.ext;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import org.ow2.easybeans.api.EZBContainerCallbackInfo;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.bean.info.IWebServiceInfo;
import org.ow2.easybeans.container.EmptyLifeCycleCallBack;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.jonas.ws.axis2.JOnASJaxWsImplementorInfo;
import org.ow2.jonas.ws.axis2.JaxWsImplementorInfo;
import org.ow2.jonas.ws.axis2.easybeans.Axis2EJBWebserviceEndpoint;
import org.ow2.jonas.ws.axis2.jaxws.WebservicesContainer;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.IWebservicesModule;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.jonas.ws.jaxws.base.JAXWSWebservicesModule;
import org.ow2.jonas.ws.jaxws.ejb.IWebDeployer;
import org.ow2.jonas.ws.jaxws.util.JAXWSClassUtils;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifeCycleCallback
extends EmptyLifeCycleCallBack {
    private static Log logger = LogFactory.getLog(LifeCycleCallback.class);
    private List<IWebServiceEndpoint> endpoints = new ArrayList<IWebServiceEndpoint>();
    private Map<String, IWebservicesModule<WebservicesContainer<Axis2EJBWebserviceEndpoint>>> modules = new HashMap<String, IWebservicesModule<WebservicesContainer<Axis2EJBWebserviceEndpoint>>>();
    private IWebDeployer webDeployer;

    public void start(EZBContainerCallbackInfo info) {
        String moduleName = info.getArchive().getName();
        IWebservicesModule<WebservicesContainer<Axis2EJBWebserviceEndpoint>> module = null;
        Map factories = info.getFactories();
        for (Factory f : factories.values()) {
            String wsdlLocation;
            WebservicesContainer<Axis2EJBWebserviceEndpoint> container;
            if (!(f instanceof StatelessSessionFactory)) continue;
            StatelessSessionFactory factory = (StatelessSessionFactory)f;
            Class klass = factory.getBeanClass();
            WebService ws = klass.getAnnotation(WebService.class);
            if (!JAXWSClassUtils.isWebService((Class)klass)) continue;
            IBeanInfo beanInfo = factory.getBeanInfo();
            IWebServiceInfo webServiceInfo = beanInfo.getWebServiceInfo();
            JOnASJaxWsImplementorInfo jaxWsImplementorInfo = webServiceInfo != null ? new JOnASJaxWsImplementorInfo(klass, webServiceInfo) : new JOnASJaxWsImplementorInfo(klass);
            module = this.modules.get(moduleName);
            if (module == null) {
                module = this.createWebservicesModule(moduleName);
                this.modules.put(moduleName, module);
            }
            if ((container = (WebservicesContainer<Axis2EJBWebserviceEndpoint>)module.findContainer(jaxWsImplementorInfo.getWsdlLocation())) == null) {
                container = this.createWebservicesContainer(jaxWsImplementorInfo.getWsdlLocation());
                module.addContainer(container);
            }
            if ((wsdlLocation = jaxWsImplementorInfo.getWsdlLocation()) == null || wsdlLocation.equals("")) {
                logger.warn((Object)"The wsdl location is not specified!", new Object[0]);
            }
            String serviceName = jaxWsImplementorInfo.getServiceName().getLocalPart();
            String pattern = this.getUrlPattern(klass, webServiceInfo, jaxWsImplementorInfo);
            PortMetaData pmd = new PortMetaData();
            String contextRoot = LifeCycleCallback.extractContextRoot(info.getArchive().getName());
            StringBuffer handlerXML = new StringBuffer();
            try {
                HandlerChain hc = klass.getAnnotation(HandlerChain.class);
                if (hc != null) {
                    URL handlerURL = klass.getClassLoader().getResource(hc.file());
                    BufferedReader br = new BufferedReader(new InputStreamReader(handlerURL.openStream()));
                    String temp = null;
                    temp = br.readLine();
                    while (temp != null) {
                        handlerXML.append(temp);
                        temp = br.readLine();
                    }
                    pmd.setHandlerXML(handlerXML.toString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to Get the handler description file for " + serviceName + "!", e);
            }
            finally {
                if (pmd.getHandlerXML() != null) {
                    logger.debug((Object)"Found handlers in this package!", new Object[0]);
                }
            }
            pmd.setContextRoot(contextRoot);
            pmd.setUrlPattern(pattern);
            if (wsdlLocation != null && !wsdlLocation.equals("")) {
                pmd.setWSDLLocation(wsdlLocation);
            }
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(klass.getClassLoader());
            Axis2EJBWebserviceEndpoint endpoint = new Axis2EJBWebserviceEndpoint(klass, pmd, factory, info.getContainer(), beanInfo);
            try {
                endpoint.init();
            }
            catch (Exception e1) {
                throw new RuntimeException("Exception occurs when creating endpoint for" + serviceName + "!", e1);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
            container.addEndpoint(endpoint);
        }
        if (module != null) {
            module.start();
            try {
                this.webDeployer.deploy(module);
                for (WebservicesContainer container : module.getContainers()) {
                    for (Axis2EJBWebserviceEndpoint endpoint : container.getEndpoints()) {
                        endpoint.displayInfos();
                    }
                }
            }
            catch (WSException e) {
                logger.warn((Object)"Webservices endpoints of the EjbJar ''{0}'' cannot be deployed because of some error: {1}", new Object[]{info.getContainer().getName(), e.getMessage(), e});
                this.webDeployer.undeploy(module);
                this.stopWebservicesModule(module);
                this.modules.remove(moduleName);
            }
        }
    }

    private static String extractContextRoot(String filename) {
        String context = filename.substring(filename.lastIndexOf(File.separator) + 1);
        int underscoreIndex = context.indexOf(95);
        context = underscoreIndex == -1 ? context.substring(0, context.lastIndexOf(46)) : context.substring(0, underscoreIndex);
        return context;
    }

    public void stop(EZBContainerCallbackInfo info) {
        this.stop();
        logger.info((Object)("axis2 stopped for " + info.getArchive()), new Object[0]);
    }

    public void stop() {
        logger.debug((Object)"Stop ''{0}''", new Object[]{this});
        for (Map.Entry<String, IWebservicesModule<WebservicesContainer<Axis2EJBWebserviceEndpoint>>> entry : this.modules.entrySet()) {
            IWebservicesModule<WebservicesContainer<Axis2EJBWebserviceEndpoint>> module = entry.getValue();
            this.stopWebservicesModule(module);
        }
        this.modules.clear();
    }

    private void stopWebservicesModule(IWebservicesModule<WebservicesContainer<Axis2EJBWebserviceEndpoint>> module) {
        this.webDeployer.undeploy(module);
        module.stop();
    }

    private String getUrlPattern(Class<?> klass, IWebServiceInfo webServiceInfo, JaxWsImplementorInfo jaxWsImplementorInfo) {
        String pattern;
        if (webServiceInfo != null && webServiceInfo.getEndpointAddress() != null) {
            pattern = webServiceInfo.getEndpointAddress();
            if (!pattern.startsWith("/")) {
                pattern = "/" + pattern;
            }
        } else {
            String serviceName = jaxWsImplementorInfo.getServiceName().getLocalPart();
            pattern = !"".equals(serviceName) ? "/" + serviceName : "/" + klass.getSimpleName() + "Service";
        }
        return pattern;
    }

    public void setWebDeployer(IWebDeployer webDeployer) {
        this.webDeployer = webDeployer;
    }

    protected JAXWSWebservicesModule<WebservicesContainer<Axis2EJBWebserviceEndpoint>> createWebservicesModule(String name) {
        return new JAXWSWebservicesModule(name);
    }

    protected WebservicesContainer<Axis2EJBWebserviceEndpoint> createWebservicesContainer(String name) {
        return new WebservicesContainer<Axis2EJBWebserviceEndpoint>(name);
    }
}

