/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.index.TermVectorEntry;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;

public class FieldSortedTermVectorMapper
extends TermVectorMapper {
    private Map fieldToTerms = new HashMap();
    private SortedSet currentSet;
    private String currentField;
    private Comparator comparator;

    public FieldSortedTermVectorMapper(Comparator comparator) {
        this(false, false, comparator);
    }

    public FieldSortedTermVectorMapper(boolean ignoringPositions, boolean ignoringOffsets, Comparator comparator) {
        super(ignoringPositions, ignoringOffsets);
        this.comparator = comparator;
    }

    public void map(String term, int frequency, TermVectorOffsetInfo[] offsets, int[] positions) {
        TermVectorEntry entry = new TermVectorEntry(this.currentField, term, frequency, offsets, positions);
        this.currentSet.add(entry);
    }

    public void setExpectations(String field, int numTerms, boolean storeOffsets, boolean storePositions) {
        this.currentSet = new TreeSet(this.comparator);
        this.currentField = field;
        this.fieldToTerms.put(field, this.currentSet);
    }

    public Map getFieldToTerms() {
        return this.fieldToTerms;
    }

    public Comparator getComparator() {
        return this.comparator;
    }
}

