/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.prefetch.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.eval.prefetch.api.PrefetchBuffer;
import org.objectweb.medor.eval.prefetch.api.PrefetchBufferFactory;
import org.objectweb.medor.eval.prefetch.api.PrefetchCache;
import org.objectweb.medor.eval.prefetch.lib.PrefetchBufferImpl;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class PrefetchCacheImpl
implements PrefetchCache {
    private HashMap txContexts = new HashMap();
    Logger logger;

    public PrefetchCacheImpl() {
    }

    public PrefetchCacheImpl(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Tuple getPrefetchTuple(Object index, Object cat, Object ctxt) throws MedorException {
        if (ctxt == null) {
            throw new MedorException("Cannot search a prefetch tuple without a transaction context!");
        }
        if (cat == null) {
            throw new MedorException("Cannot search a prefetch tuple without an object category!");
        }
        HashMap catmap = (HashMap)this.txContexts.get(ctxt);
        if (catmap == null) {
            return null;
        }
        ArrayList pblist = (ArrayList)catmap.get(cat);
        if (pblist == null) {
            return null;
        }
        Tuple res = null;
        for (int i = 0; i < pblist.size(); ++i) {
            PrefetchBuffer pb = (PrefetchBuffer)pblist.get(i);
            Tuple tmp = pb.getTuple(index);
            if (res != null || tmp == null) continue;
            res = tmp;
        }
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("getPrefetchTupleCollection: \n\tcategory=" + cat + "\n\tcontext=" + ctxt + "\n\tindex=" + index + "\n\t==>" + PrefetchCacheImpl.printTuple(res)));
        }
        return res;
    }

    public TupleCollection getPrefetchTupleCollection(Object index, Object cat, Object ctxt) throws MedorException {
        if (ctxt == null) {
            throw new MedorException("Cannot search a prefetch tuple without a transaction context!");
        }
        if (cat == null) {
            throw new MedorException("Cannot search a prefetch tuple without an object category!");
        }
        HashMap catmap = (HashMap)this.txContexts.get(ctxt);
        if (catmap == null) {
            return null;
        }
        ArrayList pblist = (ArrayList)catmap.get(cat);
        if (pblist == null) {
            return null;
        }
        TupleCollection res = null;
        for (int i = 0; i < pblist.size(); ++i) {
            PrefetchBuffer pb = (PrefetchBuffer)pblist.get(i);
            TupleCollection tmp = pb.getTupleCollection(index);
            if (res != null || tmp == null) continue;
            res = tmp;
        }
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("getPrefetchTupleCollection: \n\tcategory=" + cat + "\n\tcontext=" + ctxt + "\n\tindex=" + index + "\n\t==>" + PrefetchCacheImpl.printTuple(res.getTuple())));
        }
        return res;
    }

    public void invalidatePrefetchBuffer(Object ctxt) {
        HashMap catmap = (HashMap)this.txContexts.get(ctxt);
        if (catmap == null) {
            if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Invalidation of an unregistered context: " + ctxt));
            }
            return;
        }
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Invalidation of the context: " + ctxt));
        }
        this.txContexts.remove(ctxt);
        Iterator it = catmap.values().iterator();
        while (it.hasNext()) {
            ArrayList pblist = (ArrayList)it.next();
            Iterator it2 = pblist.iterator();
            while (it2.hasNext()) {
                try {
                    ((PrefetchBuffer)it2.next()).close();
                }
                catch (MedorException e) {}
            }
        }
    }

    public PrefetchBuffer createPrefetchBuffer(PrefetchBufferFactory pbf, Object cat, Object ctxt, int indexpos, boolean register) throws MedorException {
        return this.createPrefetchBuffer(null, cat, ctxt, indexpos, false, register);
    }

    public PrefetchBuffer createPrefetchBuffer(PrefetchBufferFactory pbf, Object cat, Object ctxt, int indexpos, boolean multithread, boolean register) throws MedorException {
        PrefetchBufferImpl res = new PrefetchBufferImpl(indexpos, multithread, this.logger);
        if (register) {
            this.registerPrefetchBuffer(res, cat, ctxt);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerPrefetchBuffer(PrefetchBuffer pb, Object cat, Object ctxt) throws MedorException {
        ArrayList<PrefetchBuffer> pblist;
        if (ctxt == null) {
            return false;
        }
        if (cat == null) {
            throw new MedorException("Cannot register a prefetch buffer without an object category!");
        }
        HashMap<Object, ArrayList<PrefetchBuffer>> catmap = (HashMap<Object, ArrayList<PrefetchBuffer>>)this.txContexts.get(ctxt);
        if (catmap == null) {
            HashMap hashMap = this.txContexts;
            synchronized (hashMap) {
                catmap = (HashMap)this.txContexts.get(ctxt);
                if (catmap == null) {
                    catmap = new HashMap<Object, ArrayList<PrefetchBuffer>>();
                    this.txContexts.put(ctxt, catmap);
                    if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)"create a map for the context");
                    }
                }
            }
        }
        if ((pblist = (ArrayList<PrefetchBuffer>)catmap.get(cat)) == null) {
            HashMap<Object, ArrayList<PrefetchBuffer>> hashMap = catmap;
            synchronized (hashMap) {
                pblist = (ArrayList)catmap.get(cat);
                if (pblist == null) {
                    pblist = new ArrayList<PrefetchBuffer>();
                    catmap.put(cat, pblist);
                    if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)"create a list of PrefetchBuffer");
                    }
                }
            }
        }
        pblist.add(pb);
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("PrefetchBuffer created and added: " + pb));
        }
        return true;
    }

    public static String printTuple(Tuple t) {
        if (t == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String sep = "(";
        int size = t.getSize();
        for (int i = 1; i <= size; ++i) {
            sb.append(sep);
            sep = ", ";
            sb.append(i);
            sb.append(": ");
            try {
                sb.append(t.getObject(i));
                continue;
            }
            catch (MedorException e) {
                sb.append("not printable");
            }
        }
        return sb.toString();
    }

    public void clean() {
        this.txContexts.clear();
    }
}

