/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import java.util.Collection;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.Exp;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Val;

abstract class CompareExpression
extends Exp {
    private final Val _val1;
    private final Val _val2;

    public CompareExpression(Val val1, Val val2) {
        this._val1 = val1;
        this._val2 = val2;
    }

    protected boolean eval(Object candidate, Object orig, StoreContext ctx, Object[] params) {
        Object o1 = this._val1.eval(candidate, orig, ctx, params);
        Object o2 = this._val2.eval(candidate, orig, ctx, params);
        if (o1 != null && o2 != null) {
            Class c = Filters.promote(o1.getClass(), o2.getClass());
            o1 = Filters.convert(o1, c);
            o2 = Filters.convert(o2, c);
        }
        return this.compare(o1, o2);
    }

    protected boolean eval(Collection candidates, StoreContext ctx, Object[] params) {
        Object o2;
        Collection c1 = this._val1.eval(candidates, null, ctx, params);
        Collection c2 = this._val2.eval(candidates, null, ctx, params);
        Object o1 = c1 == null || c1.isEmpty() ? null : (Object)c1.iterator().next();
        Object object = o2 = c2 == null || c2.isEmpty() ? null : (Object)c2.iterator().next();
        if (o1 != null && o2 != null) {
            Class c = Filters.promote(o1.getClass(), o2.getClass());
            o1 = Filters.convert(o1, c);
            o2 = Filters.convert(o2, c);
        }
        return this.compare(o1, o2);
    }

    protected abstract boolean compare(Object var1, Object var2);

    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        this._val1.acceptVisit(visitor);
        this._val2.acceptVisit(visitor);
        visitor.exit(this);
    }
}

