/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.haclient;

import fr.dyade.aaa.jndi2.client.NamingConnection;
import fr.dyade.aaa.jndi2.client.NamingContextImpl;
import fr.dyade.aaa.jndi2.client.Trace;
import fr.dyade.aaa.jndi2.haclient.HANamingConnection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.objectweb.util.monolog.api.BasicLevel;

public class HANamingContextFactory
implements InitialContextFactory {
    public Context getInitialContext(Hashtable env) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("HANamingContextFactory.getInitialContext(" + env + ')'));
        }
        return new NamingContextImpl(HANamingContextFactory.getNamingConnection(env), new CompositeName());
    }

    private static String getEnvProperty(Hashtable env, String propName) {
        String value = null;
        if (env != null) {
            value = (String)env.get(propName);
        }
        if (value == null) {
            value = System.getProperty(propName, null);
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NamingConnection getNamingConnection(Hashtable env) throws NamingException {
        try {
            String url = HANamingContextFactory.getEnvProperty(env, "hascn.naming.provider.url");
            if (url == null) {
                url = HANamingContextFactory.getEnvProperty(env, "java.naming.provider.url");
            }
            if (url == null) throw new NamingException("URL java.naming.provider.url not defined");
            StringTokenizer tokenizer = new StringTokenizer(url, "/:,");
            if (!tokenizer.hasMoreElements()) {
                throw new NamingException("URL not valid:" + url);
            }
            String protocol = tokenizer.nextToken();
            if (!protocol.equals("hascn")) throw new NamingException("Unknown protocol:" + protocol);
            HANamingConnection haNamingConnection = new HANamingConnection();
            while (tokenizer.hasMoreElements()) {
                haNamingConnection.addServerAddress(tokenizer.nextToken(), Integer.parseInt(tokenizer.nextToken()));
            }
            return haNamingConnection;
        }
        catch (Exception e) {
            NamingException nx = new NamingException("exception creating NamingContext: " + e.toString());
            nx.setRootCause(e);
            throw nx;
        }
    }
}

