/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.ha.tcp;

import java.util.StringTokenizer;
import java.util.Timer;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.client.jms.tcp.ReliableTcpClient;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.security.Identity;

public class HATcpRequestChannel
implements RequestChannel {
    private ReliableTcpClient tcpClient;

    public HATcpRequestChannel(String url, FactoryParameters params, Identity identity) throws JMSException {
        this(url, params, identity, "org.objectweb.joram.client.jms.tcp.ReliableTcpClient");
    }

    public HATcpRequestChannel() {
    }

    public HATcpRequestChannel(String url, FactoryParameters params, Identity identity, String reliableClass) throws JMSException {
        try {
            this.tcpClient = (ReliableTcpClient)Class.forName(reliableClass).newInstance();
        }
        catch (ClassNotFoundException exc) {
            JMSException jmsExc = new JMSException("HATcpConnection: ClassNotFoundException : " + reliableClass);
            jmsExc.setLinkedException((Exception)exc);
            throw jmsExc;
        }
        catch (InstantiationException exc) {
            JMSException jmsExc = new JMSException("HATcpConnection: InstantiationException : " + reliableClass);
            jmsExc.setLinkedException((Exception)exc);
            throw jmsExc;
        }
        catch (IllegalAccessException exc) {
            JMSException jmsExc = new JMSException("HATcpConnection: IllegalAccessException : " + reliableClass);
            jmsExc.setLinkedException((Exception)exc);
            throw jmsExc;
        }
        this.tcpClient.init(params, identity, true);
        StringTokenizer tokenizer = new StringTokenizer(url, "/:,");
        if (!tokenizer.hasMoreElements()) {
            throw new JMSException("URL not valid:" + url);
        }
        String protocol = tokenizer.nextToken();
        if (protocol.equals("hajoram")) {
            while (tokenizer.hasMoreElements()) {
                this.tcpClient.addServerAddress(tokenizer.nextToken(), Integer.parseInt(tokenizer.nextToken()));
            }
        } else {
            throw new JMSException("Unknown protocol:" + protocol);
        }
    }

    public void setTimer(Timer timer) {
        this.tcpClient.setTimer(timer);
    }

    public void connect() throws Exception {
        this.tcpClient.connect();
    }

    public void send(AbstractJmsRequest request) throws Exception {
        this.tcpClient.send(request);
    }

    public AbstractJmsReply receive() throws Exception {
        return (AbstractJmsReply)this.tcpClient.receive();
    }

    public void close() {
        this.tcpClient.close();
    }

    public void closing() {
        this.tcpClient.stopReconnections();
    }
}

