/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.versioning;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.tomcat.util.buf.MessageBytes;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.web.base.BaseWebContainerService;
import org.ow2.jonas.web.tomcat6.versioning.VersionedPathBean;
import org.ow2.jonas.web.tomcat6.versioning.VirtualContext;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextFinder {
    private static Log logger = LogFactory.getLog(ContextFinder.class);
    private static List<String> nonVersionedContexts = new ArrayList<String>();
    private static Map<String, VirtualContext> contextURIMapping = new HashMap<String, VirtualContext>();
    private static JmxService jmxService = null;
    private static BaseWebContainerService webContainer = null;

    public static void setJmxService(JmxService jmxService) {
        ContextFinder.jmxService = jmxService;
    }

    private ContextFinder() {
    }

    public static void setParent(BaseWebContainerService webContainer) {
        ContextFinder.webContainer = webContainer;
    }

    public static BaseWebContainerService getParent() {
        return webContainer;
    }

    public static MessageBytes getContextURI(MessageBytes decodedURI, Request req, VersionedPathBean vpb) throws IOException {
        String decodedURIString = decodedURI.toString();
        logger.debug((Object)"Starting getContextURI with decodedURI {0} and request {1}", new Object[]{decodedURIString, req});
        if (webContainer.isVersioningEnabled()) {
            VirtualContext vctx = null;
            for (Map.Entry<String, VirtualContext> entry : contextURIMapping.entrySet()) {
                String key = entry.getKey();
                String keyWithEndingSlash = key.length() > 1 ? key + '/' : key;
                if (decodedURIString.equals(keyWithEndingSlash)) {
                    vctx = entry.getValue();
                    break;
                }
                if (!decodedURIString.startsWith(key)) continue;
                if (vctx == null) {
                    vctx = entry.getValue();
                    continue;
                }
                if (entry.getValue().userURI.length() <= vctx.userURI.length()) continue;
                vctx = entry.getValue();
            }
            if (vctx != null) {
                String userURIWithEndingSlash = vctx.userURI.length() > 1 ? vctx.userURI + '/' : vctx.userURI;
                if (!decodedURIString.startsWith(userURIWithEndingSlash)) {
                    logger.debug((Object)"Final slash missing for decodedURI {0} and request {1}", new Object[]{decodedURIString, req});
                    return decodedURI;
                }
                for (String context : nonVersionedContexts) {
                    if (!decodedURIString.startsWith(context) || context.length() <= userURIWithEndingSlash.length()) continue;
                    logger.debug((Object)"Found non-versioned context {0} for decodedURI {1} and request {2}", new Object[]{context, decodedURIString, req});
                    return decodedURI;
                }
                String versionedPath = vctx.findContext(req);
                StringBuffer versionedURI = new StringBuffer();
                if (versionedPath == null) {
                    logger.debug((Object)"No version found on virtual context {0} for request {1}", new Object[]{vctx.userURI, req});
                    versionedURI.append(vctx.userURI);
                    versionedURI.append("-invalid-version/");
                } else {
                    logger.debug((Object)"Found versioned context {0} on virtual context {1} for request {2}", new Object[]{versionedPath, vctx.userURI, req});
                    vpb.setUserPath(vctx.userURI);
                    vpb.setVersionedPath(versionedPath);
                    versionedURI.append(versionedPath);
                    versionedURI.append('/');
                    if (decodedURIString.length() > userURIWithEndingSlash.length()) {
                        versionedURI.append(decodedURIString.substring(userURIWithEndingSlash.length()));
                    }
                }
                logger.debug((Object)"Setting versionedURI to {0} for decodedURI {1} and request {2}", new Object[]{versionedURI, decodedURIString, req});
                MessageBytes contextURI = MessageBytes.newInstance();
                contextURI.setChars(versionedURI.toString().toCharArray(), 0, versionedURI.length());
                return contextURI;
            }
        }
        logger.debug((Object)"No virtual context for decodedURI {0} and request {1}", new Object[]{decodedURIString, req});
        return decodedURI;
    }

    public static void addNonVersionedContext(String context) {
        if (!context.startsWith("/")) {
            context = context + "/" + context;
        }
        nonVersionedContexts.add(context);
    }

    public static boolean bindContextRoot(String appName, String userURI, Context contextRoot, String policy) {
        if (webContainer.isVersioningEnabled()) {
            if (!contextURIMapping.containsKey(userURI)) {
                VirtualContext newContext = new VirtualContext(jmxService, userURI, contextRoot);
                contextURIMapping.put(userURI, newContext);
            } else {
                contextURIMapping.get(userURI).addContext(contextRoot, policy);
            }
            return true;
        }
        return false;
    }

    public static Map<String, String> readContextRoot(String userContextRoot) {
        if (webContainer.isVersioningEnabled()) {
            VirtualContext context = contextURIMapping.get(userContextRoot);
            if (context == null) {
                return null;
            }
            return context.getContexts();
        }
        return null;
    }

    public static void removeNonVersionedContext(String context) {
        if (!context.startsWith("/")) {
            context = context + "/" + context;
        }
        nonVersionedContexts.remove(context);
    }

    public static boolean unbindContextRoot(String userURI, Context contextRoot) {
        return ContextFinder.unbindContextRoot(userURI, contextRoot.getPath());
    }

    public static boolean unbindContextRoot(String userURI, String versionedPath) {
        if (webContainer.isVersioningEnabled()) {
            VirtualContext context = contextURIMapping.get(userURI);
            if (context == null) {
                return false;
            }
            return context.removeContext(versionedPath);
        }
        return false;
    }

    public static boolean unbindContextRoot(Context contextRoot) {
        return ContextFinder.unbindContextRoot(contextRoot.getPath());
    }

    public static boolean unbindContextRoot(String contextRoot) {
        if (webContainer.isVersioningEnabled()) {
            for (Map.Entry<String, VirtualContext> entry : contextURIMapping.entrySet()) {
                if (!entry.getValue().hasContext(contextRoot)) continue;
                return ContextFinder.unbindContextRoot(entry.getKey(), contextRoot);
            }
        }
        return false;
    }

    public static boolean unbindVirtualContext(String userURI) {
        if (webContainer.isVersioningEnabled()) {
            VirtualContext context = contextURIMapping.get(userURI);
            if (context == null) {
                return false;
            }
            contextURIMapping.remove(userURI);
            return context.removeVirtualContext();
        }
        return false;
    }
}

