/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.wrapper;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.ref.RefComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.osgi.CamelContextFactory;
import org.apache.camel.spi.Registry;
import org.ow2.jonas.camel.registry.osgi.OSGiRegistry;
import org.ow2.jonas.camel.registry.xml.RegistryWrapper;
import org.ow2.jonas.camel.wrapper.ICamelWrapper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelWrapper
implements ICamelWrapper {
    private final Log logger = LogFactory.getLog(this.getClass());
    private CamelContext camel = null;
    private String name;
    private RegistryWrapper registryWrapper;

    public CamelWrapper(CamelContextFactory factory) {
        DefaultCamelContext ctx = factory.createContext();
        OSGiRegistry osgiR = new OSGiRegistry(factory.getBundleContext());
        ctx.setRegistry((Registry)osgiR);
        ctx.addComponent("registry", (Component)new RefComponent());
        this.registryWrapper = new RegistryWrapper();
        this.registryWrapper.createRegistryAssign2Context(ctx);
        this.camel = ctx;
    }

    public String getCamelContextName() {
        return this.camel.getName();
    }

    public void run() throws Exception {
        while (true) {
            MBeanServer mBeanServer = null;
            ObjectName j2eeServer = null;
            for (MBeanServer o : MBeanServerFactory.findMBeanServer(null)) {
                MBeanServer currentServer = o;
                Set<ObjectName> j2eeServerNames = currentServer.queryNames(new ObjectName("*:j2eeType=J2EEServer,*"), null);
                if (j2eeServerNames.size() <= 0) continue;
                j2eeServer = j2eeServerNames.iterator().next();
                mBeanServer = currentServer;
                break;
            }
            if (mBeanServer == null) {
                this.logger.info((Object)"CamelWrapper is running outside a J2EEServer", new Object[0]);
                break;
            }
            String state = mBeanServer.getAttribute(j2eeServer, "state").toString();
            if (state.contains("running")) break;
            if (!state.contains("starting")) {
                throw new Exception("Server state is " + state + ", canceling context creation");
            }
            this.logger.debug((Object)"The J2EEServer hosting CamelWrapper is still starting, waiting...", new Object[0]);
            Thread.sleep(100L);
        }
        this.camel.start();
    }

    @Override
    public void stopContext() throws Exception {
        this.camel.stop();
    }

    @Override
    public void addRoutes(RouteBuilder builder) throws Exception {
        this.logger.debug((Object)"Adding a route to the context", new Object[0]);
        this.camel.addRoutes((RoutesBuilder)builder);
    }

    @Override
    public List<RouteDefinition> getRouteDefinitions() {
        return this.camel.getRouteDefinitions();
    }

    @Override
    public ProducerTemplate getProducerTemplate() {
        return this.camel.createProducerTemplate();
    }

    @Override
    public void addComponent(String componentName, Component component) {
        component.setCamelContext(this.camel);
        this.camel.addComponent(componentName, component);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camel;
    }

    @Override
    public void addToTheRegistry(InputStream inputStream) throws Exception {
        this.registryWrapper.addToTheRegistry(inputStream);
    }

    @Override
    public void removeFromTheRegistry(InputStream inputStream) {
        this.registryWrapper.removeFromTheRegistry(inputStream);
    }
}

