/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.reader.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import org.ow2.util.plan.bindings.repository.ObjectFactory;
import org.ow2.util.plan.bindings.repository.Repositories;
import org.ow2.util.plan.reader.AbsReader;
import org.ow2.util.plan.reader.ReaderException;
import org.ow2.util.plan.reader.repository.IRepositoryDataReader;
import org.xml.sax.InputSource;

public class RepositoryDataReaderImpl
extends AbsReader
implements IRepositoryDataReader {
    private static final Class[] REPOSITORIES_CLASSES = new Class[]{ObjectFactory.class};
    private static final String REPOSITORY_XSD = "repositories-1.0.xsd";

    protected void initUnmarshallClasses() {
        this.unmarshallClasses = REPOSITORIES_CLASSES;
    }

    public Repositories readRepositories(File file) throws IOException, ReaderException {
        JAXBElement<?> jaxbElement = null;
        try {
            jaxbElement = this.getRootElement(file);
        }
        catch (JAXBException e) {
            throw new ReaderException(e);
        }
        Object elementValue = jaxbElement.getValue();
        if (elementValue instanceof Repositories) {
            return (Repositories)elementValue;
        }
        throw new ReaderException("Bad root element for repository file.");
    }

    protected void buildUnmarshallerSchema() throws Exception {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream is = this.schemaStreamFactory.getSchemaStream(REPOSITORY_XSD);
        if (is == null) {
            throw new Exception("Cannot read Repository XSD resource");
        }
        SAXSource ss = new SAXSource(new InputSource(is));
        this.unmarshallerSchema = sf.newSchema(ss);
    }
}

