/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.impl.ExpressionAdapter;
import org.apache.camel.spi.Language;
import org.apache.camel.util.FileUtil;

@Deprecated
public final class FileExpressionBuilder {
    private FileExpressionBuilder() {
    }

    public static Expression fileNameExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileName", String.class);
            }

            public String toString() {
                return "file:name";
            }
        };
    }

    public static Expression fileOnlyNameExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String answer = exchange.getIn().getHeader("CamelFileNameOnly", String.class);
                if (answer == null) {
                    answer = exchange.getIn().getHeader("CamelFileName", String.class);
                    answer = FileUtil.stripPath(answer);
                }
                return answer;
            }

            public String toString() {
                return "file:onlyname";
            }
        };
    }

    public static Expression fileNameNoExtensionExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.stripExt(name);
            }

            public String toString() {
                return "file:name.noext";
            }
        };
    }

    public static Expression fileOnlyNameNoExtensionExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String name = FileExpressionBuilder.fileOnlyNameExpression().evaluate(exchange, String.class);
                return FileUtil.stripExt(name);
            }

            public String toString() {
                return "file:onlyname.noext";
            }
        };
    }

    public static Expression fileExtensionExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                if (name != null) {
                    return name.substring(name.lastIndexOf(46) + 1);
                }
                return null;
            }

            public String toString() {
                return "file:ext";
            }
        };
    }

    public static Expression fileParentExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileParent", String.class);
            }

            public String toString() {
                return "file:parent";
            }
        };
    }

    public static Expression filePathExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFilePath", String.class);
            }

            public String toString() {
                return "file:path";
            }
        };
    }

    public static Expression fileAbsolutePathExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileAbsolutePath", String.class);
            }

            public String toString() {
                return "file:absolute.path";
            }
        };
    }

    public static Expression fileAbsoluteExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileAbsolute", Boolean.class);
            }

            public String toString() {
                return "file:absolute";
            }
        };
    }

    public static Expression fileSizeExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileLength", Long.class);
            }

            public String toString() {
                return "file:length";
            }
        };
    }

    public static Expression fileLastModifiedExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileLastModified", Date.class);
            }

            public String toString() {
                return "file:modified";
            }
        };
    }

    public static Expression dateExpression(final String command, final String pattern) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                if ("file".equals(command)) {
                    Date date = exchange.getIn().getHeader("CamelFileLastModified", Date.class);
                    if (date != null) {
                        SimpleDateFormat df = new SimpleDateFormat(pattern);
                        return df.format(date);
                    }
                    return null;
                }
                return ExpressionBuilder.dateExpression(command, pattern).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "date(" + command + ":" + pattern + ")";
            }
        };
    }

    public static Expression simpleExpression(final String expression) {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Language simple = exchange.getContext().resolveLanguage("simple");
                return simple.createExpression(expression).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "simple(" + expression + ")";
            }
        };
    }
}

