/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.util.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericFileProcessStrategySupport<T>
implements GenericFileProcessStrategy<T> {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected GenericFileExclusiveReadLockStrategy<T> exclusiveReadLockStrategy;

    @Override
    public void prepareOnStartup(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint) throws Exception {
        if (this.exclusiveReadLockStrategy != null) {
            this.exclusiveReadLockStrategy.prepareOnStartup(operations, endpoint);
        }
    }

    @Override
    public boolean begin(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        boolean lock;
        return this.exclusiveReadLockStrategy == null || (lock = this.exclusiveReadLockStrategy.acquireExclusiveReadLock(operations, file, exchange));
    }

    @Override
    public void commit(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        if (this.exclusiveReadLockStrategy != null) {
            this.exclusiveReadLockStrategy.releaseExclusiveReadLock(operations, file, exchange);
        }
        this.deleteLocalWorkFile(exchange);
    }

    @Override
    public void rollback(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        if (this.exclusiveReadLockStrategy != null) {
            this.exclusiveReadLockStrategy.releaseExclusiveReadLock(operations, file, exchange);
        }
        this.deleteLocalWorkFile(exchange);
    }

    public GenericFileExclusiveReadLockStrategy<T> getExclusiveReadLockStrategy() {
        return this.exclusiveReadLockStrategy;
    }

    public void setExclusiveReadLockStrategy(GenericFileExclusiveReadLockStrategy<T> exclusiveReadLockStrategy) {
        this.exclusiveReadLockStrategy = exclusiveReadLockStrategy;
    }

    private void deleteLocalWorkFile(Exchange exchange) {
        File local = exchange.getIn().getHeader("CamelFileLocalWorkPath", File.class);
        if (local != null && local.exists()) {
            boolean deleted = FileUtil.deleteFile(local);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Local work file: " + local + " was deleted: " + deleted));
            }
        }
    }
}

