/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.ExpressionClauseSupport;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.PredicateAssertHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AssertionClause
extends ExpressionClauseSupport<ValueBuilder>
implements Runnable {
    private List<Predicate> predicates = new ArrayList<Predicate>();

    public AssertionClause() {
        super(null);
    }

    @Override
    public ValueBuilder expression(Expression expression) {
        super.expression(expression);
        return new PredicateValueBuilder(this.getExpressionValue());
    }

    public AssertionClause predicate(Predicate predicate) {
        this.addPredicate(predicate);
        return this;
    }

    public ExpressionClause<AssertionClause> predicate() {
        ExpressionClause<AssertionClause> clause = new ExpressionClause<AssertionClause>(this);
        this.addPredicate(clause);
        return clause;
    }

    protected void applyAssertionOn(MockEndpoint endpoint, int index, Exchange exchange) {
        for (Predicate predicate : this.predicates) {
            PredicateAssertHelper.assertMatches(predicate, endpoint.getEndpointUri() + " ", exchange);
        }
    }

    protected void addPredicate(Predicate predicate) {
        this.predicates.add(predicate);
    }

    public final class PredicateValueBuilder
    extends ValueBuilder {
        public PredicateValueBuilder(Expression expression) {
            super(expression);
        }

        protected Predicate onNewPredicate(Predicate predicate) {
            AssertionClause.this.addPredicate(predicate);
            return predicate;
        }
    }
}

