/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="recipientList")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RecipientListDefinition
extends ExpressionNode {
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute(required=false)
    private String delimiter;
    @XmlAttribute(required=false)
    private Boolean parallelProcessing;
    @XmlAttribute(required=false)
    private String strategyRef;
    @XmlAttribute(required=false)
    private String executorServiceRef;
    @XmlAttribute(required=false)
    private Boolean stopOnException;

    public RecipientListDefinition() {
    }

    public RecipientListDefinition(ExpressionDefinition expression) {
        super(expression);
    }

    public RecipientListDefinition(Expression expression) {
        super(expression);
    }

    public String toString() {
        return "RecipientList[" + this.getExpression() + "]";
    }

    @Override
    public String getShortName() {
        return "recipientList";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Expression expression = this.getExpression().createExpression(routeContext);
        RecipientList answer = this.delimiter != null ? new RecipientList(expression, this.delimiter) : new RecipientList(expression);
        if (this.parallelProcessing != null) {
            answer.setParallelProcessing(this.isParallelProcessing());
        }
        if (this.stopOnException != null) {
            answer.setStopOnException(this.isStopOnException());
        }
        answer.setAggregationStrategy(this.createAggregationStrategy(routeContext));
        answer.setExecutorService(this.createExecutorService(routeContext));
        return answer;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        if (this.aggregationStrategy == null && this.strategyRef != null) {
            this.aggregationStrategy = routeContext.lookup(this.strategyRef, AggregationStrategy.class);
        }
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = new UseLatestAggregationStrategy();
        }
        return this.aggregationStrategy;
    }

    private ExecutorService createExecutorService(RouteContext routeContext) {
        if (this.executorService == null && this.executorServiceRef != null) {
            this.executorService = routeContext.lookup(this.executorServiceRef, ExecutorService.class);
        }
        if (this.executorService == null) {
            this.executorService = ExecutorServiceHelper.newScheduledThreadPool(10, "RecipientList", true);
        }
        return this.executorService;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void addOutput(ProcessorDefinition processorType) {
        this.getParent().addOutput(processorType);
    }

    public RecipientListDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public RecipientListDefinition parallelProcessing() {
        this.setParallelProcessing(true);
        return this;
    }

    public RecipientListDefinition stopOnException() {
        this.setStopOnException(true);
        return this;
    }

    public RecipientListDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(Boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Boolean isStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(Boolean stopOnException) {
        this.stopOnException = stopOnException;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

