/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Enricher
extends ServiceSupport
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(Enricher.class);
    private AggregationStrategy aggregationStrategy;
    private Producer producer;

    public Enricher(Producer producer) {
        this(Enricher.defaultAggregationStrategy(), producer);
    }

    public Enricher(AggregationStrategy aggregationStrategy, Producer producer) {
        this.aggregationStrategy = aggregationStrategy;
        this.producer = producer;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public void setDefaultAggregationStrategy() {
        this.aggregationStrategy = Enricher.defaultAggregationStrategy();
    }

    public void process(Exchange exchange) throws Exception {
        Exchange resourceExchange = this.createResourceExchange(exchange, ExchangePattern.InOut);
        this.producer.process(resourceExchange);
        if (resourceExchange.isFailed()) {
            ExchangeHelper.copyResultsPreservePattern(exchange, resourceExchange);
        } else {
            Enricher.prepareResult(exchange);
            ExchangeHelper.prepareAggregation(exchange, resourceExchange);
            Exchange aggregatedExchange = this.aggregationStrategy.aggregate(exchange, resourceExchange);
            if (aggregatedExchange != null) {
                ExchangeHelper.copyResultsPreservePattern(exchange, aggregatedExchange);
            }
        }
    }

    protected Exchange createResourceExchange(Exchange source, ExchangePattern pattern) {
        Exchange target = source.copy();
        target.setPattern(pattern);
        return target;
    }

    private static void prepareResult(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
        }
    }

    private static AggregationStrategy defaultAggregationStrategy() {
        return new CopyAggregationStrategy();
    }

    public String toString() {
        return "Enrich[" + this.producer.getEndpoint().getEndpointUri() + "]";
    }

    protected void doStart() throws Exception {
        this.producer.start();
    }

    protected void doStop() throws Exception {
        this.producer.stop();
    }

    private static class CopyAggregationStrategy
    implements AggregationStrategy {
        private CopyAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange != null) {
                ExchangeHelper.copyResultsPreservePattern(oldExchange, newExchange);
            }
            return oldExchange;
        }
    }
}

