/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;

public class RecipientList
extends ServiceSupport
implements Processor {
    private ProducerCache producerCache;
    private Expression expression;
    private final String delimiter;
    private boolean parallelProcessing;
    private boolean stopOnException;
    private ExecutorService executorService;
    private AggregationStrategy aggregationStrategy = new UseLatestAggregationStrategy();

    public RecipientList() {
        this.delimiter = ",";
    }

    public RecipientList(String delimiter) {
        this.delimiter = delimiter;
    }

    public RecipientList(Expression expression) {
        this(expression, ",");
    }

    public RecipientList(Expression expression, String delimiter) {
        ObjectHelper.notNull(expression, "expression");
        ObjectHelper.notEmpty(delimiter, "delimiter");
        this.expression = expression;
        this.delimiter = delimiter;
    }

    public String toString() {
        return "RecipientList[" + (this.expression != null ? this.expression : "") + "]";
    }

    public void process(Exchange exchange) throws Exception {
        Object receipientList = this.expression.evaluate(exchange, Object.class);
        this.sendToRecipientList(exchange, receipientList);
    }

    public void sendToRecipientList(Exchange exchange, Object receipientList) throws Exception {
        Iterator<Object> iter = ObjectHelper.createIterator(receipientList, this.delimiter);
        ArrayList<Processor> processors = new ArrayList<Processor>();
        while (iter.hasNext()) {
            Object recipient = iter.next();
            Endpoint endpoint = this.resolveEndpoint(exchange, recipient);
            Producer producer = this.getProducerCache(exchange).getProducer(endpoint);
            processors.add(producer);
        }
        MulticastProcessor mp = new MulticastProcessor(processors, this.getAggregationStrategy(), this.isParallelProcessing(), this.getExecutorService(), false, this.isStopOnException());
        mp.process(exchange);
    }

    protected ProducerCache getProducerCache(Exchange exchange) throws Exception {
        if (this.producerCache == null) {
            this.producerCache = new ProducerCache(exchange.getContext());
            this.producerCache.start();
        }
        return this.producerCache;
    }

    protected Endpoint resolveEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        return ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    protected void doStart() throws Exception {
        if (this.producerCache != null) {
            this.producerCache.start();
        }
    }

    protected void doStop() throws Exception {
        if (this.producerCache != null) {
            this.producerCache.stop();
        }
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public boolean isStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(boolean stopOnException) {
        this.stopOnException = stopOnException;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }
}

