/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.SynchronizationAdapter;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.spi.RoutePolicy;

public class RoutePolicyProcessor
extends DelegateProcessor {
    private final RoutePolicy routePolicy;
    private Route route;

    public RoutePolicyProcessor(Processor processor, RoutePolicy routePolicy) {
        super(processor);
        this.routePolicy = routePolicy;
    }

    public String toString() {
        return "RoutePolicy[" + this.routePolicy + "]";
    }

    protected void processNext(Exchange exchange) throws Exception {
        if (this.isRoutePolicyRunAllowed()) {
            this.routePolicy.onExchangeBegin(this.route, exchange);
            exchange.addOnCompletion(new SynchronizationAdapter(){

                public void onDone(Exchange exchange) {
                    if (RoutePolicyProcessor.isCamelStopping(exchange.getContext())) {
                        return;
                    }
                    RoutePolicyProcessor.this.routePolicy.onExchangeDone(RoutePolicyProcessor.this.route, exchange);
                }
            });
        }
        if (this.processor != null) {
            this.processor.process(exchange);
        }
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    private static boolean isCamelStopping(CamelContext context) {
        if (context instanceof ServiceSupport) {
            ServiceSupport ss = (ServiceSupport)((Object)context);
            return ss.isStopping() || ss.isStopped();
        }
        return false;
    }

    private boolean isRoutePolicyRunAllowed() {
        if (this.routePolicy instanceof ServiceSupport) {
            ServiceSupport ss = (ServiceSupport)((Object)this.routePolicy);
            return ss.isRunAllowed();
        }
        return true;
    }
}

