/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.validator;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.NotABusyPoolItemException;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.TimeoutPoolException;
import org.ow2.util.pool.impl.enhanced.api.validator.IPoolValidator;
import org.ow2.util.pool.impl.enhanced.impl.PoolError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorPool<E>
implements IPool<E> {
    private static final Log LOG = LogFactory.getLog(ValidatorPool.class);
    private IPool<E> pool;
    private IPoolValidator<E> poolValidator;
    private boolean putValidate;

    public ValidatorPool(IPool<E> pool, IPoolValidator<E> poolValidator, boolean putValidate) {
        this.pool = pool;
        this.poolValidator = poolValidator;
        this.putValidate = putValidate;
    }

    protected boolean validateOneItem(E poolItem) {
        try {
            return this.poolValidator.validate(poolItem);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Validation failed", new Object[]{e});
            return false;
        }
    }

    @Override
    public E get(IWaitControl timeout) throws PoolException, InterruptedException {
        E poolItem = this.pool.get(timeout);
        while (!this.validateOneItem(poolItem)) {
            try {
                this.pool.remove(poolItem);
            }
            catch (NotABusyPoolItemException e) {
                throw new PoolError("Delegated pool has a bad behavior");
            }
            if (!timeout.canContinueToWait()) {
                throw new TimeoutPoolException();
            }
            poolItem = this.pool.get(timeout);
        }
        return poolItem;
    }

    @Override
    public void signalAllWaiters() {
        this.pool.signalAllWaiters();
    }

    @Override
    public void put(E poolItem) throws NotABusyPoolItemException {
        if (this.putValidate && !this.validateOneItem(poolItem)) {
            this.pool.remove(poolItem);
        } else {
            this.pool.put(poolItem);
        }
    }

    @Override
    public void remove(E poolItem) throws NotABusyPoolItemException {
        this.pool.remove(poolItem);
    }
}

