/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.ha.interceptor;

import java.util.Stack;
import org.ow2.cmi.ha.RequestId;
import org.ow2.cmi.ha.interceptor.HAContext;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HACurrent {
    private Log logger = LogFactory.getLog(HACurrent.class);
    private static HACurrent singleton = null;
    private static InheritableThreadLocal<HAContext> threadCtx = new InheritableThreadLocal();

    private HACurrent() {
    }

    public static HACurrent getHACurrent() {
        if (singleton == null) {
            singleton = new HACurrent();
        }
        return singleton;
    }

    public void setRequests(Stack<RequestId> requests) {
        HAContext current = this.getCurrentContext();
        current.setRequests(requests);
        threadCtx.set(current);
    }

    public Stack<RequestId> getRequests() {
        return this.getCurrentContext().getRequests();
    }

    public void putNextReq(RequestId nextReq) {
        HAContext current = this.getCurrentContext();
        current.putNextReq(nextReq);
        threadCtx.set(current);
    }

    public void setOnFailover(boolean onFailover) {
        HAContext current = this.getCurrentContext();
        current.setOnFailover(onFailover);
        threadCtx.set(current);
    }

    public boolean isOnFailover() {
        return this.getCurrentContext().isOnFailover();
    }

    private HAContext getCurrentContext() {
        HAContext current = (HAContext)threadCtx.get();
        if (current == null) {
            current = new HAContext();
        }
        return current;
    }
}

