/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.InternalException;

public class UniqueResultObjectProvider
implements ResultObjectProvider {
    private final ResultObjectProvider[] _rops;
    private final StoreQuery _query;
    private final QueryExpressions[] _exps;
    private Object _single;
    private boolean _opened;
    private static final String COUNT = "Count";
    private static final String MAX = "Max";
    private static final String MIN = "Min";
    private static final String SUM = "Sum";
    private static final Localizer _loc = Localizer.forPackage(UniqueResultObjectProvider.class);

    public UniqueResultObjectProvider(ResultObjectProvider[] rops, StoreQuery q, QueryExpressions[] exps) {
        this._rops = rops;
        this._query = q;
        this._exps = exps;
    }

    public boolean absolute(int pos) throws Exception {
        return false;
    }

    public void close() throws Exception {
        this._opened = false;
        for (ResultObjectProvider rop : this._rops) {
            rop.close();
        }
    }

    public Object getResultObject() throws Exception {
        if (!this._opened) {
            throw new InternalException(_loc.get("not-open"));
        }
        return this._single;
    }

    public void handleCheckedException(Exception e) {
        this._rops[0].handleCheckedException(e);
    }

    public boolean next() throws Exception {
        if (!this._opened) {
            this.open();
        }
        if (this._single != null) {
            return false;
        }
        Value[] values = this._exps[0].projections;
        Object[] single = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            Value v = values[i];
            boolean isAggregate = v.isAggregate();
            String op = v.getClass().getSimpleName();
            for (ResultObjectProvider rop : this._rops) {
                rop.next();
                Object[] row = (Object[])rop.getResultObject();
                if (isAggregate) {
                    if (COUNT.equals(op)) {
                        single[i] = this.count(single[i], row[i]);
                        continue;
                    }
                    if (MAX.equals(op)) {
                        single[i] = this.max(single[i], row[i]);
                        continue;
                    }
                    if (MIN.equals(op)) {
                        single[i] = this.min(single[i], row[i]);
                        continue;
                    }
                    if (SUM.equals(op)) {
                        single[i] = this.sum(single[i], row[i]);
                        continue;
                    }
                    throw new UnsupportedOperationException(_loc.get("aggregate-unsupported", op).toString());
                }
                single[i] = row[i];
            }
        }
        this._single = single;
        return true;
    }

    Object count(Object current, Object other) {
        if (current == null) {
            return other;
        }
        return ((Number)current).longValue() + ((Number)other).longValue();
    }

    Object max(Object current, Object other) {
        if (current == null) {
            return other;
        }
        return Math.max(((Number)current).doubleValue(), ((Number)other).doubleValue());
    }

    Object min(Object current, Object other) {
        if (current == null) {
            return other;
        }
        return Math.min(((Number)current).doubleValue(), ((Number)other).doubleValue());
    }

    Object sum(Object current, Object other) {
        if (current == null) {
            return other;
        }
        return ((Number)current).doubleValue() + ((Number)other).doubleValue();
    }

    public void open() throws Exception {
        for (ResultObjectProvider rop : this._rops) {
            rop.open();
        }
        this._opened = true;
    }

    public void reset() throws Exception {
        this._single = null;
        for (ResultObjectProvider rop : this._rops) {
            rop.reset();
        }
    }

    public int size() throws Exception {
        return 1;
    }

    public boolean supportsRandomAccess() {
        return false;
    }
}

