/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.joram;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.ServerConfigHelper;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.NullTransaction;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAException;
import org.objectweb.joram.client.connector.ActivationSpecImpl;
import org.objectweb.joram.client.connector.JoramAdapter;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.tcp.QueueTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.objectweb.joram.mom.proxies.ConnectionManager;
import org.objectweb.joram.mom.proxies.tcp.TcpProxyService;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.EZBWorkManagerComponent;
import org.ow2.easybeans.component.itf.JMSComponent;
import org.ow2.easybeans.component.itf.TMComponent;
import org.ow2.easybeans.component.joram.JoramBootstrapContext;
import org.ow2.easybeans.component.joram.JoramException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoramComponent
implements JMSComponent {
    private static Log logger = LogFactory.getLog(JoramComponent.class);
    private static final String QUEUE_CONN_FACT_NAME = "JQCF";
    private static final String TOPIC_CONN_FACT_NAME = "JTCF";
    private static final String CONN_FACT_NAME = "JCF";
    private static final int DEFAULT_PORT_NUMBER = 16010;
    private int port = 16010;
    private static final String DEFAULT_HOST_NAME = "localhost";
    private String host = "localhost";
    private static final short ID = 0;
    private static final String TRANSACTION_PROPERTY = "Transaction";
    private static final String DEFAULT_PERSISTENCE_DIRECTORY = "joram-persistence-s0";
    private boolean started = false;
    private JoramAdapter joramAdapter = null;
    private List<String> topics = new ArrayList<String>();
    private List<String> queues = new ArrayList<String>();
    private EZBWorkManagerComponent workManager = null;
    private TMComponent transactionComponent = null;
    private InitialContext ictx = null;

    public void init() throws EZBComponentException {
    }

    public void start() throws EZBComponentException {
        Properties properties = new Properties();
        properties.put("monolog.classname", "org.objectweb.util.monolog.wrapper.javaLog.LoggerFactory");
        properties.put("logger.com.scalagent.level", "ERROR");
        properties.put("logger.fr.dyade.aaa.level", "ERROR");
        properties.put("logger.org.objectweb.joram.level", "ERROR");
        properties.put("logger.fr.dyade.aaa.agent.Service.level", "FATAL");
        properties.put("logger.org.objectweb.joram.mom.Destination.level", "FATAL");
        properties.put("logger.org.objectweb.joram.mom.Proxy.level", "FATAL");
        LoggerFactory factory = Monolog.init((Properties)properties);
        try {
            Field field = Debug.class.getDeclaredField("factory");
            field.setAccessible(true);
            field.set(null, factory);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to setup logger of Joram", new Object[]{e});
        }
        try {
            this.ictx = new InitialContext();
        }
        catch (NamingException e) {
            throw new EZBComponentException("Cannot create an initial context.", (Throwable)e);
        }
        if (this.transactionComponent == null) {
            throw new EZBComponentException("Transaction component was not injected. Reason: Missing tm=\"#tm\" in the easybeans.xml configuration file ?");
        }
        if (this.workManager == null) {
            throw new EZBComponentException("Work manager was not injected. Reason: Missing workmanager=\"#workmanager\" in the easybeans.xml configuration file ?");
        }
        XATerminator xaTerminator = null;
        try {
            xaTerminator = this.transactionComponent.getXATerminator();
        }
        catch (XAException e) {
            throw new EZBComponentException("Cannot get the XA terminator", (Throwable)e);
        }
        JoramBootstrapContext bootstrapContext = new JoramBootstrapContext((WorkManager)this.workManager, xaTerminator);
        this.joramAdapter = new JoramAdapter();
        this.joramAdapter.setHostName(this.host);
        this.joramAdapter.setServerPort(Integer.valueOf(this.port));
        this.joramAdapter.setCollocatedServer(Boolean.FALSE);
        System.setProperty(TRANSACTION_PROPERTY, NullTransaction.class.getName());
        try {
            AgentServer.init((short)0, (String)DEFAULT_PERSISTENCE_DIRECTORY, null);
        }
        catch (Exception e) {
            throw new EZBComponentException("Cannot initialize a new collocated Joram server", (Throwable)e);
        }
        try {
            AgentServer.start();
        }
        catch (Exception e) {
            throw new EZBComponentException("Cannot start collocated Joram server", (Throwable)e);
        }
        try {
            new ServerConfigHelper(false).addService(0, ConnectionManager.class.getName(), "root root");
        }
        catch (Exception e) {
            throw new EZBComponentException("Cannot add connection manager service", (Throwable)e);
        }
        try {
            new ServerConfigHelper(false).addService(0, TcpProxyService.class.getName(), String.valueOf(this.port));
        }
        catch (Exception e) {
            throw new EZBComponentException("Cannot add TcpProxy service", (Throwable)e);
        }
        try {
            this.connectToCollocated();
        }
        catch (JoramException e) {
            throw new EZBComponentException("Cannot connect to the collocated server", (Throwable)e);
        }
        try {
            this.joramAdapter.createUser("anonymous", "anonymous");
        }
        catch (AdminException e) {
            throw new EZBComponentException("Cannot create anonymous user", (Throwable)e);
        }
        catch (ConnectException e) {
            throw new EZBComponentException("Cannot create anonymous user", (Throwable)e);
        }
        try {
            this.joramAdapter.start((BootstrapContext)bootstrapContext);
        }
        catch (ResourceAdapterInternalException e) {
            throw new EZBComponentException("Cannot start the resource adapter of JORAM", (Throwable)e);
        }
        try {
            this.createConnectionFactories();
        }
        catch (JoramException e) {
            throw new EZBComponentException("Cannot create connection factories", (Throwable)e);
        }
        try {
            this.createInitialTopics();
        }
        catch (JoramException e) {
            throw new EZBComponentException("Cannot create initial topics", (Throwable)e);
        }
        try {
            this.createInitialQueues();
        }
        catch (JoramException e) {
            throw new EZBComponentException("Cannot create initial queues", (Throwable)e);
        }
        ActivationSpecImpl activationSpec = new ActivationSpecImpl();
        try {
            activationSpec.setResourceAdapter((ResourceAdapter)this.joramAdapter);
        }
        catch (ResourceException e) {
            throw new EZBComponentException("Cannot set resource adapter on activation spec object", (Throwable)e);
        }
        try {
            this.ictx.rebind("joramActivationSpec", (Object)activationSpec);
        }
        catch (NamingException e) {
            throw new EZBComponentException("Cannot bind activation spec object", (Throwable)e);
        }
        logger.info((Object)"Joram version ''{0}'' started on {1}:{2}", new Object[]{"5.3.0", this.host, String.valueOf(this.port)});
        this.started = true;
    }

    public void stop() throws EZBComponentException {
        if (!this.started) {
            throw new IllegalStateException("Cannot stop a server as it was not started");
        }
        try {
            this.ictx.unbind("joramActivationSpec");
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot unbind activation spec object", new Object[]{e});
        }
        try {
            this.ictx.unbind(CONN_FACT_NAME);
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot unbind activation spec object", new Object[]{e});
        }
        try {
            this.ictx.unbind(QUEUE_CONN_FACT_NAME);
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot unbind activation spec object", new Object[]{e});
        }
        try {
            this.ictx.unbind(TOPIC_CONN_FACT_NAME);
        }
        catch (NamingException e) {
            logger.error((Object)"Cannot unbind activation spec object", new Object[]{e});
        }
        this.joramAdapter.stop();
        this.disconnectFromCollocated();
        AgentServer.stop();
        AgentServer.reset();
        logger.info((Object)"Joram Component Stopped", new Object[0]);
    }

    private void connectToCollocated() throws JoramException {
        try {
            AdminModule.collocatedConnect((String)"root", (String)"root");
        }
        catch (ConnectException e) {
            throw new JoramException("Cannot connect to the collocated server for the administration", e);
        }
        catch (AdminException e) {
            throw new JoramException("Cannot connect to the collocated server for the administration", e);
        }
    }

    private void disconnectFromCollocated() {
        AdminModule.disconnect();
    }

    private void createConnectionFactories() throws JoramException {
        this.joramAdapter.createCF("CF");
        this.joramAdapter.createQueueCF("QCF");
        this.joramAdapter.createTopicCF("TCF");
        ConnectionFactory jcf = null;
        TopicConnectionFactory jtcf = null;
        QueueConnectionFactory jqcf = null;
        String name = CONN_FACT_NAME;
        try {
            jcf = TcpConnectionFactory.create((String)this.host, (int)this.port);
            this.ictx.rebind(name, (Object)jcf);
        }
        catch (NamingException e) {
            throw new JoramException("Cannot create a factory with the name '" + name + "'.", e);
        }
        name = QUEUE_CONN_FACT_NAME;
        try {
            jqcf = QueueTcpConnectionFactory.create((String)this.host, (int)this.port);
            this.ictx.rebind(name, (Object)jqcf);
        }
        catch (NamingException e) {
            throw new JoramException("Cannot create a factory with the name '" + name + "'.", e);
        }
        name = TOPIC_CONN_FACT_NAME;
        try {
            jtcf = TopicTcpConnectionFactory.create((String)this.host, (int)this.port);
            this.ictx.rebind(name, (Object)jtcf);
        }
        catch (NamingException e) {
            throw new JoramException("Cannot create a factory with the name '" + name + "'.", e);
        }
    }

    private void createTopic(String name) throws JoramException {
        try {
            this.joramAdapter.createTopic(name);
        }
        catch (AdminException e) {
            throw new JoramException("Cannot create a topic with the name '" + name + "'.", e);
        }
        catch (ConnectException e) {
            throw new JoramException("Cannot create a topic with the name '" + name + "'.", e);
        }
    }

    private void createQueue(String name) throws JoramException {
        try {
            this.joramAdapter.createQueue(name);
        }
        catch (AdminException e) {
            throw new JoramException("Cannot create a queue with the name '" + name + "'.", e);
        }
        catch (ConnectException e) {
            throw new JoramException("Cannot create a queue with the name '" + name + "'.", e);
        }
    }

    private void createInitialTopics() throws JoramException {
        for (String topic : this.topics) {
            this.createTopic(topic);
        }
    }

    private void createInitialQueues() throws JoramException {
        for (String queue : this.queues) {
            this.createQueue(queue);
        }
    }

    public void setQueues(List<String> queues) {
        this.queues = queues;
    }

    public List<String> getQueues() {
        return this.queues;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.joramAdapter;
    }

    public void setHostname(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public EZBWorkManagerComponent getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(EZBWorkManagerComponent workManager) {
        this.workManager = workManager;
    }

    public TMComponent getTransactionComponent() {
        return this.transactionComponent;
    }

    public void setTransactionComponent(TMComponent transactionComponent) {
        this.transactionComponent = transactionComponent;
    }

    public void updateActivationConfigProperties(Map<String, String> activationConfigProperties) {
    }
}

