/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.connector.OutboundConnectionFactory;
import org.objectweb.joram.client.connector.QueueConnectionRequest;
import org.objectweb.util.monolog.api.BasicLevel;

public class OutboundQueueConnectionFactory
extends OutboundConnectionFactory
implements QueueConnectionFactory {
    private static final long serialVersionUID = 1L;

    OutboundQueueConnectionFactory(ManagedConnectionFactoryImpl mcf, ConnectionManager cxManager) {
        super(mcf, cxManager);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("OutboundQueueConnectionFactory(" + mcf + ", " + cxManager + ")"));
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createQueueConnection()"));
        }
        return this.createQueueConnection(this.mcf.userName, this.mcf.password);
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createQueueConnection(" + userName + ", " + password + ")"));
        }
        try {
            QueueConnectionRequest cxRequest = new QueueConnectionRequest(userName, password, this.mcf.getIdentityClass());
            Object o = this.cxManager.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)cxRequest);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createQueueConnection connection = " + o));
            }
            return (QueueConnection)o;
        }
        catch (SecurityException exc) {
            throw new JMSSecurityException("Invalid user identification: " + (Object)((Object)exc));
        }
        catch (CommException exc) {
            throw new IllegalStateException("Could not connect to the JORAM server: " + (Object)((Object)exc));
        }
        catch (ResourceException exc) {
            throw new JMSException("Could not create connection: " + (Object)((Object)exc));
        }
    }
}

