/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.loader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import org.ow2.easybeans.api.loader.EZBClassLoader;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansClassLoader
extends URLClassLoader
implements EZBClassLoader {
    private static final int BUF_APPEND = 1000;
    private static Log logger = LogFactory.getLog(EasyBeansClassLoader.class);
    private boolean recomputeToString = true;
    private String toStringValue = null;
    private Class<?> javaLangClassLoaderClass = null;
    private Method defineClassMethod = null;
    private Map<String, byte[]> mapDefined = new HashMap<String, byte[]>();
    private List<ClassTransformer> classTransformers = null;

    public EasyBeansClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public EasyBeansClassLoader(URL[] urls) {
        super(urls);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.searchingDefinedClass(name);
        if (clazz != null) {
            return clazz;
        }
        return super.findClass(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> defineInternalClass(String className, byte[] bytecode) {
        block12: {
            if (logger.isDebugEnabled()) {
                String fName = System.getProperty("java.io.tmpdir") + File.separator + className + ".class";
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(fName);
                    fos.write(bytecode);
                    if (fos == null) break block12;
                }
                catch (IOException ioe) {
                    try {
                        throw new RuntimeException(ioe);
                    }
                    catch (Throwable throwable) {
                        if (fos == null) throw throwable;
                        try {
                            fos.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            logger.debug((Object)"Cannot close stream for ''{0}''.", new Object[]{fName});
                        }
                        throw throwable;
                    }
                }
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.debug((Object)"Cannot close stream for ''{0}''.", new Object[]{fName});
                }
            }
        }
        this.checkAndDefinePackage(className);
        try {
            return this.defineClass(className, bytecode, 0, bytecode.length);
        }
        catch (Error e) {
            if (e != null && e.getMessage().contains("duplicate class definition")) {
                logger.debug((Object)"Cannot invoke the defineClass method on the classloader", new Object[]{e});
                return null;
            }
            logger.error((Object)"Cannot invoke the defineClass method on the classloader", new Object[]{e});
            return null;
        }
    }

    public void addClassDefinition(String className, byte[] bytecode) {
        if (this.mapDefined.get(className) != null) {
            logger.debug((Object)("There is already a bytecode defined for the class named '" + className + "'. Not replacing. This could be due to a duplicated class in the given package."), new Object[0]);
        }
        this.mapDefined.put(className, bytecode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        this.searchingDefinedClass(name);
        if (this.classTransformers == null) {
            return super.loadClass(name, false);
        }
        if (this.findLoadedClass(name) != null) {
            return super.loadClass(name, false);
        }
        StringBuilder sb = new StringBuilder(name.replace(".", "/"));
        sb.append(".class");
        String resourceName = sb.toString();
        URL resourceURL = this.findResource(resourceName);
        if (resourceURL == null) {
            return super.loadClass(name, false);
        }
        InputStream inputStream = this.getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new ClassNotFoundException("The resource '" + resourceName + "' was not found");
        }
        byte[] bytes = null;
        try {
            bytes = EasyBeansClassLoader.readClass(inputStream);
        }
        catch (IOException e) {
            try {
                throw new ClassNotFoundException("Cannot read the class ''.", e);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.error((Object)"Cannot close the stream", new Object[]{e2});
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            logger.error((Object)"Cannot close the stream", new Object[]{e});
        }
        Iterator<ClassTransformer> i$ = this.classTransformers.iterator();
        while (true) {
            if (!i$.hasNext()) {
                this.checkAndDefinePackage(name);
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            ClassTransformer classTransformer = i$.next();
            try {
                byte[] updatedBytes = classTransformer.transform((ClassLoader)this, name.replace(".", "/"), null, null, bytes);
                if (updatedBytes == null) continue;
                bytes = updatedBytes;
            }
            catch (IllegalClassFormatException e) {
                throw new ClassNotFoundException("Cannot transform the resource '" + resourceName + "'", e);
            }
        }
    }

    protected void checkAndDefinePackage(String className) {
        String packageName;
        Package pkg;
        int i = className.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(packageName = className.substring(0, i))) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
    }

    private Class<?> searchingDefinedClass(String className) {
        Class<?> clazz;
        byte[] defined;
        if (this.mapDefined != null && (defined = this.mapDefined.get(className)) != null && (clazz = this.defineInternalClass(className, defined)) != null) {
            this.mapDefined.remove(className);
            return clazz;
        }
        return null;
    }

    public String toString() {
        if (this.recomputeToString) {
            this.computeToString();
        }
        return this.toStringValue;
    }

    private void computeToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[");
        sb.append("urls=");
        URL[] urls = this.getURLs();
        for (int u = 0; u < urls.length; ++u) {
            sb.append(urls[u]);
            if (u == urls.length - 1) continue;
            sb.append(";");
        }
        sb.append("]");
        this.toStringValue = sb.toString();
        this.recomputeToString = false;
    }

    public ClassLoader duplicate() {
        PrivilegedAction<EasyBeansClassLoader> privilegedAction = new PrivilegedAction<EasyBeansClassLoader>(){

            @Override
            public EasyBeansClassLoader run() {
                return new EasyBeansClassLoader(EasyBeansClassLoader.this.getURLs(), EasyBeansClassLoader.this.getParent());
            }
        };
        return AccessController.doPrivileged(privilegedAction);
    }

    public void addTransformer(ClassTransformer transformer) {
        if (this.classTransformers == null) {
            this.classTransformers = new ArrayList<ClassTransformer>();
        }
        this.classTransformers.add(transformer);
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Given input stream is null");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }
}

