/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.deployer.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.repository.Repositories;
import org.ow2.util.plan.bindings.repository.Repository;
import org.ow2.util.plan.deploy.deployable.api.RepositoryDeployable;
import org.ow2.util.plan.deployer.api.IRepositoryDeployer;
import org.ow2.util.plan.reader.repository.IRepositoryDataReader;
import org.ow2.util.plan.repository.api.IRepositoryManager;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsRepositoryDeployerImpl
implements IRepositoryDeployer {
    private Log logger = LogFactory.getLog(AbsRepositoryDeployerImpl.class);
    private Collection<RepositoryDeployable> repositoryDeployables = new ArrayList<RepositoryDeployable>();
    private IRepositoryDataReader repositoryReader = null;

    public void deploy(IDeployable<?> deployable) throws DeployerException {
        if (deployable == null) {
            throw new DeployerException("Null deployable");
        }
        if (!RepositoryDeployable.class.isInstance(deployable)) {
            throw new DeployerException("Bad deployable class: " + deployable.getClass());
        }
        RepositoryDeployable repositoryDeployable = (RepositoryDeployable)RepositoryDeployable.class.cast(deployable);
        Repositories repositories = null;
        if (this.repositoryReader == null) {
            this.logger.error((Object)"Deployment aborted - the RepositoryDataReader is null", new Object[0]);
            throw new DeployerException("the RepositoryDataReader is null");
        }
        URL archiveUrl = null;
        try {
            archiveUrl = repositoryDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            this.logger.error((Object)"Error while getting URL for archive {0} - Deployment aborted", new Object[]{repositoryDeployable.getArchive()});
            throw new DeployerException((Throwable)e);
        }
        try {
            File archiveFile = URLUtils.urlToFile((URL)archiveUrl);
            repositories = this.repositoryReader.readRepositories(archiveFile);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while parsing archive {0} - Deployment aborted", new Object[]{archiveUrl});
            throw new DeployerException((Throwable)e);
        }
        if (repositories == null) {
            this.logger.error((Object)"The deployable {0} resolved in null repository data - Deployment aborted", new Object[]{deployable});
            throw new DeployerException("null repositories structure");
        }
        repositoryDeployable.setAttachedData((Object)repositories);
        this.addToRepositoryManager(repositories);
        this.repositoryDeployables.add(repositoryDeployable);
        this.logger.debug((Object)"Repository Deployable {0} deployed", new Object[]{deployable});
        StringBuilder repositorySB = new StringBuilder();
        for (Repository repository : repositories.getRepositories()) {
            repositorySB.append("\t- ");
            repositorySB.append(repository.toString());
            repositorySB.append("\n");
        }
        this.logger.debug((Object)"- {0} repositories added :\n{1}", new Object[]{repositories.getRepositories().size(), repositorySB.toString()});
    }

    protected void addToRepositoryManager(Repositories repositories) throws DeployerException {
        IRepositoryManager repositoryManager = this.getRepositoryManager();
        for (Repository repository : repositories.getRepositories()) {
            try {
                repositoryManager.addRepository(repository);
            }
            catch (Exception e) {
                for (Repository deletedRepository : repositories.getRepositories()) {
                    repositoryManager.removeRepository(deletedRepository);
                }
                throw new DeployerException((Throwable)e);
            }
        }
    }

    protected void removeFromRepositoryManager(Repositories repositories) {
        IRepositoryManager repositoryManager = this.getRepositoryManager();
        for (Repository repository : repositories.getRepositories()) {
            repositoryManager.removeRepository(repository);
        }
    }

    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        if (deployable == null) {
            throw new DeployerException("Null deployable");
        }
        if (!RepositoryDeployable.class.isInstance(deployable)) {
            throw new DeployerException("Bad deployable class: " + deployable.getClass());
        }
        return this.repositoryDeployables.contains(deployable);
    }

    public boolean supports(IDeployable<?> deployable) {
        return RepositoryDeployable.class.isInstance(deployable);
    }

    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        RepositoryDeployable repositoryDeployableToUndeployReally;
        if (deployable == null) {
            throw new DeployerException("Null deployable");
        }
        if (!this.supports(deployable)) {
            throw new DeployerException("Bad deployable class: " + deployable.getClass());
        }
        if (this.isDeployed(deployable)) {
            RepositoryDeployable repositoryDeployableToUndeploy = (RepositoryDeployable)RepositoryDeployable.class.cast(deployable);
            repositoryDeployableToUndeployReally = null;
            for (RepositoryDeployable repositoryDeployable : this.repositoryDeployables) {
                if (!repositoryDeployable.equals(repositoryDeployableToUndeploy)) continue;
                repositoryDeployableToUndeployReally = repositoryDeployable;
                break;
            }
            if (repositoryDeployableToUndeployReally == null) {
                throw new DeployerException("Didn't found deployable to undeploy" + deployable);
            }
        } else {
            throw new DeployerException("Cannot undeploy repository deployable " + deployable + " that is not deployed");
        }
        Repositories repositories = (Repositories)repositoryDeployableToUndeployReally.getAttachedData();
        this.removeFromRepositoryManager(repositories);
        this.repositoryDeployables.remove(repositoryDeployableToUndeployReally);
        this.logger.info((Object)"Repository deployable {0} undeployed", new Object[]{deployable});
    }

    @Override
    public void setReader(IRepositoryDataReader reader) {
        this.repositoryReader = reader;
    }

    @Override
    public IRepositoryDataReader getReader() {
        return this.repositoryReader;
    }

    @Override
    public int getDeployablesCount() {
        return this.repositoryDeployables.size();
    }

    protected abstract IRepositoryManager getRepositoryManager();
}

