/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.auditreport.impl;

import org.ow2.util.auditreport.impl.EncodingType;
import org.ow2.util.auditreport.impl.GenericAuditReport;
import org.ow2.util.auditreport.impl.util.ObjectEncoder;

public class JNDIAuditReport
extends GenericAuditReport {
    private static final long serialVersionUID = 1935408900498244921L;
    private long requestStart = 0L;
    private long requestStop = 0L;
    private double requestDuration = 0.0;
    private String businessMethod = "";
    private String target = "";
    private String[] contextParameters = null;

    public JNDIAuditReport() {
    }

    public JNDIAuditReport(long requestTimeStampParam, String businessMethodParam, String targetParam, String[] contextParameters, Thread currentThreadParam, long start, long stop) {
        int freeMemory = (int)Runtime.getRuntime().freeMemory();
        int totalMemory = (int)Runtime.getRuntime().totalMemory();
        this.setCallLevel(0);
        this.setRequestTimeStamp(requestTimeStampParam);
        this.setFreeMemoryBefore(freeMemory);
        this.setTotalMemoryBefore(totalMemory);
        this.setFreeMemoryAfter(freeMemory);
        this.setTotalMemoryAfter(totalMemory);
        this.setRoles("jndi");
        this.target = targetParam;
        this.businessMethod = businessMethodParam;
        this.contextParameters = contextParameters;
        this.requestStart = start;
        this.requestStop = stop;
        this.requestDuration = (double)(this.requestStop - this.requestStart) / 1000000.0;
    }

    public String getBusinessMethod() {
        return this.businessMethod;
    }

    public void setBusinessMethod(String businessMethod) {
        this.businessMethod = businessMethod;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String[] getContextParameters() {
        return this.contextParameters;
    }

    public void setContextParameters(String[] contextParameters) {
        this.contextParameters = contextParameters;
    }

    public double getRequestDuration() {
        return this.requestDuration;
    }

    public void setRequestDuration(double requestDuration) {
        this.requestDuration = requestDuration;
    }

    public long getRequestStart() {
        return this.requestStart;
    }

    public void setRequestStart(long requestStart) {
        this.requestStart = requestStart;
    }

    public long getRequestStop() {
        return this.requestStop;
    }

    public void setRequestStop(long requestStop) {
        this.requestStop = requestStop;
    }

    static {
        ObjectEncoder.registerField(JNDIAuditReport.class, "contextParameters", EncodingType.OBJECTTABLE);
    }
}

