/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.concurrency.lib;

import org.objectweb.perseus.concurrency.lib.LockValue;

public class ReadWriteLockValue
implements LockValue {
    public static final byte READ = 1;
    public static final byte UPGRADE = 2;
    public static final byte WRITE = 3;
    static final byte[] compTable = new byte[]{15, 3, 1, 1};

    public byte maxValue() {
        return 3;
    }

    public boolean isCompatibleWith(byte l1, byte l2) {
        boolean res = (1 << l1 & compTable[l2]) != 0;
        return res;
    }

    public byte getCompatibleWith(byte l1, byte l2) {
        while (!this.isCompatibleWith(l1, l2)) {
            l1 = (byte)(l1 - 1);
        }
        return l1;
    }

    public String str(byte l) {
        switch (l) {
            case 0: {
                return "NOLOCK";
            }
            case 1: {
                return "READ";
            }
            case 2: {
                return "UPGRADE";
            }
            case 3: {
                return "WRITE";
            }
        }
        return "UNDEFINED";
    }
}

