/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.ow2.cmi.controller.server.Domain;
import org.ow2.cmi.reference.ServerRef;

@NotThreadSafe
public class ServerView
implements Serializable {
    private static final long serialVersionUID = -2744394720016534529L;
    private static final int DEFAULT_LOAD_FACTOR = 100;
    private final ServerRef serverRef;
    private boolean blacklisted = false;
    private int loadFactor = 100;
    private final short id;
    private final String serverName;
    private Map<String, Domain> domains = new HashMap<String, Domain>();

    public ServerView(ServerRef serverRef, short id, String serverName) {
        this.serverRef = serverRef;
        this.id = id;
        this.serverName = serverName;
    }

    public ServerRef getServerRef() {
        return this.serverRef;
    }

    public void setLoadFactor(int loadFactor) {
        this.loadFactor = loadFactor;
    }

    public boolean isBlacklisted() {
        return this.blacklisted;
    }

    public void setBlacklisted(boolean blacklisted) {
        this.blacklisted = blacklisted;
    }

    public int getLoadFactor() {
        return this.loadFactor;
    }

    public short getId() {
        return this.id;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Domain getDomain(String domainName) {
        return this.domains.get(domainName);
    }

    public void addDomain(Domain domain) {
        this.domains.put(domain.getName(), domain);
    }

    public String toString() {
        return "ServerView[blacklisted=" + this.blacklisted + ", loadFactor=" + this.loadFactor + ", id=" + this.id + ", serverName=" + this.serverName + ", domains=" + this.domains + "]";
    }
}

