/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectQuery;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthorizationDecisionQuery
extends SAMLSubjectQuery
implements Cloneable {
    protected String resource = null;
    protected ArrayList actions = new ArrayList();
    protected ArrayList evidence = new ArrayList();

    public SAMLAuthorizationDecisionQuery() {
    }

    public SAMLAuthorizationDecisionQuery(SAMLSubject sAMLSubject, String string, Collection collection, Collection collection2) throws SAMLException {
        super(sAMLSubject);
        this.resource = string;
        this.actions.addAll(collection);
        if (collection2 != null) {
            this.evidence.addAll(collection2);
        }
    }

    public SAMLAuthorizationDecisionQuery(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAuthorizationDecisionQuery(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAuthorizationDecisionQuery.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQuery")) {
            object = QName.getQNameAttribute(element, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "Query") && XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "SubjectQuery") && object != null && "urn:oasis:names:tc:SAML:1.0:protocol".equals(((QName)object).getNamespaceURI()) && "AuthorizationDecisionQueryType".equals(((QName)object).getLocalName()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAuthorizationDecisionQuery.fromDOM() requires samlp:AuthorizationDecisionQuery at root");
            }
        }
        this.resource = element.getAttributeNS(null, "Resource");
        object = XML.getFirstChildElement(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Action");
        while (object != null) {
            this.actions.add(new SAMLAction((Element)object));
            object = XML.getNextSiblingElement((Node)object, "urn:oasis:names:tc:SAML:1.0:assertion", "Action");
        }
        object = XML.getFirstChildElement(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Evidence");
        if (object != null) {
            Element element2 = XML.getFirstChildElement((Node)object);
            while (element2 != null) {
                if (XML.isElementNamed(element2, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) {
                    this.evidence.add(new SAMLAssertion(element2));
                } else if (XML.isElementNamed(element2, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference")) {
                    this.evidence.add(element2.getFirstChild().getNodeValue());
                }
                element2 = XML.getNextSiblingElement(element2);
            }
        }
        this.checkValidity();
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("resource cannot be null");
        }
        this.resource = string;
        if (this.root != null) {
            ((Element)this.root).getAttributeNodeNS(null, "Resource").setNodeValue(string);
        }
    }

    public Iterator getActions() {
        return this.actions.iterator();
    }

    public void setActions(Collection collection) throws SAMLException {
        while (this.actions.size() > 0) {
            this.removeAction(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addAction((SAMLAction)iterator.next());
            }
        }
    }

    public void addAction(SAMLAction sAMLAction) throws SAMLException {
        if (sAMLAction != null) {
            if (this.root != null) {
                Element element = XML.getLastChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Action");
                if (element == null) {
                    this.root.insertBefore(sAMLAction.toDOM(this.root.getOwnerDocument()), this.subject.root.getNextSibling());
                } else {
                    this.root.insertBefore(sAMLAction.toDOM(this.root.getOwnerDocument()), element.getNextSibling());
                }
            }
        } else {
            throw new IllegalArgumentException("action cannot be null");
        }
        this.actions.add(sAMLAction);
    }

    public void removeAction(int n) {
        this.actions.remove(n);
        if (this.root != null) {
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Action");
            while (element != null && n > 0) {
                element = XML.getNextSiblingElement(element);
                --n;
            }
            if (element != null) {
                this.root.removeChild(element);
            } else {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public Iterator getEvidence() {
        return this.evidence.iterator();
    }

    public void setEvidence(Collection collection) throws SAMLException {
        while (this.evidence.size() > 0) {
            this.removeEvidence(0);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addEvidence(iterator.next());
            }
        }
    }

    public void addEvidence(Object object) throws SAMLException {
        if (object != null && (object instanceof String || object instanceof SAMLAssertion)) {
            if (this.root != null) {
                Document document = this.root.getOwnerDocument();
                Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Evidence");
                if (element == null) {
                    element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Evidence");
                    if (this.actions.size() == 0) {
                        this.root.insertBefore(element, this.subject.root.getNextSibling());
                    } else {
                        this.root.insertBefore(element, ((SAMLAction)this.actions.get((int)(this.actions.size() - 1))).root.getNextSibling());
                    }
                }
                if (object instanceof String && !XML.isEmpty((String)object)) {
                    Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference");
                    element2.appendChild(document.createTextNode((String)object));
                    element.appendChild(element2);
                } else if (object instanceof SAMLAssertion) {
                    element.appendChild(((SAMLAssertion)object).toDOM(document));
                }
            }
        } else {
            throw new IllegalArgumentException("can only add Strings or SAMLAssertions");
        }
        this.evidence.add(object);
    }

    public void removeEvidence(int n) throws IndexOutOfBoundsException {
        this.evidence.remove(n);
        if (this.root != null) {
            Element element = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "Evidence");
            Element element2 = XML.getFirstChildElement(element);
            while (element2 != null && n > 0) {
                element2 = XML.getNextSiblingElement(element2);
                --n;
            }
            if (element2 == null) {
                throw new IndexOutOfBoundsException();
            }
            element.removeChild(element2);
            if (this.evidence.size() == 0) {
                this.root.removeChild(element);
            }
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
            }
            return this.root;
        }
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQuery");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        element.setAttributeNS(null, "Resource", this.resource);
        element.appendChild(this.subject.toDOM(document));
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            element.appendChild(((SAMLAction)iterator.next()).toDOM(document));
        }
        if (this.evidence.size() > 0) {
            Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Evidence");
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            iterator = this.evidence.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof SAMLAssertion) {
                    element2.appendChild(((SAMLAssertion)e).toDOM(document, false));
                    continue;
                }
                if (!(e instanceof String) || XML.isEmpty((String)e)) continue;
                element2.appendChild(document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference")).appendChild(document.createTextNode((String)e));
            }
            element.appendChild(element2);
        }
        this.root = element;
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        super.checkValidity();
        if (XML.isEmpty(this.resource) || this.actions.size() == 0) {
            throw new MalformedException("AuthorizationDecisionQuery is invalid, must have Resource and at least one Action");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAuthorizationDecisionQuery sAMLAuthorizationDecisionQuery = (SAMLAuthorizationDecisionQuery)super.clone();
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            sAMLAuthorizationDecisionQuery.actions.add(((SAMLAction)iterator.next()).clone());
        }
        iterator = this.evidence.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof SAMLAssertion) {
                sAMLAuthorizationDecisionQuery.evidence.add(((SAMLAssertion)e).clone());
                continue;
            }
            if (!(e instanceof String)) continue;
            sAMLAuthorizationDecisionQuery.evidence.add(e);
        }
        return sAMLAuthorizationDecisionQuery;
    }
}

