/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProducerTemplate
extends ServiceSupport
implements ProducerTemplate {
    private static final int DEFAULT_THREADPOOL_SIZE = 10;
    private final CamelContext context;
    private final ProducerCache producerCache;
    private Endpoint defaultEndpoint;
    private ExecutorService executor;

    public DefaultProducerTemplate(CamelContext context) {
        this.context = context;
        this.producerCache = new ProducerCache(context);
        this.executor = ExecutorServiceHelper.newScheduledThreadPool(10, "ProducerTemplate", true);
    }

    public DefaultProducerTemplate(CamelContext context, ExecutorService executor) {
        this.context = context;
        this.producerCache = new ProducerCache(context);
        this.executor = executor;
    }

    public DefaultProducerTemplate(CamelContext context, Endpoint defaultEndpoint) {
        this(context);
        this.defaultEndpoint = defaultEndpoint;
    }

    public static DefaultProducerTemplate newInstance(CamelContext camelContext, String defaultEndpointUri) {
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint(camelContext, defaultEndpointUri);
        return new DefaultProducerTemplate(camelContext, endpoint);
    }

    @Override
    public Exchange send(String endpointUri, Exchange exchange) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, exchange);
    }

    @Override
    public Exchange send(String endpointUri, Processor processor) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, processor);
    }

    @Override
    public Exchange send(String endpointUri, ExchangePattern pattern, Processor processor) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        return this.send(endpoint, pattern, processor);
    }

    @Override
    public Exchange send(Endpoint endpoint, Exchange exchange) {
        this.producerCache.send(endpoint, exchange);
        return exchange;
    }

    @Override
    public Exchange send(Endpoint endpoint, Processor processor) {
        return this.producerCache.send(endpoint, processor);
    }

    @Override
    public Exchange send(Endpoint endpoint, ExchangePattern pattern, Processor processor) {
        return this.producerCache.send(endpoint, pattern, processor);
    }

    @Override
    public Object sendBody(Endpoint endpoint, ExchangePattern pattern, Object body) {
        Exchange result = this.send(endpoint, pattern, this.createSetBodyProcessor(body));
        return this.extractResultBody(result, pattern);
    }

    @Override
    public void sendBody(Endpoint endpoint, Object body) {
        Exchange result = this.send(endpoint, this.createSetBodyProcessor(body));
        this.extractResultBody(result);
    }

    @Override
    public void sendBody(String endpointUri, Object body) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        this.sendBody(endpoint, body);
    }

    @Override
    public Object sendBody(String endpointUri, ExchangePattern pattern, Object body) {
        Endpoint endpoint = this.resolveMandatoryEndpoint(endpointUri);
        Object result = this.sendBody(endpoint, pattern, body);
        if (pattern.isOutCapable()) {
            return result;
        }
        return null;
    }

    @Override
    public void sendBodyAndHeader(String endpointUri, Object body, String header, Object headerValue) {
        this.sendBodyAndHeader(this.resolveMandatoryEndpoint(endpointUri), body, header, headerValue);
    }

    @Override
    public void sendBodyAndHeader(Endpoint endpoint, Object body, String header, Object headerValue) {
        Exchange result = this.send(endpoint, this.createBodyAndHeaderProcessor(body, header, headerValue));
        this.extractResultBody(result);
    }

    @Override
    public Object sendBodyAndHeader(Endpoint endpoint, ExchangePattern pattern, Object body, String header, Object headerValue) {
        Exchange exchange = this.send(endpoint, pattern, this.createBodyAndHeaderProcessor(body, header, headerValue));
        Object result = this.extractResultBody(exchange, pattern);
        if (pattern.isOutCapable()) {
            return result;
        }
        return null;
    }

    @Override
    public Object sendBodyAndHeader(String endpoint, ExchangePattern pattern, Object body, String header, Object headerValue) {
        Exchange exchange = this.send(endpoint, pattern, this.createBodyAndHeaderProcessor(body, header, headerValue));
        Object result = this.extractResultBody(exchange, pattern);
        if (pattern.isOutCapable()) {
            return result;
        }
        return null;
    }

    @Override
    public void sendBodyAndProperty(String endpointUri, Object body, String property, Object propertyValue) {
        this.sendBodyAndProperty(this.resolveMandatoryEndpoint(endpointUri), body, property, propertyValue);
    }

    @Override
    public void sendBodyAndProperty(Endpoint endpoint, Object body, String property, Object propertyValue) {
        Exchange result = this.send(endpoint, this.createBodyAndPropertyProcessor(body, property, propertyValue));
        this.extractResultBody(result);
    }

    @Override
    public Object sendBodyAndProperty(Endpoint endpoint, ExchangePattern pattern, Object body, String property, Object propertyValue) {
        Exchange exchange = this.send(endpoint, pattern, this.createBodyAndPropertyProcessor(body, property, propertyValue));
        Object result = this.extractResultBody(exchange, pattern);
        if (pattern.isOutCapable()) {
            return result;
        }
        return null;
    }

    @Override
    public Object sendBodyAndProperty(String endpoint, ExchangePattern pattern, Object body, String property, Object propertyValue) {
        Exchange exchange = this.send(endpoint, pattern, this.createBodyAndPropertyProcessor(body, property, propertyValue));
        Object result = this.extractResultBody(exchange, pattern);
        if (pattern.isOutCapable()) {
            return result;
        }
        return null;
    }

    @Override
    public void sendBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) {
        this.sendBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), body, headers);
    }

    @Override
    public void sendBodyAndHeaders(Endpoint endpoint, final Object body, final Map<String, Object> headers) {
        Exchange result = this.send(endpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                for (Map.Entry header : headers.entrySet()) {
                    in.setHeader((String)header.getKey(), header.getValue());
                }
                in.setBody(body);
            }
        });
        this.extractResultBody(result);
    }

    @Override
    public Object sendBodyAndHeaders(String endpointUri, ExchangePattern pattern, Object body, Map<String, Object> headers) {
        return this.sendBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), pattern, body, headers);
    }

    @Override
    public Object sendBodyAndHeaders(Endpoint endpoint, ExchangePattern pattern, final Object body, final Map<String, Object> headers) {
        Exchange exchange = this.send(endpoint, pattern, new Processor(){

            public void process(Exchange exchange) throws Exception {
                Message in = exchange.getIn();
                for (Map.Entry header : headers.entrySet()) {
                    in.setHeader((String)header.getKey(), header.getValue());
                }
                in.setBody(body);
            }
        });
        Object result = this.extractResultBody(exchange, pattern);
        if (pattern.isOutCapable()) {
            return result;
        }
        return null;
    }

    @Override
    public Exchange request(Endpoint endpoint, Processor processor) {
        return this.send(endpoint, ExchangePattern.InOut, processor);
    }

    @Override
    public Object requestBody(Object body) {
        return this.sendBody(this.getMandatoryDefaultEndpoint(), ExchangePattern.InOut, body);
    }

    @Override
    public Object requestBody(Endpoint endpoint, Object body) {
        return this.sendBody(endpoint, ExchangePattern.InOut, body);
    }

    @Override
    public Object requestBodyAndHeader(Object body, String header, Object headerValue) {
        return this.sendBodyAndHeader(this.getMandatoryDefaultEndpoint(), ExchangePattern.InOut, body, header, headerValue);
    }

    @Override
    public Object requestBodyAndHeader(Endpoint endpoint, Object body, String header, Object headerValue) {
        return this.sendBodyAndHeader(endpoint, ExchangePattern.InOut, body, header, headerValue);
    }

    @Override
    public Exchange request(String endpoint, Processor processor) {
        return this.send(endpoint, ExchangePattern.InOut, processor);
    }

    @Override
    public Object requestBody(String endpoint, Object body) {
        return this.sendBody(endpoint, ExchangePattern.InOut, body);
    }

    @Override
    public Object requestBodyAndHeader(String endpoint, Object body, String header, Object headerValue) {
        return this.sendBodyAndHeader(endpoint, ExchangePattern.InOut, body, header, headerValue);
    }

    @Override
    public Object requestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) {
        return this.requestBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), body, headers);
    }

    @Override
    public Object requestBodyAndHeaders(Endpoint endpoint, Object body, Map<String, Object> headers) {
        return this.sendBodyAndHeaders(endpoint, ExchangePattern.InOut, body, headers);
    }

    @Override
    public Object requestBodyAndHeaders(Object body, Map<String, Object> headers) {
        return this.sendBodyAndHeaders(this.getDefaultEndpoint(), ExchangePattern.InOut, body, headers);
    }

    @Override
    public <T> T requestBody(Object body, Class<T> type) {
        Object answer = this.requestBody(body);
        return this.context.getTypeConverter().convertTo(type, answer);
    }

    @Override
    public <T> T requestBody(Endpoint endpoint, Object body, Class<T> type) {
        Object answer = this.requestBody(endpoint, body);
        return this.context.getTypeConverter().convertTo(type, answer);
    }

    @Override
    public <T> T requestBody(String endpointUri, Object body, Class<T> type) {
        Object answer = this.requestBody(endpointUri, body);
        return this.context.getTypeConverter().convertTo(type, answer);
    }

    @Override
    public <T> T requestBodyAndHeader(Endpoint endpoint, Object body, String header, Object headerValue, Class<T> type) {
        Object answer = this.requestBodyAndHeader(endpoint, body, header, headerValue);
        return this.context.getTypeConverter().convertTo(type, answer);
    }

    @Override
    public <T> T requestBodyAndHeader(String endpointUri, Object body, String header, Object headerValue, Class<T> type) {
        Object answer = this.requestBodyAndHeader(endpointUri, body, header, headerValue);
        return this.context.getTypeConverter().convertTo(type, answer);
    }

    @Override
    public <T> T requestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers, Class<T> type) {
        Object answer = this.requestBodyAndHeaders(endpointUri, body, headers);
        return this.context.getTypeConverter().convertTo(type, answer);
    }

    @Override
    public <T> T requestBodyAndHeaders(Endpoint endpoint, Object body, Map<String, Object> headers, Class<T> type) {
        Object answer = this.requestBodyAndHeaders(endpoint, body, headers);
        return this.context.getTypeConverter().convertTo(type, answer);
    }

    @Override
    public void sendBody(Object body) {
        this.sendBody(this.getMandatoryDefaultEndpoint(), body);
    }

    @Override
    public Exchange send(Exchange exchange) {
        return this.send(this.getMandatoryDefaultEndpoint(), exchange);
    }

    @Override
    public Exchange send(Processor processor) {
        return this.send(this.getMandatoryDefaultEndpoint(), processor);
    }

    @Override
    public void sendBodyAndHeader(Object body, String header, Object headerValue) {
        this.sendBodyAndHeader(this.getMandatoryDefaultEndpoint(), body, header, headerValue);
    }

    @Override
    public void sendBodyAndProperty(Object body, String property, Object propertyValue) {
        this.sendBodyAndProperty(this.getMandatoryDefaultEndpoint(), body, property, propertyValue);
    }

    @Override
    public void sendBodyAndHeaders(Object body, Map<String, Object> headers) {
        this.sendBodyAndHeaders(this.getMandatoryDefaultEndpoint(), body, headers);
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Endpoint getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(Endpoint defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public void setDefaultEndpointUri(String endpointUri) {
        this.setDefaultEndpoint(this.getContext().getEndpoint(endpointUri));
    }

    public <T extends Endpoint> T getResolvedEndpoint(String endpointUri, Class<T> expectedClass) {
        return this.context.getEndpoint(endpointUri, expectedClass);
    }

    protected Processor createBodyAndHeaderProcessor(final Object body, final String header, final Object headerValue) {
        return new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setHeader(header, headerValue);
                in.setBody(body);
            }
        };
    }

    protected Processor createBodyAndPropertyProcessor(final Object body, final String property, final Object propertyValue) {
        return new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty(property, propertyValue);
                Message in = exchange.getIn();
                in.setBody(body);
            }
        };
    }

    protected Processor createSetBodyProcessor(final Object body) {
        return new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
            }
        };
    }

    protected Endpoint resolveMandatoryEndpoint(String endpointUri) {
        Endpoint endpoint = this.context.getEndpoint(endpointUri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(endpointUri);
        }
        return endpoint;
    }

    protected Endpoint getMandatoryDefaultEndpoint() {
        Endpoint answer = this.getDefaultEndpoint();
        ObjectHelper.notNull(answer, "defaultEndpoint");
        return answer;
    }

    @Override
    protected void doStart() throws Exception {
        this.producerCache.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.producerCache.stop();
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    protected Object extractResultBody(Exchange result) {
        return this.extractResultBody(result, null);
    }

    protected Object extractResultBody(Exchange result, ExchangePattern pattern) {
        return ExchangeHelper.extractResultBody(result, pattern);
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executor = executorService;
    }

    @Override
    public Future<Exchange> asyncSend(String uri, Exchange exchange) {
        return this.asyncSend(this.resolveMandatoryEndpoint(uri), exchange);
    }

    @Override
    public Future<Exchange> asyncSend(String uri, Processor processor) {
        return this.asyncSend(this.resolveMandatoryEndpoint(uri), processor);
    }

    @Override
    public Future<Object> asyncSendBody(String uri, Object body) {
        return this.asyncSendBody(this.resolveMandatoryEndpoint(uri), body);
    }

    @Override
    public Future<Object> asyncRequestBody(String uri, Object body) {
        return this.asyncRequestBody(this.resolveMandatoryEndpoint(uri), body);
    }

    @Override
    public <T> Future<T> asyncRequestBody(String uri, Object body, Class<T> type) {
        return this.asyncRequestBody(this.resolveMandatoryEndpoint(uri), body, type);
    }

    @Override
    public Future<Object> asyncRequestBodyAndHeader(String endpointUri, Object body, String header, Object headerValue) {
        return this.asyncRequestBodyAndHeader(this.resolveMandatoryEndpoint(endpointUri), body, header, headerValue);
    }

    @Override
    public <T> Future<T> asyncRequestBodyAndHeader(String endpointUri, Object body, String header, Object headerValue, Class<T> type) {
        return this.asyncRequestBodyAndHeader(this.resolveMandatoryEndpoint(endpointUri), body, header, headerValue, type);
    }

    @Override
    public Future<Object> asyncRequestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers) {
        return this.asyncRequestBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), body, headers);
    }

    @Override
    public <T> Future<T> asyncRequestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers, Class<T> type) {
        return this.asyncRequestBodyAndHeaders(this.resolveMandatoryEndpoint(endpointUri), body, headers, type);
    }

    @Override
    public <T> T extractFutureBody(Future<Object> future, Class<T> type) {
        return ExchangeHelper.extractFutureBody(this.context, future, type);
    }

    @Override
    public <T> T extractFutureBody(Future<Object> future, long timeout, TimeUnit unit, Class<T> type) throws TimeoutException {
        return ExchangeHelper.extractFutureBody(this.context, future, timeout, unit, type);
    }

    @Override
    public Future<Object> asyncCallbackSendBody(String uri, Object body, Synchronization onCompletion) {
        return this.asyncCallbackSendBody(this.resolveMandatoryEndpoint(uri), body, onCompletion);
    }

    @Override
    public Future<Object> asyncCallbackSendBody(Endpoint endpoint, Object body, Synchronization onCompletion) {
        return this.asyncCallback(endpoint, ExchangePattern.InOnly, body, onCompletion);
    }

    @Override
    public Future<Object> asyncCallbackRequestBody(String uri, Object body, Synchronization onCompletion) {
        return this.asyncCallbackRequestBody(this.resolveMandatoryEndpoint(uri), body, onCompletion);
    }

    @Override
    public Future<Object> asyncCallbackRequestBody(Endpoint endpoint, Object body, Synchronization onCompletion) {
        return this.asyncCallback(endpoint, ExchangePattern.InOut, body, onCompletion);
    }

    @Override
    public Future<Exchange> asyncCallback(String uri, Exchange exchange, Synchronization onCompletion) {
        return this.asyncCallback(this.resolveMandatoryEndpoint(uri), exchange, onCompletion);
    }

    @Override
    public Future<Exchange> asyncCallback(String uri, Processor processor, Synchronization onCompletion) {
        return this.asyncCallback(this.resolveMandatoryEndpoint(uri), processor, onCompletion);
    }

    @Override
    public Future<Object> asyncRequestBody(final Endpoint endpoint, final Object body) {
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return DefaultProducerTemplate.this.requestBody(endpoint, body);
            }
        };
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> asyncRequestBody(final Endpoint endpoint, final Object body, final Class<T> type) {
        Callable task = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return DefaultProducerTemplate.this.requestBody(endpoint, body, type);
            }
        };
        return this.executor.submit(task);
    }

    @Override
    public Future<Object> asyncRequestBodyAndHeader(final Endpoint endpoint, final Object body, final String header, final Object headerValue) {
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return DefaultProducerTemplate.this.requestBodyAndHeader(endpoint, body, header, headerValue);
            }
        };
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> asyncRequestBodyAndHeader(final Endpoint endpoint, final Object body, final String header, final Object headerValue, final Class<T> type) {
        Callable task = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return DefaultProducerTemplate.this.requestBodyAndHeader(endpoint, body, header, headerValue, type);
            }
        };
        return this.executor.submit(task);
    }

    @Override
    public Future<Object> asyncRequestBodyAndHeaders(final Endpoint endpoint, final Object body, final Map<String, Object> headers) {
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return DefaultProducerTemplate.this.requestBodyAndHeaders(endpoint, body, (Map<String, Object>)headers);
            }
        };
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> asyncRequestBodyAndHeaders(final Endpoint endpoint, final Object body, final Map<String, Object> headers, final Class<T> type) {
        Callable task = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return DefaultProducerTemplate.this.requestBodyAndHeaders(endpoint, body, (Map<String, Object>)headers, type);
            }
        };
        return this.executor.submit(task);
    }

    @Override
    public Future<Exchange> asyncSend(final Endpoint endpoint, final Exchange exchange) {
        Callable<Exchange> task = new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                return DefaultProducerTemplate.this.send(endpoint, exchange);
            }
        };
        return this.executor.submit(task);
    }

    @Override
    public Future<Exchange> asyncSend(final Endpoint endpoint, final Processor processor) {
        Callable<Exchange> task = new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                return DefaultProducerTemplate.this.send(endpoint, processor);
            }
        };
        return this.executor.submit(task);
    }

    @Override
    public Future<Object> asyncSendBody(final Endpoint endpoint, final Object body) {
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DefaultProducerTemplate.this.sendBody(endpoint, body);
                return null;
            }
        };
        return this.executor.submit(task);
    }

    public Future<Object> asyncCallback(final Endpoint endpoint, final ExchangePattern pattern, final Object body, final Synchronization onCompletion) {
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Exchange answer = DefaultProducerTemplate.this.send(endpoint, pattern, DefaultProducerTemplate.this.createSetBodyProcessor(body));
                if (answer.isFailed()) {
                    onCompletion.onFailure(answer);
                } else {
                    onCompletion.onComplete(answer);
                }
                Object result = DefaultProducerTemplate.this.extractResultBody(answer, pattern);
                if (pattern.isOutCapable()) {
                    return result;
                }
                return null;
            }
        };
        return this.executor.submit(task);
    }

    @Override
    public Future<Exchange> asyncCallback(final Endpoint endpoint, final Exchange exchange, final Synchronization onCompletion) {
        Callable<Exchange> task = new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                Exchange answer = DefaultProducerTemplate.this.send(endpoint, exchange);
                if (answer.isFailed()) {
                    onCompletion.onFailure(answer);
                } else {
                    onCompletion.onComplete(answer);
                }
                return answer;
            }
        };
        return this.executor.submit(task);
    }

    @Override
    public Future<Exchange> asyncCallback(final Endpoint endpoint, final Processor processor, final Synchronization onCompletion) {
        Callable<Exchange> task = new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                Exchange answer = DefaultProducerTemplate.this.producerCache.send(endpoint, processor);
                if (answer.isFailed()) {
                    onCompletion.onFailure(answer);
                } else {
                    onCompletion.onComplete(answer);
                }
                return answer;
            }
        };
        return this.executor.submit(task);
    }

    @Override
    public void start() throws Exception {
        super.start();
        ServiceHelper.startService(this.producerCache);
        if (this.executor == null || this.executor.isShutdown()) {
            this.executor = ExecutorServiceHelper.newScheduledThreadPool(10, "ProducerTemplate", true);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        ServiceHelper.stopService(this.producerCache);
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }
}

