/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.lang.reflect.Method;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntity;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntityAccessor;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntityClassLoader;
import org.eclipse.persistence.internal.dynamicpersist.BaseEntityVHAccessor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;

public class ProjectHelper {
    public static void fixOROXAccessors(Project orProject, Project oxProject) {
        BaseEntityClassLoader becl;
        ConversionManager conversionManager;
        Platform platform;
        for (ClassDescriptor desc : orProject.getDescriptors().values()) {
            if (!BaseEntity.class.isAssignableFrom(desc.getJavaClass())) continue;
            ClassDescriptor xdesc = oxProject.getDescriptorForAlias(desc.getAlias());
            int idx = 0;
            for (DatabaseMapping dm : desc.getMappings()) {
                String attributeName = dm.getAttributeName();
                DatabaseMapping xdm = xdesc.getMappingForAttributeName(attributeName);
                dm.setAttributeAccessor(new BaseEntityAccessor(attributeName, idx));
                if (xdm != null) {
                    if (dm.isForeignReferenceMapping()) {
                        ForeignReferenceMapping frm = (ForeignReferenceMapping)dm;
                        if (frm.usesIndirection() && frm.getIndirectionPolicy().getClass().isAssignableFrom(BasicIndirectionPolicy.class)) {
                            xdm.setAttributeAccessor(new BaseEntityVHAccessor(attributeName, idx));
                        } else {
                            xdm.setAttributeAccessor(new BaseEntityAccessor(attributeName, idx));
                        }
                    } else {
                        Class<?> clz;
                        XMLField xmlField;
                        xdm.setAttributeAccessor(new BaseEntityAccessor(attributeName, idx));
                        if (xdm.isDirectToFieldMapping()) {
                            XMLDirectMapping xmlDM = (XMLDirectMapping)xdm;
                            xmlField = (XMLField)xmlDM.getField();
                            clz = Util.SCHEMA_2_CLASS.get(xmlField.getSchemaType());
                            if (clz != null) {
                                xmlField.setType(clz);
                            } else {
                                xmlField.setType(ClassConstants.OBJECT);
                            }
                        } else if (xdm.isAbstractCompositeDirectCollectionMapping()) {
                            AbstractCompositeDirectCollectionMapping acdcm = (AbstractCompositeDirectCollectionMapping)xdm;
                            xmlField = (XMLField)acdcm.getField();
                            clz = Util.SCHEMA_2_CLASS.get(xmlField.getSchemaType());
                            if (clz != null) {
                                xmlField.setType(clz);
                            } else {
                                xmlField.setType(ClassConstants.OBJECT);
                            }
                        }
                    }
                }
                ++idx;
            }
            try {
                Class clz = desc.getJavaClass();
                Method setNumAttrs = clz.getMethod("setNumAttributes", Integer.class);
                setNumAttrs.invoke((Object)clz, new Integer(idx));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ClassLoader cl = null;
        Login login = orProject.getDatasourceLogin();
        if (login != null && (platform = login.getDatasourcePlatform()) != null && (conversionManager = platform.getConversionManager()) != null) {
            cl = conversionManager.getLoader();
        }
        if (cl != null && cl instanceof BaseEntityClassLoader) {
            becl = (BaseEntityClassLoader)cl;
            becl.dontGenerateSubclasses();
        }
        cl = null;
        login = oxProject.getDatasourceLogin();
        if (login != null && (platform = login.getDatasourcePlatform()) != null && (conversionManager = platform.getConversionManager()) != null) {
            cl = conversionManager.getLoader();
        }
        if (cl != null && cl instanceof BaseEntityClassLoader) {
            becl = (BaseEntityClassLoader)cl;
            becl.dontGenerateSubclasses();
        }
    }
}

