/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.history.HistoryPolicy;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLInsertStatement;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DirectCollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectCollectionMapping
extends CollectionMapping
implements RelationalMapping,
MapComponentMapping {
    protected static final String Delete = "delete";
    protected static final String Insert = "insert";
    protected static final String DeleteAll = "deleteAll";
    protected Converter valueConverter;
    protected String valueConverterClassName;
    protected transient DatabaseTable referenceTable;
    protected transient DatabaseField directField;
    protected transient Vector<DatabaseField> sourceKeyFields;
    protected transient Vector<DatabaseField> referenceKeyFields;
    protected transient DataModifyQuery insertQuery = new DataModifyQuery();
    protected transient ModifyQuery changeSetDeleteQuery;
    protected transient boolean hasCustomDeleteQuery;
    protected transient boolean hasCustomInsertQuery;
    protected HistoryPolicy historyPolicy;

    public DirectCollectionMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.referenceKeyFields = NonSynchronizedVector.newInstance(1);
        this.selectionQuery = new DirectReadQuery();
        this.hasCustomInsertQuery = false;
        this.isPrivateOwned = true;
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public Converter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(Converter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public void setValueConverterClassName(String valueConverterClassName) {
        this.valueConverterClassName = valueConverterClassName;
    }

    public void addReferenceKeyField(DatabaseField referenceForeignKeyField, DatabaseField sourcePrimaryKeyField) {
        this.getSourceKeyFields().addElement(sourcePrimaryKeyField);
        this.getReferenceKeyFields().addElement(referenceForeignKeyField);
    }

    public void addReferenceKeyFieldName(String referenceForeignKeyFieldName, String sourcePrimaryKeyFieldName) {
        this.addReferenceKeyField(new DatabaseField(referenceForeignKeyFieldName), new DatabaseField(sourcePrimaryKeyFieldName));
    }

    @Override
    public ReadQuery prepareNestedBatchQuery(ReadAllQuery query) {
        ExpressionBuilder builder;
        DataReadQuery batchQuery = new DataReadQuery();
        Expression originalSelectionCriteria = null;
        IdentityHashMap clonedExpressions = new IdentityHashMap();
        if (query.getSelectionCriteria() == null) {
            builder = new ExpressionBuilder();
            if (query.hasAsOfClause()) {
                builder.asOf(query.getAsOfClause());
            }
        } else {
            originalSelectionCriteria = query.getSelectionCriteria().copiedVersionFrom(clonedExpressions);
            builder = originalSelectionCriteria.getBuilder();
        }
        Expression twisted = builder.twist(this.getSelectionQuery().getSQLStatement().getWhereClause(), builder);
        if (originalSelectionCriteria != null) {
            twisted = twisted.and(originalSelectionCriteria);
        }
        if (query.getDescriptor().getQueryManager().getAdditionalJoinExpression() != null) {
            twisted = twisted.and(query.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(builder));
        }
        if (this.getHistoryPolicy() != null) {
            if (query.getSession().getAsOfClause() != null) {
                builder.asOf(query.getSession().getAsOfClause());
            } else if (builder.getAsOfClause() == null) {
                builder.asOf(AsOfClause.NO_CLAUSE);
            }
            twisted = twisted.and(this.getHistoryPolicy().additionalHistoryExpression(builder));
        }
        SQLSelectStatement batchStatement = new SQLSelectStatement();
        Enumeration<DatabaseField> enumtr = this.getReferenceKeyFields().elements();
        while (enumtr.hasMoreElements()) {
            batchStatement.addField(builder.getTable(this.getReferenceTable()).getField(enumtr.nextElement()));
        }
        if (this instanceof DirectMapMapping) {
            batchStatement.addField(builder.getTable(this.getReferenceTable()).getField(((DirectMapMapping)this).getDirectKeyField()));
        }
        batchStatement.addField(builder.getTable(this.getReferenceTable()).getField(this.getDirectField()));
        batchStatement.setWhereClause(twisted);
        batchStatement.normalize(query.getSession(), this.getDescriptor(), clonedExpressions);
        batchQuery.setSQLStatement(batchStatement);
        return batchQuery;
    }

    @Override
    public ObjectLevelReadQuery prepareNestedJoins(JoinedAttributeManager joinManager, ObjectBuildingQuery baseQuery, AbstractSession session) {
        return null;
    }

    @Override
    protected Object valueFromRowInternalWithJoin(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        ContainerPolicy policy = this.getContainerPolicy();
        Object value = policy.containerInstance();
        ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
        Vector sourceKey = objectBuilder.extractPrimaryKeyFromRow(row, executionSession);
        CacheKey sourceCacheKey = new CacheKey(sourceKey);
        List rows = joinManager.getDataResultsByPrimaryKey().get(sourceCacheKey);
        HashSet<Object> directValues = new HashSet<Object>();
        Converter valueConverter = this.getValueConverter();
        for (int index = 0; index < rows.size(); ++index) {
            AbstractRecord sourceRow;
            AbstractRecord targetRow = sourceRow = (AbstractRecord)rows.get(index);
            Object directValue = (targetRow = this.trimRowForJoin(targetRow, joinManager, executionSession)).get(this.getDirectField());
            if (directValue == null) {
                return this.getIndirectionPolicy().valueFromRow(value);
            }
            if (directValues.contains(directValue)) continue;
            directValues.add(directValue);
            if (valueConverter != null) {
                directValue = valueConverter.convertDataValueToObjectValue(directValue, executionSession);
            }
            policy.addInto(directValue, value, executionSession);
        }
        return this.getIndirectionPolicy().valueFromRow(value);
    }

    @Override
    public void buildCopy(Object copy, Object original, ObjectCopyingPolicy policy) {
        Object attributeValue = this.getRealCollectionAttributeValueFromObject(original, policy.getSession());
        attributeValue = this.getContainerPolicy().cloneFor(attributeValue);
        this.setRealAttributeValueInObject(copy, attributeValue);
    }

    @Override
    protected Object buildElementClone(Object element, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        Object cloneValue = element;
        if (this.getValueConverter() != null && this.getValueConverter().isMutable()) {
            cloneValue = this.getValueConverter().convertDataValueToObjectValue(this.getValueConverter().convertObjectValueToDataValue(cloneValue, unitOfWork), unitOfWork);
        }
        return cloneValue;
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadePerformRemovePrivateOwnedObjectFromChangeSetIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow) {
    }

    @Override
    public Object clone() {
        DirectCollectionMapping clone = (DirectCollectionMapping)super.clone();
        clone.setSourceKeyFields(this.cloneFields(this.getSourceKeyFields()));
        clone.setReferenceKeyFields(this.cloneFields(this.getReferenceKeyFields()));
        return clone;
    }

    @Override
    public void compareCollectionsForChange(Object oldCollection, Object newCollection, ChangeRecord changeRecord, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        int numberOfNewNulls = 0;
        HashMap<Object, Integer> originalKeyValues = new HashMap<Object, Integer>(10);
        HashMap<Object, Integer> cloneKeyValues = new HashMap<Object, Integer>(10);
        if (oldCollection != null) {
            Object backUpIter = cp.iteratorFor(oldCollection);
            while (cp.hasNext(backUpIter)) {
                Object secondObject = cp.next(backUpIter, session);
                if (secondObject == null) {
                    --numberOfNewNulls;
                    continue;
                }
                Integer count = (Integer)originalKeyValues.get(secondObject);
                if (count == null) {
                    originalKeyValues.put(secondObject, new Integer(1));
                    continue;
                }
                originalKeyValues.put(secondObject, new Integer(count + 1));
            }
        }
        HashMap databaseCount = (HashMap)originalKeyValues.clone();
        int databaseNullCount = Math.abs(numberOfNewNulls);
        if (newCollection != null) {
            Object cloneIter = cp.iteratorFor(newCollection);
            while (cp.hasNext(cloneIter)) {
                Object firstObject = cp.next(cloneIter, session);
                if (firstObject == null) {
                    ++numberOfNewNulls;
                    continue;
                }
                Integer count = (Integer)originalKeyValues.get(firstObject);
                if (count == null) {
                    Integer cloneCount = (Integer)cloneKeyValues.get(firstObject);
                    if (cloneCount == null) {
                        cloneKeyValues.put(firstObject, new Integer(1));
                        continue;
                    }
                    cloneKeyValues.put(firstObject, new Integer(cloneCount + 1));
                    continue;
                }
                if (count == 1) {
                    originalKeyValues.remove(firstObject);
                    continue;
                }
                originalKeyValues.put(firstObject, new Integer(count - 1));
            }
        }
        if (cloneKeyValues.isEmpty() && originalKeyValues.isEmpty() && numberOfNewNulls == 0 && !changeRecord.getOwner().isNew()) {
            return;
        }
        ((DirectCollectionChangeRecord)changeRecord).addAdditionChange(cloneKeyValues, databaseCount);
        ((DirectCollectionChangeRecord)changeRecord).addRemoveChange(originalKeyValues, databaseCount);
        if (numberOfNewNulls != 0) {
            ((DirectCollectionChangeRecord)changeRecord).getCommitAddMap().put(DirectCollectionChangeRecord.Null, new Integer(databaseNullCount));
            if (numberOfNewNulls > 0) {
                ((DirectCollectionChangeRecord)changeRecord).addAdditionChange(DirectCollectionChangeRecord.Null, new Integer(numberOfNewNulls));
            } else {
                ((DirectCollectionChangeRecord)changeRecord).addRemoveChange(DirectCollectionChangeRecord.Null, new Integer(numberOfNewNulls *= -1));
            }
        }
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = this.getAttributeValueFromObject(clone);
        Object backUpAttribute = null;
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        Object cloneObjectCollection = this.getRealCollectionAttributeValueFromObject(clone, session);
        Object backUpCollection = null;
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backUp);
            if (backUpAttribute == null && cloneAttribute == null) {
                return null;
            }
            backUpCollection = this.getRealCollectionAttributeValueFromObject(backUp, session);
        }
        DirectCollectionChangeRecord changeRecord = new DirectCollectionChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        this.compareCollectionsForChange(backUpCollection, cloneObjectCollection, changeRecord, session);
        if (changeRecord.hasChanges()) {
            return changeRecord;
        }
        return null;
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        int count;
        Object object;
        Object firstCollection = this.getRealCollectionAttributeValueFromObject(firstObject, session);
        Object secondCollection = this.getRealCollectionAttributeValueFromObject(secondObject, session);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.sizeFor(firstCollection) != containerPolicy.sizeFor(secondCollection)) {
            return false;
        }
        HashMap<Object, Integer> firstCounter = new HashMap<Object, Integer>();
        HashMap<Object, Integer> secondCounter = new HashMap<Object, Integer>();
        Object iter = containerPolicy.iteratorFor(firstCollection);
        while (containerPolicy.hasNext(iter)) {
            object = containerPolicy.next(iter, session);
            if (firstCounter.containsKey(object)) {
                count = (Integer)firstCounter.get(object);
                firstCounter.put(object, new Integer(++count));
                continue;
            }
            firstCounter.put(object, new Integer(1));
        }
        iter = containerPolicy.iteratorFor(secondCollection);
        while (containerPolicy.hasNext(iter)) {
            object = containerPolicy.next(iter, session);
            if (secondCounter.containsKey(object)) {
                count = (Integer)secondCounter.get(object);
                secondCounter.put(object, new Integer(++count));
                continue;
            }
            secondCounter.put(object, new Integer(1));
        }
        Iterator iterator = firstCounter.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!secondCounter.containsKey(object) || ((Integer)secondCounter.get(object)).intValue() != ((Integer)firstCounter.get(object)).intValue()) {
                return false;
            }
            iterator.remove();
            secondCounter.remove(object);
        }
        return firstCounter.isEmpty() && secondCounter.isEmpty();
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.valueConverter != null) {
            if (this.valueConverter instanceof TypeConversionConverter) {
                ((TypeConversionConverter)this.valueConverter).convertClassNamesToClasses(classLoader);
            } else if (this.valueConverter instanceof ObjectTypeConverter) {
                ((ObjectTypeConverter)this.valueConverter).convertClassNamesToClasses(classLoader);
            }
        }
        if (this.valueConverterClassName != null) {
            Converter valueConverter;
            block13: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        Class valueConverterClass;
                        try {
                            valueConverterClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.valueConverterClassName, true, classLoader));
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.valueConverterClassName, exception.getException());
                        }
                        try {
                            valueConverter = (Converter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(valueConverterClass));
                            break block13;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.valueConverterClassName, exception.getException());
                        }
                    }
                    Class valueConverterClass = PrivilegedAccessHelper.getClassForName(this.valueConverterClassName, true, classLoader);
                    valueConverter = (Converter)PrivilegedAccessHelper.newInstanceFromClass(valueConverterClass);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.valueConverterClassName, exc);
                }
                catch (Exception e) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.valueConverterClassName, e);
                }
            }
            this.setValueConverter(valueConverter);
        }
    }

    protected Vector extractKeyFromReferenceRow(AbstractRecord row, AbstractSession session) {
        Vector<Object> key = new Vector<Object>(this.getReferenceKeyFields().size());
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField relationField = this.getReferenceKeyFields().elementAt(index);
            DatabaseField sourceField = this.getSourceKeyFields().elementAt(index);
            Object value = row.get(relationField);
            try {
                value = session.getDatasourcePlatform().getConversionManager().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(sourceField));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    protected Vector extractPrimaryKeyFromRow(AbstractRecord row, AbstractSession session) {
        Vector<Object> key = new Vector<Object>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldEnum = this.getSourceKeyFields().elements();
        while (fieldEnum.hasMoreElements()) {
            DatabaseField field = fieldEnum.nextElement();
            Object value = row.get(field);
            try {
                value = session.getDatasourcePlatform().getConversionManager().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(field));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object extractResultFromBatchQuery(DatabaseQuery query, AbstractRecord databaseRow, AbstractSession session, AbstractRecord argumentRow) {
        Hashtable referenceDataByKey = null;
        ContainerPolicy mappingContainerPolicy = this.getContainerPolicy();
        DatabaseQuery databaseQuery = query;
        synchronized (databaseQuery) {
            referenceDataByKey = this.getBatchReadObjects(query, session);
            mappingContainerPolicy = this.getContainerPolicy();
            if (referenceDataByKey == null) {
                Vector rows = (Vector)session.executeQuery(query, argumentRow);
                referenceDataByKey = new Hashtable();
                Enumeration rowsEnum = rows.elements();
                while (rowsEnum.hasMoreElements()) {
                    AbstractRecord referenceRow = (AbstractRecord)rowsEnum.nextElement();
                    Object referenceValue = referenceRow.get(this.getDirectField());
                    CacheKey eachReferenceKey = new CacheKey(this.extractKeyFromReferenceRow(referenceRow, session));
                    Object container = referenceDataByKey.get(eachReferenceKey);
                    if (container == null) {
                        container = mappingContainerPolicy.containerInstance();
                        referenceDataByKey.put(eachReferenceKey, container);
                    }
                    if (this.getValueConverter() != null) {
                        referenceValue = this.getValueConverter().convertDataValueToObjectValue(referenceValue, query.getSession());
                    }
                    mappingContainerPolicy.addInto(referenceValue, container, query.getSession());
                }
                this.setBatchReadObjects(referenceDataByKey, query, session);
                query.setSession(null);
            }
        }
        Object result = referenceDataByKey.get(new CacheKey(this.extractPrimaryKeyFromRow(databaseRow, session)));
        if (result == null) {
            return mappingContainerPolicy.containerInstance();
        }
        return result;
    }

    @Override
    public void fixRealObjectReferences(Object object, Map objectInformation, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
    }

    protected ModifyQuery getDeleteQuery() {
        if (this.changeSetDeleteQuery == null) {
            this.changeSetDeleteQuery = new DataModifyQuery();
        }
        return this.changeSetDeleteQuery;
    }

    @Override
    public Vector getSelectFields() {
        NonSynchronizedVector fields = new NonSynchronizedVector(2);
        ((Vector)fields).add(this.getDirectField());
        return fields;
    }

    @Override
    public Vector getSelectTables() {
        NonSynchronizedVector tables = new NonSynchronizedVector(0);
        ((Vector)tables).add(this.getReferenceTable());
        return tables;
    }

    public DatabaseField getDirectField() {
        return this.directField;
    }

    public String getDirectFieldName() {
        if (this.getDirectField() == null) {
            return null;
        }
        return this.getDirectField().getQualifiedName();
    }

    protected DataModifyQuery getInsertQuery() {
        return this.insertQuery;
    }

    @Override
    public Expression getJoinCriteria(QueryKeyExpression exp) {
        if (this.getHistoryPolicy() != null) {
            Expression result = super.getJoinCriteria(exp);
            Expression historyCriteria = this.getHistoryPolicy().additionalHistoryExpression(exp);
            if (result != null) {
                return result.and(historyCriteria);
            }
            if (historyCriteria != null) {
                return historyCriteria;
            }
            return null;
        }
        return super.getJoinCriteria(exp);
    }

    @Override
    public Object getObjectCorrespondingTo(Object object, RemoteSession session, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query) {
        return object;
    }

    public HistoryPolicy getHistoryPolicy() {
        return this.historyPolicy;
    }

    @Override
    public Class getReferenceClass() {
        return null;
    }

    @Override
    public String getReferenceClassName() {
        return null;
    }

    @Override
    public ClassDescriptor getReferenceDescriptor() {
        return null;
    }

    public Vector getReferenceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getReferenceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getReferenceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getReferenceKeyFields() {
        return this.referenceKeyFields;
    }

    public DatabaseTable getReferenceTable() {
        return this.referenceTable;
    }

    public String getReferenceTableName() {
        if (this.getReferenceTable() == null) {
            return null;
        }
        return this.getReferenceTable().getName();
    }

    public String getReferenceTableQualifiedName() {
        if (this.getReferenceTable() == null) {
            return null;
        }
        return this.getReferenceTable().getQualifiedName();
    }

    @Override
    public DatabaseMapping getRelationshipPartner() {
        return null;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    protected boolean hasCustomDeleteQuery() {
        return this.hasCustomDeleteQuery;
    }

    protected boolean hasCustomInsertQuery() {
        return this.hasCustomInsertQuery;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.isKeyForSourceSpecified()) {
            this.initializeSourceKeys(session);
        } else {
            this.initializeSourceKeysWithDefaults(session);
        }
        this.initializeReferenceTable(session);
        this.initializeReferenceKeys(session);
        this.initializeDirectField(session);
        if (this.getReferenceTable().getName().indexOf(32) != -1) {
            String quoteChar = ((DatasourcePlatform)session.getDatasourcePlatform()).getIdentifierQuoteCharacter();
            if (this.getReferenceTable().getName().indexOf(quoteChar) == -1) {
                this.getReferenceTable().setName(quoteChar + this.getReferenceTable().getName() + quoteChar);
            }
        }
        if (this.shouldInitializeSelectionCriteria()) {
            this.initializeSelectionCriteria(session);
            this.initializeSelectionStatement(session);
        }
        if (!this.getSelectionQuery().hasSessionName()) {
            this.getSelectionQuery().setSessionName(session.getName());
        }
        if (this.getValueConverter() != null && this.getSelectionQuery() instanceof DirectReadQuery) {
            ((DirectReadQuery)this.getSelectionQuery()).setValueConverter(this.getValueConverter());
        }
        this.initializeDeleteAllQuery(session);
        this.initializeDeleteQuery(session);
        this.initializeInsertQuery(session);
        if (this.getHistoryPolicy() != null) {
            this.getHistoryPolicy().initialize(session);
        }
        if (this.getValueConverter() != null) {
            this.getValueConverter().initialize(this, session);
        }
        super.initialize(session);
    }

    protected void initializeDeleteAllQuery(AbstractSession session) {
        if (!this.getDeleteAllQuery().hasSessionName()) {
            this.getDeleteAllQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteAllQuery()) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        SQLDeleteStatement statement = new SQLDeleteStatement();
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().elementAt(index);
            DatabaseField sourceKey = this.getSourceKeyFields().elementAt(index);
            Expression subExp1 = ((Expression)builder).getField(referenceKey);
            Expression subExp2 = builder.getParameter(sourceKey);
            Expression subExpression = subExp1.equal(subExp2);
            expression = expression == null ? subExpression : expression.and(subExpression);
        }
        statement.setWhereClause(expression);
        statement.setTable(this.getReferenceTable());
        this.getDeleteAllQuery().setSQLStatement(statement);
    }

    protected void initializeDeleteQuery(AbstractSession session) {
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression directExp = ((Expression)builder).getField(this.getDirectField()).equal(builder.getParameter(this.getDirectField()));
        Expression expression = null;
        SQLDeleteStatement statement = new SQLDeleteStatement();
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Expression subExp1 = ((Expression)builder).getField(referenceKey);
            Expression subExp2 = builder.getParameter(sourceKey);
            Expression subExpression = subExp1.equal(subExp2);
            expression = subExpression.and(expression);
        }
        expression = expression.and(directExp);
        statement.setWhereClause(expression);
        statement.setTable(this.getReferenceTable());
        this.getDeleteQuery().setSQLStatement(statement);
    }

    protected void initializeDirectField(AbstractSession session) throws DescriptorException {
        if (this.getDirectField() == null) {
            throw DescriptorException.directFieldNameNotSet(this);
        }
        this.getDirectField().setTable(this.getReferenceTable());
        this.getDirectField().setIndex(0);
    }

    protected void initializeInsertQuery(AbstractSession session) {
        if (!this.getInsertQuery().hasSessionName()) {
            this.getInsertQuery().setSessionName(session.getName());
        }
        if (this.hasCustomInsertQuery()) {
            return;
        }
        SQLInsertStatement statement = new SQLInsertStatement();
        statement.setTable(this.getReferenceTable());
        DatabaseRecord directRow = new DatabaseRecord();
        Enumeration<DatabaseField> referenceEnum = this.getReferenceKeyFields().elements();
        while (referenceEnum.hasMoreElements()) {
            directRow.put(referenceEnum.nextElement(), (Object)null);
        }
        directRow.put(this.getDirectField(), (Object)null);
        statement.setModifyRow(directRow);
        this.getInsertQuery().setSQLStatement(statement);
        this.getInsertQuery().setModifyRow(directRow);
    }

    @Override
    protected void initializeReferenceDescriptor(AbstractSession session) {
    }

    protected void initializeReferenceKeys(AbstractSession session) throws DescriptorException {
        if (this.getReferenceKeyFields().size() == 0) {
            throw DescriptorException.noReferenceKeyIsSpecified(this);
        }
        Enumeration<DatabaseField> referenceEnum = this.getReferenceKeyFields().elements();
        while (referenceEnum.hasMoreElements()) {
            DatabaseField field = referenceEnum.nextElement();
            if (field.hasTableName() && !field.getTableName().equals(this.getReferenceTable().getName())) {
                throw DescriptorException.referenceKeyFieldNotProperlySpecified(field, this);
            }
            field.setTable(this.getReferenceTable());
        }
    }

    protected void initializeReferenceTable(AbstractSession session) throws DescriptorException {
        Platform platform = session.getDatasourcePlatform();
        if (this.getReferenceTable() == null) {
            throw DescriptorException.referenceTableNotSpecified(this);
        }
        if (platform.getTableQualifier().length() > 0 && this.getReferenceTable().getTableQualifier().length() == 0) {
            this.getReferenceTable().setTableQualifier(platform.getTableQualifier());
        }
    }

    protected void initializeSelectionCriteria(AbstractSession session) {
        Expression criteria = null;
        ExpressionBuilder base = new ExpressionBuilder();
        TableExpression table = (TableExpression)base.getTable(this.getReferenceTable());
        Enumeration<DatabaseField> referenceKeysEnum = this.getReferenceKeyFields().elements();
        Enumeration<DatabaseField> sourceKeysEnum = this.getSourceKeyFields().elements();
        while (referenceKeysEnum.hasMoreElements()) {
            DatabaseField referenceKey = referenceKeysEnum.nextElement();
            DatabaseField sourceKey = sourceKeysEnum.nextElement();
            Expression exp1 = table.getField(referenceKey);
            Expression exp2 = base.getParameter(sourceKey);
            Expression expression = exp1.equal(exp2);
            if (criteria == null) {
                criteria = expression;
                continue;
            }
            criteria = expression.and(criteria);
        }
        this.setSelectionCriteria(criteria);
    }

    @Override
    protected void initializeSelectionQuery(AbstractSession session) {
    }

    protected void initializeSelectionStatement(AbstractSession session) {
        SQLSelectStatement statement = new SQLSelectStatement();
        statement.addTable(this.getReferenceTable());
        statement.addField((DatabaseField)this.getDirectField().clone());
        statement.setWhereClause(this.getSelectionCriteria());
        statement.normalize(session, null);
        this.getSelectionQuery().setSQLStatement(statement);
    }

    protected void initializeSourceKeys(AbstractSession session) {
        for (int index = 0; index < this.getSourceKeyFields().size(); ++index) {
            DatabaseField field = this.getDescriptor().buildField(this.getSourceKeyFields().get(index));
            this.getSourceKeyFields().set(index, field);
        }
    }

    protected void initializeSourceKeysWithDefaults(AbstractSession session) {
        List<DatabaseField> primaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            this.getSourceKeyFields().addElement(primaryKeyFields.get(index));
        }
    }

    @Override
    public boolean isDirectCollectionMapping() {
        return true;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    protected boolean isKeyForSourceSpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    @Override
    public boolean isPrivateOwned() {
        return true;
    }

    @Override
    public void iterateOnRealAttributeValue(DescriptorIterator iterator, Object realAttributeValue) {
        if (iterator.shouldIterateOnPrimitives()) {
            super.iterateOnRealAttributeValue(iterator, realAttributeValue);
        }
    }

    @Override
    public void iterateOnElement(DescriptorIterator iterator, Object element) {
        iterator.iteratePrimitiveForMapping(element, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object valueOfTarget = null;
        AbstractSession session = mergeManager.getSession();
        HashMap addObjects = ((DirectCollectionChangeRecord)changeRecord).getAddObjectMap();
        HashMap removeObjects = ((DirectCollectionChangeRecord)changeRecord).getRemoveObjectMap();
        valueOfTarget = this.isAttributeValueInstantiated(target) && !changeRecord.getOwner().isNew() ? this.getRealCollectionAttributeValueFromObject(target, session) : containerPolicy.containerInstance(addObjects.size());
        if (!this.isAttributeValueInstantiated(target)) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            Object iterator = containerPolicy.iteratorFor(this.getRealCollectionAttributeValueFromObject(source, session));
            while (containerPolicy.hasNext(iterator)) {
                containerPolicy.addInto(containerPolicy.next(iterator, session), valueOfTarget, session);
            }
        } else {
            Object synchronizationTarget = valueOfTarget;
            if (valueOfTarget instanceof IndirectCollection) {
                synchronizationTarget = ((IndirectCollection)valueOfTarget).getDelegateObject();
            }
            Object object = synchronizationTarget;
            synchronized (object) {
                int i;
                int objectCount;
                for (Object object2 : addObjects.keySet()) {
                    objectCount = (Integer)addObjects.get(object2);
                    for (i = 0; i < objectCount; ++i) {
                        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                            if (containerPolicy.contains(object2, valueOfTarget, session)) continue;
                            containerPolicy.addInto(object2, valueOfTarget, session);
                            continue;
                        }
                        containerPolicy.addInto(object2, valueOfTarget, session);
                    }
                }
                for (Object object2 : removeObjects.keySet()) {
                    objectCount = (Integer)removeObjects.get(object2);
                    for (i = 0; i < objectCount; ++i) {
                        containerPolicy.removeFrom(object2, valueOfTarget, session);
                    }
                }
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        DirectCollectionChangeRecord changeRecord;
        ObjectChangeSet changeSet;
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(target, source, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(target) : !this.isAttributeValueInstantiatedOrChanged(source)) {
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object valueOfSource = this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
        Object valueOfTarget = this.getRealCollectionAttributeValueFromObject(target, mergeManager.getSession());
        Object newContainer = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource));
        boolean fireChangeEvents = false;
        if (this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy() && target instanceof ChangeTracker && ((ChangeTracker)target)._persistence_getPropertyChangeListener() != null) {
            fireChangeEvents = true;
            Object iterator = containerPolicy.iteratorFor(valueOfTarget);
            while (containerPolicy.hasNext(iterator)) {
                ((ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).internalPropertyChange(new CollectionChangeEvent(target, this.getAttributeName(), valueOfTarget, containerPolicy.next(iterator, mergeManager.getSession()), CollectionChangeEvent.REMOVE));
            }
            if (newContainer instanceof ChangeTracker) {
                ((ChangeTracker)newContainer)._persistence_setPropertyChangeListener(((ChangeTracker)target)._persistence_getPropertyChangeListener());
            }
            if (valueOfTarget instanceof ChangeTracker) {
                ((ChangeTracker)valueOfTarget)._persistence_setPropertyChangeListener(null);
            }
        }
        valueOfTarget = newContainer;
        Object sourceValuesIterator = containerPolicy.iteratorFor(valueOfSource);
        while (containerPolicy.hasNext(sourceValuesIterator)) {
            Object sourceValue = containerPolicy.next(sourceValuesIterator, mergeManager.getSession());
            if (fireChangeEvents) {
                ((ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).internalPropertyChange(new CollectionChangeEvent(target, this.getAttributeName(), valueOfTarget, sourceValue, CollectionChangeEvent.ADD));
            }
            containerPolicy.addInto(sourceValue, valueOfTarget, mergeManager.getSession());
        }
        if (fireChangeEvents && this.descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy() && (changeSet = ((AttributeChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).getObjectChangeSet()) != null && (changeRecord = (DirectCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName())) != null) {
            if (!changeRecord.isDeferred()) {
                if (!changeRecord.hasChanges()) {
                    changeSet.removeChange(this.getAttributeName());
                }
            } else {
                changeRecord.setLatestCollection(valueOfTarget);
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    @Override
    public void performDataModificationEvent(Object[] event, AbstractSession session) throws DatabaseException, DescriptorException {
        if (event[0] == Delete) {
            session.executeQuery((DatabaseQuery)((DataModifyQuery)event[1]), (AbstractRecord)event[2]);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalDelete((DataModifyQuery)event[1], (AbstractRecord)event[2], session);
            }
        } else if (event[0] == Insert) {
            session.executeQuery((DatabaseQuery)((DataModifyQuery)event[1]), (AbstractRecord)event[2]);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalInsert((DataModifyQuery)event[1], (AbstractRecord)event[2], session);
            }
        } else if (event[0] == DeleteAll) {
            this.preDelete((DeleteObjectQuery)event[1]);
        } else {
            throw DescriptorException.invalidDataModificationEventCode(event[0], this);
        }
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException {
        DatabaseRecord databaseRow = new DatabaseRecord();
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy.isEmpty(objects)) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getSession());
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            databaseRow.put(referenceKey, sourceKeyValue);
        }
        Object iter = containerPolicy.iteratorFor(objects);
        while (containerPolicy.hasNext(iter)) {
            Object object = containerPolicy.next(iter, query.getSession());
            if (this.getValueConverter() != null) {
                object = this.getValueConverter().convertObjectValueToDataValue(object, query.getSession());
            }
            databaseRow.put(this.getDirectField(), object);
            if (query.shouldCascadeOnlyDependentParts()) {
                Object[] event = new Object[]{Insert, this.getInsertQuery(), databaseRow.clone()};
                query.getSession().getCommitManager().addDataModificationEvent(this, event);
                continue;
            }
            query.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRow);
            if (this.getHistoryPolicy() == null || !this.getHistoryPolicy().shouldHandleWrites()) continue;
            this.getHistoryPolicy().mappingLogicalInsert(this.getInsertQuery(), databaseRow, query.getSession());
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery writeQuery) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        if (writeQuery.getObjectChangeSet() != null) {
            this.postUpdateWithChangeSet(writeQuery);
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeQuery.getObject())) {
            return;
        }
        if (writeQuery.getSession().isUnitOfWork() && this.compareObjects(writeQuery.getObject(), writeQuery.getBackupClone(), writeQuery.getSession())) {
            return;
        }
        DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
        deleteQuery.setObject(writeQuery.getObject());
        deleteQuery.setSession(writeQuery.getSession());
        deleteQuery.setTranslationRow(writeQuery.getTranslationRow());
        if (writeQuery.shouldCascadeOnlyDependentParts()) {
            Object[] event = new Object[3];
            event[0] = DeleteAll;
            event[1] = deleteQuery;
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
        } else {
            this.preDelete(deleteQuery);
        }
        this.postInsert(writeQuery);
    }

    protected void postUpdateWithChangeSet(WriteObjectQuery writeQuery) throws DatabaseException {
        ObjectChangeSet changeSet = writeQuery.getObjectChangeSet();
        DirectCollectionChangeRecord changeRecord = (DirectCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            return;
        }
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Object sourceKeyValue = writeQuery.getTranslationRow().get(sourceKey);
            writeQuery.getTranslationRow().put(referenceKey, sourceKeyValue);
        }
        for (Object object : changeRecord.getRemoveObjectMap().keySet()) {
            AbstractRecord thisRow = (AbstractRecord)writeQuery.getTranslationRow().clone();
            Object value = object;
            if (this.getValueConverter() != null) {
                value = this.getValueConverter().convertObjectValueToDataValue(value, writeQuery.getSession());
            }
            if (value == DirectCollectionChangeRecord.Null) {
                thisRow.add(this.getDirectField(), null);
            } else {
                thisRow.add(this.getDirectField(), value);
            }
            Object[] event = new Object[]{Delete, this.getDeleteQuery(), thisRow};
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
            Integer count = (Integer)changeRecord.getCommitAddMap().get(object);
            if (count == null) continue;
            for (int counter = count.intValue(); counter > 0; --counter) {
                thisRow = (AbstractRecord)writeQuery.getTranslationRow().clone();
                thisRow.add(this.getDirectField(), value);
                event = new Object[]{Insert, this.getInsertQuery(), thisRow};
                writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
            }
        }
        for (Object object : changeRecord.getAddObjectMap().keySet()) {
            Integer count = (Integer)changeRecord.getAddObjectMap().get(object);
            for (int counter = count.intValue(); counter > 0; --counter) {
                AbstractRecord thisRow = (AbstractRecord)writeQuery.getTranslationRow().clone();
                Object value = object;
                if (this.getValueConverter() != null) {
                    value = this.getValueConverter().convertObjectValueToDataValue(value, writeQuery.getSession());
                }
                if (value == DirectCollectionChangeRecord.Null) {
                    thisRow.add(this.getDirectField(), null);
                } else {
                    thisRow.add(this.getDirectField(), value);
                }
                Object[] event = new Object[]{Insert, this.getInsertQuery(), thisRow};
                writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
            }
        }
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException {
        if (this.isReadOnly()) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getSession());
        query.getSession().executeQuery((DatabaseQuery)this.getDeleteAllQuery(), query.getTranslationRow());
        if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
            this.getHistoryPolicy().mappingLogicalDelete(this.getDeleteAllQuery(), query.getTranslationRow(), query.getSession());
        }
    }

    @Override
    protected void prepareTranslationRow(AbstractRecord translationRow, Object object, AbstractSession session) {
        Enumeration<DatabaseField> sourceFieldsEnum = this.getSourceKeyFields().elements();
        while (sourceFieldsEnum.hasMoreElements()) {
            DatabaseField sourceKey = sourceFieldsEnum.nextElement();
            if (translationRow.containsKey(sourceKey)) continue;
            Object value = this.getDescriptor().getObjectBuilder().extractValueFromObjectForField(object, sourceKey, session);
            translationRow.put(sourceKey, value);
        }
    }

    @Override
    public void remoteInitialization(DistributedSession session) {
        if (!this.isRemotelyInitialized()) {
            this.getAttributeAccessor().initializeAttributes(this.getDescriptor().getJavaClass());
            this.remotelyInitialized();
        }
    }

    @Override
    public Map replaceValueHoldersIn(Object object, RemoteSessionController controller) {
        return null;
    }

    protected void setDeleteQuery(ModifyQuery query) {
        this.changeSetDeleteQuery = query;
    }

    public void setDeleteSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomDeleteQuery(query);
    }

    @Override
    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        ((DataReadQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
    }

    public void setCustomDeleteQuery(ModifyQuery query) {
        this.setDeleteQuery(query);
        this.setHasCustomDeleteQuery(true);
    }

    public void setCustomInsertQuery(DataModifyQuery query) {
        this.setInsertQuery(query);
        this.setHasCustomInsertQuery(true);
    }

    public void setDirectField(DatabaseField field) {
        this.directField = field;
    }

    public void setDirectFieldClassification(Class fieldType) {
        this.getDirectField().setType(fieldType);
    }

    public void setDirectFieldName(String fieldName) {
        this.setDirectField(new DatabaseField(fieldName));
    }

    protected void setHasCustomDeleteQuery(boolean bool) {
        this.hasCustomDeleteQuery = bool;
    }

    protected void setHasCustomInsertQuery(boolean bool) {
        this.hasCustomInsertQuery = bool;
    }

    protected void setInsertQuery(DataModifyQuery insertQuery) {
        this.insertQuery = insertQuery;
    }

    public void setInsertSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomInsertQuery(query);
    }

    @Override
    public void setReferenceClass(Class referenceClass) {
    }

    @Override
    public void setReferenceClassName(String referenceClassName) {
    }

    public void setReferenceKeyFieldName(String fieldName) {
        this.getReferenceKeyFields().addElement(new DatabaseField(fieldName));
    }

    public void setReferenceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setReferenceKeyFields(fields);
    }

    public void setReferenceKeyFields(Vector<DatabaseField> aVector) {
        this.referenceKeyFields = aVector;
    }

    public void setReferenceTable(DatabaseTable table) {
        this.referenceTable = table;
    }

    public void setReferenceTableName(String tableName) {
        if (tableName == null) {
            this.setReferenceTable(null);
        } else {
            this.setReferenceTable(new DatabaseTable(tableName));
        }
    }

    @Override
    protected void setSelectionQueryContainerPolicy(ContainerPolicy containerPolicy) {
        ((DataReadQuery)this.getSelectionQuery()).setContainerPolicy(containerPolicy);
    }

    public void setHistoryPolicy(HistoryPolicy policy) {
        this.historyPolicy = policy;
        if (policy != null) {
            policy.setMapping(this);
        }
    }

    @Override
    public void setSessionName(String name) {
        super.setSessionName(name);
        this.getInsertQuery().setSessionName(name);
    }

    public void setSourceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceKeyFields(fields);
    }

    public void setSourceKeyFields(Vector<DatabaseField> sourceKeyFields) {
        this.sourceKeyFields = sourceKeyFields;
    }

    @Override
    public void calculateDeferredChanges(ChangeRecord changeRecord, AbstractSession session) {
        DirectCollectionChangeRecord collectionRecord = (DirectCollectionChangeRecord)changeRecord;
        this.compareCollectionsForChange(collectionRecord.getOriginalCollection(), collectionRecord.getLatestCollection(), collectionRecord, session);
    }

    @Override
    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object objectToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        DirectCollectionChangeRecord collectionChangeRecord = (DirectCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectCollectionChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            changeSet.addChange(collectionChangeRecord);
            Object collection = this.getRealAttributeValueFromObject(changeSet.getUnitOfWorkClone(), session);
            collectionChangeRecord.storeDatabaseCounts(collection, this.getContainerPolicy(), session);
        }
        collectionChangeRecord.addAdditionChange(objectToAdd, new Integer(1));
    }

    @Override
    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object objectToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        DirectCollectionChangeRecord collectionChangeRecord = (DirectCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectCollectionChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            changeSet.addChange(collectionChangeRecord);
            Object collection = this.getRealAttributeValueFromObject(changeSet.getUnitOfWorkClone(), session);
            collectionChangeRecord.storeDatabaseCounts(collection, this.getContainerPolicy(), session);
        }
        collectionChangeRecord.addRemoveChange(objectToRemove, new Integer(1));
    }

    @Override
    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        DirectCollectionChangeRecord collectionChangeRecord = (DirectCollectionChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectCollectionChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        if (collectionChangeRecord.getOriginalCollection() == null) {
            collectionChangeRecord.setOriginalCollection(oldValue);
        }
        collectionChangeRecord.setLatestCollection(newValue);
        collectionChangeRecord.setIsDeferred(true);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
    }

    @Override
    public void updateCollectionChangeRecord(CollectionChangeEvent event, ObjectChangeSet changeSet, UnitOfWorkImpl uow) {
        if (event != null) {
            Object key = null;
            if (event.getClass().equals(ClassConstants.MapChangeEvent_Class)) {
                key = ((MapChangeEvent)event).getKey();
            }
            if (event.getChangeType() == CollectionChangeEvent.ADD) {
                this.addToCollectionChangeRecord(key, event.getNewValue(), changeSet, uow);
            } else if (event.getChangeType() == CollectionChangeEvent.REMOVE) {
                this.removeFromCollectionChangeRecord(key, event.getNewValue(), changeSet, uow);
            } else {
                throw ValidationException.wrongCollectionChangeEventType(event.getChangeType());
            }
        }
    }

    @Override
    public void useCollectionClass(Class concreteClass) {
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(concreteClass);
        this.setContainerPolicy(policy);
    }

    @Override
    public void useMapClass(Class concreteClass, String methodName) {
        throw ValidationException.illegalUseOfMapInDirectCollection(this, concreteClass, methodName);
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession session) throws DatabaseException {
        if (sourceQuery.isReadAllQuery() && (((ReadAllQuery)sourceQuery).isAttributeBatchRead(this.getDescriptor(), this.getAttributeName()) || this.shouldUseBatchReading())) {
            return this.batchedValueFromRow(row, (ReadAllQuery)sourceQuery);
        }
        ReadQuery targetQuery = this.getSelectionQuery();
        if (this.getHistoryPolicy() != null || sourceQuery.getSession().getAsOfClause() != null || sourceQuery.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)sourceQuery).hasAsOfClause() && (sourceQuery.shouldCascadeAllParts() || sourceQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || sourceQuery.shouldCascadeByMapping() && this.cascadeRefresh)) {
            targetQuery = (ReadQuery)targetQuery.clone();
            SQLSelectStatement statement = new SQLSelectStatement();
            statement.addTable(this.getReferenceTable());
            statement.addField((DatabaseField)this.getDirectField().clone());
            if (this.isDirectMapMapping()) {
                statement.addField((DatabaseField)((DirectMapMapping)this).getDirectKeyField().clone());
            }
            statement.setWhereClause((Expression)this.getSelectionCriteria().clone());
            statement.getBuilder().asOf(((ObjectLevelReadQuery)sourceQuery).getAsOfClause());
            if (this.getHistoryPolicy() != null) {
                ExpressionBuilder builder = statement.getBuilder();
                if (sourceQuery.getSession().getAsOfClause() != null) {
                    builder.asOf(sourceQuery.getSession().getAsOfClause());
                } else if (builder.getAsOfClause() == null) {
                    builder.asOf(AsOfClause.NO_CLAUSE);
                }
                Expression temporalExpression = this.getHistoryPolicy().additionalHistoryExpression(builder);
                statement.setWhereClause(statement.getWhereClause().and(temporalExpression));
                if (builder.hasAsOfClause()) {
                    statement.getTables().set(0, this.getHistoryPolicy().getHistoricalTables().elementAt(0));
                }
            }
            statement.normalize(sourceQuery.getSession(), null);
            targetQuery.setSQLStatement(statement);
        }
        return this.getIndirectionPolicy().valueFromQuery(targetQuery, row, sourceQuery.getSession());
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isReadOnly()) {
            return true;
        }
        AbstractRecord row = this.getDescriptor().getObjectBuilder().buildRowForTranslation(object, session);
        Object value = session.executeQuery((DatabaseQuery)this.getSelectionQuery(), row);
        return this.getContainerPolicy().isEmpty(value);
    }

    @Override
    public void addToCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        if (newValue == null) {
            newValue = DirectCollectionChangeRecord.Null;
        }
        this.simpleAddToCollectionChangeRecord(newKey, newValue, objectChangeSet, uow);
    }

    @Override
    public boolean isCandidateForPrivateOwnedRemoval() {
        return false;
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    @Override
    public void removeFromCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        if (newValue == null) {
            newValue = DirectCollectionChangeRecord.Null;
        }
        this.simpleRemoveFromCollectionChangeRecord(newKey, newValue, objectChangeSet, uow);
    }
}

