/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.security.mapping;

import java.util.HashMap;
import java.util.Map;

public class JPolicyUserRoleMapping {
    public static final String GLOBAL_CTXID = "global";
    private static Map jaccIdMappings = new HashMap();

    private JPolicyUserRoleMapping() {
    }

    public static void addUserToRoleMapping(String contextId, String principalName, String[] roles) {
        HashMap<String, String[]> mapping = (HashMap<String, String[]>)jaccIdMappings.get(contextId);
        if (mapping == null) {
            mapping = new HashMap<String, String[]>();
            jaccIdMappings.put(contextId, mapping);
        }
        mapping.put(principalName, roles);
    }

    public static void addGlobalUserToRoleMapping(String principalName, String[] roles) {
        JPolicyUserRoleMapping.addUserToRoleMapping(GLOBAL_CTXID, principalName, roles);
    }

    public static String[] getMappingForPrincipal(String contextId, String principalName) {
        HashMap mapping = (HashMap)jaccIdMappings.get(contextId);
        if (mapping == null) {
            mapping = new HashMap();
            jaccIdMappings.put(contextId, mapping);
        }
        return (String[])mapping.get(principalName);
    }

    public static String[] getGlobalMappingForPrincipal(String principalName) {
        return JPolicyUserRoleMapping.getMappingForPrincipal(GLOBAL_CTXID, principalName);
    }

    public static void removeUserToRoleMapping(String contextId) {
        jaccIdMappings.remove(contextId);
    }
}

