/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanProcessor
extends ServiceSupport
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(BeanProcessor.class);
    private boolean multiParameterArray;
    private Method methodObject;
    private String method;
    private BeanHolder beanHolder;

    public BeanProcessor(Object pojo, BeanInfo beanInfo) {
        this(new ConstantBeanHolder(pojo, beanInfo));
    }

    public BeanProcessor(Object pojo, CamelContext camelContext, ParameterMappingStrategy parameterMappingStrategy) {
        this(pojo, new BeanInfo(camelContext, pojo.getClass(), parameterMappingStrategy));
    }

    public BeanProcessor(Object pojo, CamelContext camelContext) {
        this(pojo, camelContext, BeanInfo.createParameterMappingStrategy(camelContext));
    }

    public BeanProcessor(BeanHolder beanHolder) {
        this.beanHolder = beanHolder;
    }

    public String toString() {
        String description = this.methodObject != null ? " " + this.methodObject : "";
        return "BeanProcessor[" + this.beanHolder + description + "]";
    }

    public void process(Exchange exchange) throws Exception {
        MethodInvocation invocation;
        boolean isExplicitMethod = ObjectHelper.isNotEmpty(this.method);
        Object bean = this.beanHolder.getBean();
        BeanInfo beanInfo = this.beanHolder.getBeanInfo();
        Processor processor = this.getProcessor();
        if (!isExplicitMethod && processor != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Using a custom adapter as bean invocation: " + processor));
            }
            processor.process(exchange);
            return;
        }
        Message in = exchange.getIn();
        BeanInvocation beanInvoke = in.getBody(BeanInvocation.class);
        if (beanInvoke != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Exchange IN body is a BeanInvocation instance: " + beanInvoke));
            }
            Class<?> clazz = beanInvoke.getMethod().getDeclaringClass();
            boolean sameBean = clazz.isInstance(bean);
            if (LOG.isTraceEnabled()) {
                LOG.debug((Object)("BeanHolder bean: " + bean.getClass() + " and beanInvocation bean: " + clazz + " is same instance: " + sameBean));
            }
            if (sameBean) {
                beanInvoke.invoke(bean, exchange);
                exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
                return;
            }
        }
        if (in.getHeader("CamelBeanMultiParameterArray") == null) {
            in.setHeader("CamelBeanMultiParameterArray", this.isMultiParameterArray());
        }
        String prevMethod = null;
        if (this.methodObject != null) {
            invocation = beanInfo.createInvocation(this.methodObject, bean, exchange);
        } else {
            if (isExplicitMethod) {
                prevMethod = in.getHeader("CamelBeanMethodName", String.class);
                in.setHeader("CamelBeanMethodName", this.method);
            }
            invocation = beanInfo.createInvocation(bean, exchange);
        }
        if (invocation == null) {
            throw new IllegalStateException("No method invocation could be created, no matching method could be found on: " + bean);
        }
        in.removeHeader("CamelBeanMultiParameterArray");
        Object value = null;
        try {
            value = invocation.proceed();
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                throw exception;
            }
            Error error = (Error)throwable;
            throw error;
        }
        finally {
            if (isExplicitMethod) {
                in.setHeader("CamelBeanMethodName", prevMethod);
            }
        }
        if (!invocation.getMethod().getReturnType().equals(Void.TYPE) && value != Void.TYPE) {
            if (exchange.getPattern().isOutCapable()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Setting bean invocation result on the OUT message: " + value));
                }
                exchange.getOut().setBody(value);
                exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Setting bean invocation result on the IN message: " + value));
                }
                exchange.getIn().setBody(value);
            }
        }
    }

    protected Processor getProcessor() {
        return this.beanHolder.getProcessor();
    }

    public Method getMethodObject() {
        return this.methodObject;
    }

    public void setMethodObject(Method methodObject) {
        this.methodObject = methodObject;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isMultiParameterArray() {
        return this.multiParameterArray;
    }

    public void setMultiParameterArray(boolean mpArray) {
        this.multiParameterArray = mpArray;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService(this.getProcessor());
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.getProcessor());
    }
}

