/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFileProducer<T>
extends DefaultProducer {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected final GenericFileEndpoint<T> endpoint;
    protected final GenericFileOperations<T> operations;

    protected GenericFileProducer(GenericFileEndpoint<T> endpoint, GenericFileOperations<T> operations) {
        super(endpoint);
        this.endpoint = endpoint;
        this.operations = operations;
    }

    protected String getFileSeparator() {
        return File.separator;
    }

    protected String normalizePath(String name) {
        return FileUtil.normalizePath(name);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Exchange fileExchange = this.endpoint.createExchange(exchange);
        this.processExchange(fileExchange);
        ExchangeHelper.copyResults(exchange, fileExchange);
    }

    protected void processExchange(Exchange exchange) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Processing " + exchange));
        }
        try {
            String target = this.createFileName(exchange);
            this.preWriteCheck();
            boolean writeAsTempAndRename = ObjectHelper.isNotEmpty(this.endpoint.getTempFileName());
            String tempTarget = null;
            if (writeAsTempAndRename) {
                tempTarget = this.createTempFileName(exchange, target);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Writing using tempNameFile: " + tempTarget));
                }
                if (this.operations.existsFile(target)) {
                    if (this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("An existing file already exists: " + target + ". Ignore and do not override it."));
                        }
                        return;
                    }
                    if (this.endpoint.getFileExist() == GenericFileExist.Fail) {
                        throw new GenericFileOperationFailedException("File already exist: " + target + ". Cannot write new file.");
                    }
                    if (this.endpoint.getFileExist() == GenericFileExist.Override) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Deleting existing file: " + tempTarget));
                        }
                        if (!this.operations.deleteFile(target)) {
                            throw new GenericFileOperationFailedException("Cannot delete file: " + target);
                        }
                    }
                }
                if (this.operations.existsFile(tempTarget)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Deleting existing temp file: " + tempTarget));
                    }
                    if (!this.operations.deleteFile(tempTarget)) {
                        throw new GenericFileOperationFailedException("Cannot delete file: " + tempTarget);
                    }
                }
            }
            this.writeFile(exchange, tempTarget != null ? tempTarget : target);
            if (tempTarget != null) {
                boolean renamed;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Renaming file: [" + tempTarget + "] to: [" + target + "]"));
                }
                if (!(renamed = this.operations.renameFile(tempTarget, target))) {
                    throw new GenericFileOperationFailedException("Cannot rename file from: " + tempTarget + " to: " + target);
                }
            }
            exchange.getIn().setHeader("CamelFileNameProduced", target);
        }
        catch (Exception e) {
            this.handleFailedWrite(exchange, e);
        }
        this.postWriteCheck();
    }

    protected void handleFailedWrite(Exchange exchange, Exception exception) throws Exception {
        throw exception;
    }

    protected void preWriteCheck() throws Exception {
    }

    protected void postWriteCheck() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(Exchange exchange, String fileName) throws GenericFileOperationFailedException {
        InputStream payload = exchange.getIn().getBody(InputStream.class);
        try {
            boolean success;
            if (this.endpoint.isAutoCreate()) {
                File file = new File(fileName);
                String directory = file.getParent();
                boolean absolute = FileUtil.isAbsolute(file);
                if (directory != null && !this.operations.buildDirectory(directory, absolute) && this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Cannot build directory [" + directory + "] (could be because of denied permissions)"));
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("About to write [" + fileName + "] to [" + this.getEndpoint() + "] from exchange [" + exchange + "]"));
            }
            if (!(success = this.operations.storeFile(fileName, exchange))) {
                throw new GenericFileOperationFailedException("Error writing file [" + fileName + "]");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Wrote [" + fileName + "] to [" + this.getEndpoint() + "]"));
            }
        }
        finally {
            ObjectHelper.close(payload, "Closing payload", this.log);
        }
    }

    protected String createFileName(Exchange exchange) {
        String name = exchange.getIn().getHeader("CamelFileName", String.class);
        Expression expression = this.endpoint.getFileName();
        if (name != null && name.indexOf("${") > -1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("CamelFileName contains a FileLanguage expression: " + name));
            }
            Language language = this.getEndpoint().getCamelContext().resolveLanguage("file");
            expression = language.createExpression(name);
        }
        if (expression != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Filename evaluated as expression: " + expression));
            }
            name = expression.evaluate(exchange, String.class);
        }
        if (name != null && this.endpoint.isFlatten()) {
            int pos = name.lastIndexOf(this.getFileSeparator());
            if (pos == -1) {
                pos = name.lastIndexOf(47);
            }
            if (pos != -1) {
                name = name.substring(pos + 1);
            }
        }
        String endpointPath = this.endpoint.getConfiguration().getDirectory();
        String baseDir = "";
        if (endpointPath.length() > 0) {
            baseDir = endpointPath + (endpointPath.endsWith(this.getFileSeparator()) ? "" : this.getFileSeparator());
        }
        String answer = name != null ? baseDir + name : baseDir + this.endpoint.getGeneratedFileName(exchange.getIn());
        answer = this.normalizePath(answer);
        return answer;
    }

    protected String createTempFileName(Exchange exchange, String fileName) {
        String tempName;
        fileName = this.normalizePath(fileName);
        if (exchange.getIn().getHeader("CamelFileName") == null) {
            exchange.getIn().setHeader("CamelFileName", FileUtil.stripPath(fileName));
            tempName = this.endpoint.getTempFileName().evaluate(exchange, String.class);
            exchange.getIn().removeHeader("CamelFileName");
        } else {
            tempName = this.endpoint.getTempFileName().evaluate(exchange, String.class);
        }
        int path = fileName.lastIndexOf(this.getFileSeparator());
        if (path == -1) {
            return tempName;
        }
        StringBuilder sb = new StringBuilder(fileName.substring(0, path + 1));
        sb.append(tempName);
        return sb.toString();
    }
}

