/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="onException")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OnExceptionDefinition
extends ProcessorDefinition<ProcessorDefinition> {
    @XmlElement(name="exception")
    private List<String> exceptions = new ArrayList<String>();
    @XmlElement(name="onWhen", required=false)
    private WhenDefinition onWhen;
    @XmlElement(name="retryUntil", required=false)
    private ExpressionSubElementDefinition retryUntil;
    @XmlElement(name="redeliveryPolicy", required=false)
    private RedeliveryPolicyDefinition redeliveryPolicy;
    @XmlElement(name="handled", required=false)
    private ExpressionSubElementDefinition handled;
    @XmlAttribute(name="onRedeliveryRef", required=false)
    private String onRedeliveryRef;
    @XmlAttribute(name="useOriginalMessage", required=false)
    private Boolean useOriginalMessagePolicy = Boolean.FALSE;
    @XmlElementRef
    private List<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();
    @XmlTransient
    private List<Class> exceptionClasses;
    @XmlTransient
    private Processor errorHandler;
    @XmlTransient
    private Predicate handledPolicy;
    @XmlTransient
    private Predicate retryUntilPolicy;
    @XmlTransient
    private Processor onRedelivery;

    public OnExceptionDefinition() {
    }

    public OnExceptionDefinition(List<Class> exceptionClasses) {
        this.exceptionClasses = CastUtils.cast(exceptionClasses);
    }

    public OnExceptionDefinition(Class exceptionType) {
        this.exceptionClasses = new ArrayList<Class>();
        this.exceptionClasses.add(exceptionType);
    }

    @Override
    public String getShortName() {
        return "onException";
    }

    public String toString() {
        return "OnException[" + this.getExceptionClasses() + (this.onWhen != null ? " " + this.onWhen : "") + " -> " + this.getOutputs() + "]";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    public RedeliveryPolicy createRedeliveryPolicy(CamelContext context, RedeliveryPolicy parentPolicy) {
        if (this.redeliveryPolicy != null) {
            return this.redeliveryPolicy.createRedeliveryPolicy(context, parentPolicy);
        }
        if (this.errorHandler != null) {
            RedeliveryPolicy answer = parentPolicy.copy();
            answer.setMaximumRedeliveries(0);
            return answer;
        }
        return parentPolicy;
    }

    @Override
    public void addRoutes(RouteContext routeContext, Collection<Route> routes) throws Exception {
        this.setHandledFromExpressionType(routeContext);
        this.setRetryUntilFromExpressionType(routeContext);
        if (ObjectHelper.isNotEmpty(this.onRedeliveryRef)) {
            this.setOnRedelivery(routeContext.lookup(this.onRedeliveryRef, Processor.class));
        }
        this.errorHandler = routeContext.createProcessor(this);
        ErrorHandlerBuilder builder = routeContext.getRoute().getErrorHandlerBuilder();
        builder.addErrorHandlers(this);
    }

    @Override
    public CatchProcessor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = routeContext.createProcessor(this);
        Predicate when = null;
        if (this.onWhen != null) {
            when = this.onWhen.getExpression().createPredicate(routeContext);
        }
        Predicate handle = null;
        if (this.handled != null) {
            handle = this.handled.createPredicate(routeContext);
        }
        return new CatchProcessor(this.getExceptionClasses(), childProcessor, when, handle);
    }

    @Override
    public OnExceptionDefinition onException(Class exceptionType) {
        this.getExceptionClasses().add(exceptionType);
        return this;
    }

    public OnExceptionDefinition handled(boolean handled) {
        Expression expression = ExpressionBuilder.constantExpression(Boolean.toString(handled));
        return this.handled(expression);
    }

    public OnExceptionDefinition handled(Predicate handled) {
        this.setHandledPolicy(handled);
        return this;
    }

    public OnExceptionDefinition handled(Expression handled) {
        this.setHandledPolicy(PredicateBuilder.toPredicate(handled));
        return this;
    }

    public OnExceptionDefinition onWhen(Predicate predicate) {
        this.setOnWhen(new WhenDefinition(predicate));
        return this;
    }

    public ExpressionClause<OnExceptionDefinition> onWhen() {
        this.onWhen = new WhenDefinition();
        ExpressionClause<OnExceptionDefinition> clause = new ExpressionClause<OnExceptionDefinition>(this);
        this.onWhen.setExpression(clause);
        return clause;
    }

    public OnExceptionDefinition retryUntil(Predicate until) {
        this.setRetryUntilPolicy(until);
        return this;
    }

    public OnExceptionDefinition retryUntil(Expression until) {
        this.setRetryUntilPolicy(PredicateBuilder.toPredicate(until));
        return this;
    }

    public OnExceptionDefinition redeliverDelay(long delay) {
        this.getOrCreateRedeliveryPolicy().redeliveryDelay(delay);
        return this;
    }

    public OnExceptionDefinition backOffMultiplier(double backOffMultiplier) {
        this.getOrCreateRedeliveryPolicy().backOffMultiplier(backOffMultiplier);
        return this;
    }

    public OnExceptionDefinition collisionAvoidanceFactor(double collisionAvoidanceFactor) {
        this.getOrCreateRedeliveryPolicy().collisionAvoidanceFactor(collisionAvoidanceFactor);
        return this;
    }

    public OnExceptionDefinition collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.getOrCreateRedeliveryPolicy().collisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    public OnExceptionDefinition redeliveryDelay(long delay) {
        this.getOrCreateRedeliveryPolicy().redeliveryDelay(delay);
        return this;
    }

    public OnExceptionDefinition retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.getOrCreateRedeliveryPolicy().retriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public OnExceptionDefinition retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.getOrCreateRedeliveryPolicy().retryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public OnExceptionDefinition maximumRedeliveries(int maximumRedeliveries) {
        this.getOrCreateRedeliveryPolicy().maximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public OnExceptionDefinition useCollisionAvoidance() {
        this.getOrCreateRedeliveryPolicy().useCollisionAvoidance();
        return this;
    }

    public OnExceptionDefinition useExponentialBackOff() {
        this.getOrCreateRedeliveryPolicy().useExponentialBackOff();
        return this;
    }

    public OnExceptionDefinition maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.getOrCreateRedeliveryPolicy().maximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public OnExceptionDefinition useOriginalBody() {
        this.setUseOriginalMessagePolicy(Boolean.TRUE);
        return this;
    }

    public OnExceptionDefinition onRedelivery(Processor processor) {
        this.setOnRedelivery(processor);
        return this;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition> outputs) {
        this.outputs = outputs;
    }

    public List<Class> getExceptionClasses() {
        if (this.exceptionClasses == null) {
            this.exceptionClasses = this.createExceptionClasses();
        }
        return this.exceptionClasses;
    }

    public void setExceptionClasses(List<Class> exceptionClasses) {
        this.exceptionClasses = exceptionClasses;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    public RedeliveryPolicyDefinition getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicyDefinition redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public Predicate getHandledPolicy() {
        return this.handledPolicy;
    }

    public void setHandled(ExpressionSubElementDefinition handled) {
        this.handled = handled;
    }

    public ExpressionSubElementDefinition getHandled() {
        return this.handled;
    }

    public void setHandledPolicy(Predicate handledPolicy) {
        this.handledPolicy = handledPolicy;
    }

    public WhenDefinition getOnWhen() {
        return this.onWhen;
    }

    public void setOnWhen(WhenDefinition onWhen) {
        this.onWhen = onWhen;
    }

    public ExpressionSubElementDefinition getRetryUntil() {
        return this.retryUntil;
    }

    public void setRetryUntil(ExpressionSubElementDefinition retryUntil) {
        this.retryUntil = retryUntil;
    }

    public Predicate getRetryUntilPolicy() {
        return this.retryUntilPolicy;
    }

    public void setRetryUntilPolicy(Predicate retryUntilPolicy) {
        this.retryUntilPolicy = retryUntilPolicy;
    }

    public Processor getOnRedelivery() {
        return this.onRedelivery;
    }

    public void setOnRedelivery(Processor onRedelivery) {
        this.onRedelivery = onRedelivery;
    }

    public String getOnRedeliveryRef() {
        return this.onRedeliveryRef;
    }

    public void setOnRedeliveryRef(String onRedeliveryRef) {
        this.onRedeliveryRef = onRedeliveryRef;
    }

    public Boolean getUseOriginalMessagePolicy() {
        return this.useOriginalMessagePolicy;
    }

    public void setUseOriginalMessagePolicy(Boolean useOriginalMessagePolicy) {
        this.useOriginalMessagePolicy = useOriginalMessagePolicy;
    }

    protected RedeliveryPolicyDefinition getOrCreateRedeliveryPolicy() {
        if (this.redeliveryPolicy == null) {
            this.redeliveryPolicy = new RedeliveryPolicyDefinition();
        }
        return this.redeliveryPolicy;
    }

    protected List<Class> createExceptionClasses() {
        List<String> list = this.getExceptions();
        ArrayList<Class> answer = new ArrayList<Class>(list.size());
        for (String name : list) {
            Class<Throwable> type = CastUtils.cast(ObjectHelper.loadClass(name, this.getClass().getClassLoader()), Throwable.class);
            answer.add(type);
        }
        return answer;
    }

    private void setHandledFromExpressionType(RouteContext routeContext) {
        if (this.getHandled() != null && this.handledPolicy == null && routeContext != null) {
            this.handled(this.getHandled().createPredicate(routeContext));
        }
    }

    private void setRetryUntilFromExpressionType(RouteContext routeContext) {
        if (this.getRetryUntil() != null && this.retryUntilPolicy == null && routeContext != null) {
            this.retryUntil(this.getRetryUntil().createPredicate(routeContext));
        }
    }
}

