/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultRouteContext;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.processor.interceptor.StreamCaching;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.util.CamelContextHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="route")
@XmlType(propOrder={"inputs", "outputs"})
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class RouteDefinition
extends ProcessorDefinition<ProcessorDefinition>
implements CamelContextAware {
    private List<FromDefinition> inputs = new ArrayList<FromDefinition>();
    private List<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();
    private CamelContext camelContext;
    private String group;
    private Boolean streamCache;
    private Boolean trace;
    private Boolean handleFault;
    private Long delayer;
    private Boolean autoStartup = Boolean.TRUE;
    private Integer startupOrder;
    private RoutePolicy routePolicy;
    private String routePolicyRef;
    private ShutdownRoute shutdownRoute;
    private ShutdownRunningTask shutdownRunningTask;

    public RouteDefinition() {
    }

    public RouteDefinition(String uri) {
        this.from(uri);
    }

    public RouteDefinition(Endpoint endpoint) {
        this.from(endpoint);
    }

    public String toString() {
        return "Route[" + this.inputs + " -> " + this.outputs + "]";
    }

    @Override
    public String getShortName() {
        return "route";
    }

    public ServiceStatus getStatus() {
        if (this.camelContext != null) {
            ServiceStatus answer = this.camelContext.getRouteStatus(this.getId());
            if (answer == null) {
                answer = ServiceStatus.Stopped;
            }
            return answer;
        }
        return null;
    }

    public boolean isStartable() {
        ServiceStatus status = this.getStatus();
        if (status == null) {
            return true;
        }
        return status.isStartable();
    }

    public boolean isStoppable() {
        ServiceStatus status = this.getStatus();
        if (status == null) {
            return false;
        }
        return status.isStoppable();
    }

    public List<RouteContext> addRoutes(CamelContext context, Collection<Route> routes) throws Exception {
        ArrayList<RouteContext> answer = new ArrayList<RouteContext>();
        this.setCamelContext(context);
        ErrorHandlerBuilder handler = context.getErrorHandlerBuilder();
        if (handler != null) {
            this.setErrorHandlerBuilderIfNull(handler);
        }
        for (FromDefinition fromType : this.inputs) {
            RouteContext routeContext;
            try {
                routeContext = this.addRoutes(routes, fromType);
            }
            catch (FailedToCreateRouteException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FailedToCreateRouteException(this.getId(), this.toString(), e);
            }
            answer.add(routeContext);
        }
        return answer;
    }

    public Endpoint resolveEndpoint(String uri) throws NoSuchEndpointException {
        CamelContext context = this.getCamelContext();
        if (context == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        return CamelContextHelper.getMandatoryEndpoint(context, uri);
    }

    public RouteDefinition adviceWith(RouteBuilder builder) throws Exception {
        CamelContext context = this.getCamelContext();
        if (context == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        RoutesDefinition routes = builder.configureRoutes(context);
        if (!routes.getRoutes().isEmpty()) {
            throw new IllegalArgumentException("You can only advice from a RouteBuilder which has no existing routes. Remove all routes from the route builder.");
        }
        ArrayList<RouteDefinition> list = new ArrayList<RouteDefinition>();
        list.add(this);
        context.removeRouteDefinitions(list);
        RouteDefinition merged = routes.route(this);
        context.getRouteDefinitions().add(0, merged);
        context.startRoute(merged);
        return merged;
    }

    public RouteDefinition from(String uri) {
        this.getInputs().add(new FromDefinition(uri));
        return this;
    }

    public RouteDefinition from(Endpoint endpoint) {
        this.getInputs().add(new FromDefinition(endpoint));
        return this;
    }

    public RouteDefinition from(String ... uris) {
        for (String uri : uris) {
            this.getInputs().add(new FromDefinition(uri));
        }
        return this;
    }

    public RouteDefinition from(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.getInputs().add(new FromDefinition(endpoint));
        }
        return this;
    }

    public RouteDefinition group(String name) {
        this.setGroup(name);
        return this;
    }

    @Override
    public RouteDefinition routeId(String id) {
        this.setId(id);
        return this;
    }

    public RouteDefinition noStreamCaching() {
        this.setStreamCache(Boolean.FALSE);
        StreamCaching.noStreamCaching(this.getInterceptStrategies());
        return this;
    }

    public RouteDefinition streamCaching() {
        this.setStreamCache(Boolean.TRUE);
        StreamCaching cache = StreamCaching.getStreamCaching(this.getCamelContext());
        if (cache == null) {
            cache = new StreamCaching();
        }
        this.getInterceptStrategies().add(cache);
        return this;
    }

    public RouteDefinition noTracing() {
        this.setTrace(false);
        return this;
    }

    public RouteDefinition tracing() {
        this.setTrace(true);
        return this;
    }

    public RouteDefinition noHandleFault() {
        this.setHandleFault(false);
        return this;
    }

    public RouteDefinition handleFault() {
        this.setHandleFault(true);
        return this;
    }

    public RouteDefinition noDelayer() {
        this.setDelayer(0L);
        return this;
    }

    public RouteDefinition delayer(long delay) {
        this.setDelayer(delay);
        return this;
    }

    public RouteDefinition errorHandler(ErrorHandlerBuilder errorHandlerBuilder) {
        this.setErrorHandlerBuilder(errorHandlerBuilder);
        return this;
    }

    public RouteDefinition noAutoStartup() {
        this.setAutoStartup(Boolean.FALSE);
        return this;
    }

    public RouteDefinition startupOrder(int order) {
        this.setStartupOrder(order);
        return this;
    }

    public RouteDefinition routePolicy(RoutePolicy routePolicy) {
        this.setRoutePolicy(routePolicy);
        return this;
    }

    public RouteDefinition routePolicyRef(String routePolicyRef) {
        this.setRoutePolicyRef(routePolicyRef);
        return this;
    }

    public RouteDefinition shutdownRoute(ShutdownRoute shutdownRoute) {
        this.setShutdownRoute(shutdownRoute);
        return this;
    }

    public RouteDefinition shutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.setShutdownRunningTask(shutdownRunningTask);
        return this;
    }

    public List<FromDefinition> getInputs() {
        return this.inputs;
    }

    @XmlElementRef
    public void setInputs(List<FromDefinition> inputs) {
        this.inputs = inputs;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return this.outputs;
    }

    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition> outputs) {
        this.outputs = outputs;
        if (outputs != null) {
            for (ProcessorDefinition output : outputs) {
                this.configureChild(output);
            }
        }
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    @XmlTransient
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getGroup() {
        return this.group;
    }

    @XmlAttribute
    public void setGroup(String group) {
        this.group = group;
    }

    public Boolean isStreamCache() {
        return this.streamCache;
    }

    @XmlAttribute
    public void setStreamCache(Boolean streamCache) {
        this.streamCache = streamCache;
    }

    public Boolean isTrace() {
        return this.trace;
    }

    @XmlAttribute
    public void setTrace(Boolean trace) {
        this.trace = trace;
    }

    public Boolean isHandleFault() {
        return this.handleFault;
    }

    @XmlAttribute
    public void setHandleFault(Boolean handleFault) {
        this.handleFault = handleFault;
    }

    public Long getDelayer() {
        return this.delayer;
    }

    @XmlAttribute
    public void setDelayer(Long delayer) {
        this.delayer = delayer;
    }

    public Boolean isAutoStartup() {
        return this.autoStartup;
    }

    @XmlAttribute
    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public Integer getStartupOrder() {
        return this.startupOrder;
    }

    @XmlAttribute
    public void setStartupOrder(Integer startupOrder) {
        this.startupOrder = startupOrder;
    }

    @XmlAttribute
    public void setErrorHandlerRef(String errorHandlerRef) {
        this.errorHandlerRef = errorHandlerRef;
        this.setErrorHandlerBuilder(new ErrorHandlerBuilderRef(errorHandlerRef));
    }

    public String getErrorHandlerRef() {
        return this.errorHandlerRef;
    }

    protected void setErrorHandlerBuilderIfNull(ErrorHandlerBuilder errorHandlerBuilder) {
        if (this.errorHandlerBuilder == null) {
            this.setErrorHandlerBuilder(errorHandlerBuilder);
        }
    }

    @XmlAttribute
    public void setRoutePolicyRef(String routePolicyRef) {
        this.routePolicyRef = routePolicyRef;
    }

    public String getRoutePolicyRef() {
        return this.routePolicyRef;
    }

    @XmlTransient
    public void setRoutePolicy(RoutePolicy routePolicy) {
        this.routePolicy = routePolicy;
    }

    public RoutePolicy getRoutePolicy() {
        return this.routePolicy;
    }

    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    @XmlAttribute
    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    @XmlAttribute
    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    protected RouteContext addRoutes(Collection<Route> routes, FromDefinition fromType) throws Exception {
        DefaultRouteContext routeContext = new DefaultRouteContext(this.getCamelContext(), this, fromType, routes);
        if (this.trace != null) {
            routeContext.setTracing(this.isTrace());
            if (this.isTrace().booleanValue() && this.log.isDebugEnabled()) {
                this.log.debug((Object)("Tracing is enabled on route: " + this));
            }
        }
        if (this.streamCache != null) {
            routeContext.setStreamCaching(this.isStreamCache());
            if (this.isStreamCache().booleanValue()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("StreamCaching is enabled on route: " + this));
                }
                if (StreamCaching.getStreamCaching(this.getCamelContext()) == null) {
                    this.addInterceptStrategy(new StreamCaching());
                }
            }
        }
        if (this.handleFault != null) {
            routeContext.setHandleFault(this.isHandleFault());
            if (this.isHandleFault().booleanValue()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("HandleFault is enabled on route: " + this));
                }
                if (HandleFault.getHandleFault(this.getCamelContext()) == null) {
                    this.addInterceptStrategy(new HandleFault());
                }
            }
        }
        if (this.delayer != null) {
            routeContext.setDelayer(this.getDelayer());
            if (this.getDelayer() != null) {
                long millis = this.getDelayer();
                if (millis > 0L) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Delayer is enabled with: " + millis + " ms. on route: " + this));
                    }
                    this.addInterceptStrategy(new Delayer(millis));
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Delayer is disabled on route: " + this));
                }
            }
        }
        if (this.routePolicy != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RoutePolicy is enabled: " + this.routePolicy + " on route: " + this));
            }
            routeContext.setRoutePolicy(this.getRoutePolicy());
        } else if (this.routePolicyRef != null) {
            RoutePolicy policy = CamelContextHelper.mandatoryLookup(this.getCamelContext(), this.routePolicyRef, RoutePolicy.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RoutePolicy is enabled: " + policy + " on route: " + this));
            }
            routeContext.setRoutePolicy(policy);
        }
        if (this.autoStartup != null) {
            routeContext.setAutoStartup(this.isAutoStartup());
        }
        if (this.shutdownRoute != null) {
            routeContext.setShutdownRoute(this.getShutdownRoute());
        }
        if (this.shutdownRunningTask != null) {
            routeContext.setShutdownRunningTask(this.getShutdownRunningTask());
        }
        routeContext.setInterceptStrategies(this.getInterceptStrategies());
        routeContext.getEndpoint();
        if (this.camelContext != null) {
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onRouteContextCreate(routeContext);
            }
        }
        ArrayList<ProcessorDefinition> list = new ArrayList<ProcessorDefinition>(this.outputs);
        for (ProcessorDefinition output : list) {
            try {
                output.addRoutes(routeContext, routes);
            }
            catch (Exception e) {
                RouteDefinition route = routeContext.getRoute();
                throw new FailedToCreateRouteException(route.getId(), route.toString(), output.toString(), e);
            }
        }
        routeContext.commit();
        return routeContext;
    }
}

