/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.processor.SendAsyncProcessor;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="to")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ToDefinition
extends SendDefinition<ToDefinition> {
    @XmlTransient
    private final List<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();
    @XmlAttribute(required=false)
    private ExchangePattern pattern;
    @XmlAttribute(required=false)
    private Boolean async = Boolean.FALSE;
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute(required=false)
    private String executorServiceRef;
    @XmlAttribute(required=false)
    private Integer poolSize;

    public ToDefinition() {
    }

    public ToDefinition(String uri) {
        this.setUri(uri);
    }

    public ToDefinition(Endpoint endpoint) {
        this.setEndpoint(endpoint);
    }

    public ToDefinition(String uri, ExchangePattern pattern) {
        this(uri);
        this.pattern = pattern;
    }

    public ToDefinition(Endpoint endpoint, ExchangePattern pattern) {
        this(endpoint);
        this.pattern = pattern;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return this.outputs;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (this.async == null || !this.async.booleanValue()) {
            return super.createProcessor(routeContext);
        }
        if (this.executorServiceRef != null) {
            this.executorService = routeContext.lookup(this.executorServiceRef, ExecutorService.class);
        }
        if (this.executorService == null && this.poolSize != null) {
            this.executorService = ExecutorServiceHelper.newScheduledThreadPool(this.poolSize, "ToAsync[" + this.getLabel() + "]", true);
        }
        Processor childProcessor = routeContext.createProcessor(this);
        UnitOfWorkProcessor uow = new UnitOfWorkProcessor(routeContext, childProcessor);
        Endpoint endpoint = this.resolveEndpoint(routeContext);
        SendAsyncProcessor async = new SendAsyncProcessor(endpoint, this.getPattern(), uow);
        if (this.executorService != null) {
            async.setExecutorService(this.executorService);
        }
        if (this.poolSize != null) {
            async.setPoolSize(this.poolSize);
        }
        return async;
    }

    public String toString() {
        if (this.async != null && this.async.booleanValue()) {
            return "ToAsync[" + this.getLabel() + "] -> " + this.getOutputs();
        }
        return "To[" + this.getLabel() + "]";
    }

    @Override
    public String getShortName() {
        return "to";
    }

    @Override
    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public Boolean isAsync() {
        return this.async;
    }

    public void setAsync(Boolean async) {
        this.async = async;
    }

    public Integer getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(Integer poolSize) {
        this.poolSize = poolSize;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public ToDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public ToDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public ToDefinition poolSize(int poolSize) {
        this.setPoolSize(poolSize);
        return this;
    }
}

